#ifndef PIWINDOWGEN_H_SEEN
#define PIWINDOWGEN_H_SEEN

#include "pisysdep.h"

#include PICONT_H

enum PIWindowKind {
  PIWK_normal = 0,
  PIWK_dialog = 1,
  PIWK_transient = 2,
  PIWK_floating = 3
};

class PIWindowGen : public PIContainer {
public:
  enum {ClassId = 1550};
		    PIWindowGen(PIMsgHandler* par, const char *nom, PIWindowKind k=PIWK_normal,
                                int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PIWindowGen();

  virtual long      kind() {return ClassId; }

  virtual void      PSPrint(PSFile *psf, int ofx=0, int ofy=0);

  inline  void      AutoHideOnClose(bool ahc=true) { mAHC = ahc; }

  virtual void      Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
  
protected:  
  PIWindowKind	       mWtyp;
  bool                 mAHC;
};


#endif
