// Module PI : Peida Interactive     PIList
// Liste                                     96-97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "pilistgen.h"

//++
// Class	PIList
// Lib		PI
// include	pilistgen.h
//
//	Composant graphique de type liste, permettant d'afficher une liste 
//	d'lments, qui peuvent tre slectionns  l'aide du pointeur (souris). 
//	"PIListGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PIList" dclare dans le fichier
//	entte "PILIST_H". Lors de la slection d'un des lments, 
//	le message correspondant complt par "PIMsg_Select" est envoy.
//	Le modifier "PIMsg_ClearSel" est appliqu lorsque d'une d-slection.
//--
//++
// Links	Parents
// PIWdg
//--

//++
// Titre	Constructeur
//--
//++
// PIListGen(PIContainerGen* par, const char* nom, int sx=100, int sy=100, int px=0, int py=0)
//	Cration d'un objet liste (PIList). 
//--

//++
// Titre	Ajout et suppression d'lments
//--
//++
// void  AppendItem(char* nom, PIMessage msg)
//	Ajoute un lment  la liste.
// void  DeleteItem(const char *item)
//	Supprime l'lment "item" de la liste.
// void  DeleteItemMsg(PIMessage msg)
//	Supprime l'lment identifi par le message "msg" de la liste.
// void  DeleteAllItems()
//	Supprime tous les lments
// int	GetNbItems()
//	Renvoie le nombre d'lments de la liste
// PIMessage  GetItemMsg(int n)
//	Renvoie le message de l'lment "n"
// string  GetItem(int n)
//	Renvoie le texte de l'lment "n"
//--
//++
// Titre	Gestion des slections
//--
//++
// void  SetMultipleSelect(bool ms=false)
//	Active ("ms=true") ou dsactive la possibilit de slection multiple.
// int   GetNbSelection()
//	Renvoie le nombre d'lments slectionns.
// PIMessage  GetSelection(int num=0)
//	Renvoie le message correspondant  la slection numro "n". L'ordre 
//	dans lequel les slections sont retournes est indfini.
// string   GetSelectionStr(int num=0)
//	Renvoie la chane de caractres correspondant  l'lment slectionn 
//	numro "n".
// void  SelectItem(const char* item)
//	Permet de slectionner l'lment "item".
// void  SelectItemMsg(PIMessage msg)
//	Permet de slectionner l'lment identifi par le message "msg".
// void  ClearSelItem(const char* item)
//	Efface la slection pour l'lment "item".
// void  ClearSelItemMsg(PIMessage msg)
//	Efface la slection pour l'lment identifi par le message "msg".
//--

PIListGen::PIListGen(PIContainerGen *par, const char *nom,
                     int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)
{}

PIListGen::~PIListGen()
{}
