#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "machdefs.h"
#include "fmath.h"

#include "convlim.h"
#include "nomfits.h"
#include "nomfits2.h"
#include "datime.h"

#include "fsvst.h"

static float flog10(float x) { return (float)log10((double)x); }
 
int COMPTE_FLUXCAL_BAD = 0;

/* Nouvelle-Fonction */
float FluxCalibre(float fluxb, int typcal, float *pcal)
/*  Calibration relative de flux    */
{
float lfb,r,dlfb;
double det;

switch (typcal)
  {
  case 1:
  case 10:
    r = pcal[0]+pcal[1]*fluxb;
    break;

  case 11:
    r = 0.;
    if( fabsf(pcal[4]) < 1.e-19 ) {
      if( fabsf((double) pcal[3]) < 1.e-19 ) break;
      r = (fluxb-pcal[2])/pcal[3];
      break;
    }
    lfb = pcal[0]+pcal[1]*fluxb;
    det = pcal[3]*pcal[3]-4.*pcal[4]*(pcal[2]-fluxb);
    if( det > 0 ) {
      r    = (-pcal[3]+sqrt(det))/(2.*pcal[4]);
      dlfb = (-pcal[3]-sqrt(det))/(2.*pcal[4]);
      if( fabsf(dlfb-lfb) < fabsf(r-lfb) ) r = dlfb;
    } else if ( det == 0. ) r = -pcal[3]/pcal[4];
    break;

  case 20:
    lfb = (fluxb>0.1) ? flog10(fluxb) : -1.0;
    if (lfb > pcal[2])
      r = pcal[0]+pcal[1]*lfb;
    else 
      { dlfb = lfb-pcal[2]; 
      r = pcal[0]+pcal[1]*pcal[2]+dlfb*(pcal[3]+dlfb*pcal[4]);
      }
    r *= fluxb;
    break;

  case 30:
    r = pcal[0]+pcal[1]*fluxb;
    dlfb = fluxb - pcal[2];
    if (dlfb < 0.)  r += pcal[3]*dlfb*dlfb;
    break;

  case 40:
    lfb = (fluxb>1.) ? flog10(fluxb) : 0.;
    if (lfb > pcal[2])   r = pcal[0]+lfb*pcal[1];
    else
      { dlfb = (lfb < pcal[5]) ? (pcal[5]-pcal[2])  
                               : (lfb-pcal[2]) ;
      r = pcal[4]+dlfb*pcal[3]; } 
    r *= fluxb;
    break;

  case 41:
    lfb = (fluxb>1.) ? flog10(fluxb) : 0.;
    lfb = (lfb > pcal[5]) ? lfb : pcal[5];
    r = pcal[0]+lfb*pcal[1];
    r *= fluxb;
    break;

  case 80:
    r = pcal[0]+pcal[1]*fluxb;
    break;

  case 91:
    r = 0.;
    if(fluxb>=pcal[1]) {
      /* cas des flux brillants */
      if( pcal[4] <= 0. ) break;
      r = (fluxb-pcal[1])/pcal[4] + pcal[0];
    } else if(fluxb<=pcal[3]) {
      /* cas des flux faibles */
      if( pcal[7] <= 0. ) break;
      r = (fluxb-pcal[3])/pcal[7] + pcal[2];
    } else {
      /* cas des flux moyens */
      if( pcal[5] <= 0. ) break;
      if( pcal[6] == 0.) {
        /* pas de terme en x**2 */
        r = (fluxb-pcal[3])/pcal[5] + pcal[2];
      } else {
        /* terme en x**2 non nul */
        det = -4.*pcal[6]*(pcal[3]-fluxb)/(pcal[5]*pcal[5]);
        if( fabs(det) < 0.0001 ) {
          /* cas d'une correction x**2 petite, DL de sqrt() */
          r = pcal[5]/(4.*pcal[6]) * det*(1.-det/4.) + pcal[2];
        } else {
          /* cas de la resolution normale de l'equation du 2sd */
          det += 1.;
          if(det<0.) break;
          det = sqrt(det);
          r = pcal[5]/(2.*pcal[6])*(-1.+det) + pcal[2];
          if( r<pcal[2] || r>pcal[0] )  /* autre solution ?? */
              r = pcal[5]/(2.*pcal[6])*(-1.-det) + pcal[2];
	}
      }
    }
    break;

  default:
    if( COMPTE_FLUXCAL_BAD < 50 )
      printf("FluxCalibre_Erreur: Type calibration (%d) Non prevue !\n", typcal);
    COMPTE_FLUXCAL_BAD++;
    r = 0.;
    break;
  
  }

 /* printf("FluxCalibre: fluxb=%g -> %g typcal=%d pcal=%g %g %g %g %g\n"
      ,fluxb,r,typcal,pcal[0],pcal[1],pcal[2],pcal[3],pcal[4]); */

return(r);

}


/* Nouvelle-Fonction */
float ErrCalibre(float efluxb, float fluxb,float fluxc,float *pfite)
/*                                Christophe 1/2/95          */
/*  Calibration de l'erreur sur le flux calibre              */
/* efluxb = erreur sur le flux brut                          */
/* fluxb = flux brut                                         */
/* fluxc = flux calibre                                      */
/* pfite = tableau des fct erreurs externes et erreurs peida */
/* RETURN: erreur sur le flux calibre                        */
{
float eflux,mfr,errext,errfit;
double ex;

eflux = 0.;

if(efluxb==0.) return(0.);
if(efluxb<0.) efluxb *= -1.;
if( fluxb==0. || fluxc==0. ) return(efluxb);
if( fluxb<0.  || fluxc<0.  ) {
  eflux = efluxb * fluxc / fluxb;
  if(eflux<0.) return(-eflux); else return(eflux);
}

mfr = 2.5*flog10(fluxc);

errext = 0.;
ex = pfite[0]-pfite[1]*mfr;
if(pfite[1]>0. && ex<80.) errext += exp(ex)+pfite[2];
if(errext<=0.)  return (eflux);
ex = pfite[3]-pfite[4]*mfr;
if(pfite[4]>0. && ex<80.) errext += exp(ex);

errfit = 0.;
ex = pfite[5]-pfite[6]*mfr;
if(pfite[6]>0. && ex<80.) errfit += exp(pfite[5]-pfite[6]*mfr)+pfite[7];
if(errfit<=0.)  return (eflux);
ex = pfite[8]-pfite[9]*mfr;
if(pfite[9]>0. && ex<80.) errfit += exp(ex);

eflux = efluxb * fluxc/fluxb * errext/errfit;

return (eflux);
}


/* Nouvelle-Fonction */
float Erreur_Ext(float fluxc,float *pfite)
/*                                Christophe 2/6/95      */
/*  Valeur de l'erreur externe                           */
/* fluxc = flux calibre                                  */
/* pfite = tableau des fct erreurs externes              */
/* RETURN: erreur externe pour le flux calibre considere */
{
float errext,mfr;
double ex;

errext = 0.;
if( fluxc<=0. ) return (errext);
mfr = 2.5*flog10(fluxc);

ex = pfite[0]-pfite[1]*mfr;
if(pfite[1]>0. && ex<80.) errext += exp(ex)+pfite[2];
if(errext<=0.)  return (errext);
ex = pfite[3]-pfite[4]*mfr;
if(pfite[4]>0. && ex<80.) errext += exp(ex);
return (errext);
}


/* Nouvelle-Fonction */
void Calibre_F_E(MESUREU *mesu,TIMEINFOU *timu)
/*                                Christophe 1/2/95          */
/* remplissage de flux et errflux dans MESUREU   */
{
int typcal;
float efluxb,fluxb,fluxc,*pcal,*pfite;

fluxb = mesu->FluxB;
typcal = timu->FgCalib;
pcal = &(timu->Calib[0]);
mesu->Flux = fluxc = FluxCalibre(fluxb,typcal,pcal);

efluxb = mesu->ErrFluxB;
pfite = &(timu->PFitErr[0][0]);
mesu->ErrFlux = ErrCalibre(efluxb,fluxb,fluxc,pfite);
}

/* Nouvelle-Fonction */
MESUREU * DecodeMes( MESURE *mesc, MESUREU *mesu)

/* Cette fonction decode les mesures de fichier de suivi type 10 */
/* Retourne le pointeur sur la structure MESUREU fourni (mesu)   */

{
float fv;

if ((mesc == NULL) || (mesu == NULL) )  return(NULL);

mesu->FluxB = mesc->Flux;
mesu->Flux = mesu->FluxB;
mesu->Xi2 =  mesc->Xi2;
mesu->Fond =  (float)mesc->Fond;
fv = (mesu->FluxB >= 0.) ? mesu->FluxB : (-mesu->FluxB);
mesu->ErrFluxB =  mesc->ErrFlux*fv/10000.;
mesu->ErrFlux =  mesu->ErrFluxB;

mesu->Flx0 = (float)mesc->Flx0*10.0;
mesu->Fnd0 = (float)mesc->Fnd0;
mesu->Xi20 = (mesc->Xi20 < 0) ? (float)mesc->Xi20 : 
                         (float)mesc->Xi20/100.0 ;
mesu->S9Pix = (float)mesc->S9Pix*9.0;
mesu->PixMax = (float)mesc->PixMax;
mesu->X = (float)mesc->X/20.; 
mesu->Y = (float)mesc->Y/20.; 
mesu->SigX = (float)mesc->SigX/200.0;
mesu->SigY = (float)mesc->SigY/200.0;

return(mesu);
}

/* Nouvelle-Fonction */
void Mes_a_zero(MESUREU *mesu)

/* Cette fonction met a zero la structure mesu   */
{

if ( mesu == NULL )  return;
mesu->FluxB = mesu->Flux = mesu->Xi2 =  mesu->Fond = 0.;
mesu->ErrFluxB =  mesu->ErrFlux = 0.;
mesu->Flx0 = mesu->Fnd0 = mesu->Xi20 = 0.;
mesu->S9Pix = mesu->PixMax = 0.;
mesu->X = mesu->Y = mesu->SigX = mesu->SigY = 0.;

return;
}

/* Nouvelle-Fonction */
TIMEINFOU * DecodeTim( TIMEINFO *tim, TIMEINFOU *timu)

/* Cette fonction decode les timeinfo de fichier de suivi type 10 */
/* Retourne le pointeur sur la structure timeinfou fourni (timu)   */

{
int i,j;

if ((tim == NULL) || (timu == NULL) )  return(NULL);

timu->NumPhoto = tim->NumPhoto;
timu->TStart = tim->TStart;
timu->Expose = tim->Expose;
timu->Fond = tim->Fond;
timu->SigFond = tim->SigFond;
timu->SigX = tim->SigX;
timu->SigY = tim->SigY;
timu->Rho = tim->Rho;
timu->DelX = tim->DelX;
timu->DelY = tim->DelY;
timu->Absorption = tim->Absorption;
timu->AirMass = tim->AirMass;
timu->FgCalib = tim->FgCalib;
for(i=0;i<8;i++) timu->Calib[i] = tim->Calib[i];
for(i=0;i<2;i++)
  for(j=0;j<5;j++) timu->PFitErr[i][j] = tim->PFitErr[i][j];
timu->PSF1D = tim->PSF1D;
timu->PSF2D = tim->PSF2D;

return(timu);
}



/* Nouvelle-Fonction */
void GlobInfoToTransf(GLOBINFO *gli, TRANSFO *t1, TRANSFO *t2)
{
int i,j;

for(i=0; i<50; i++)  
  t1->Polxy[0][0][i] = t2->Polxy[0][0][i]= 0.; 
 
for(i=0; i<2; i++)
  {
  t1->Polxy[0][0][i] = gli->PolxyBR[0][i];
  t1->Polxy[0][1][i] = gli->PolxyBR[1][i];
  t1->Polxy[1][0][i] = gli->PolxyBR[2][i];

  t2->Polxy[0][0][i] = gli->PolxyRB[0][i];
  t2->Polxy[0][1][i] = gli->PolxyRB[1][i];
  t2->Polxy[1][0][i] = gli->PolxyRB[2][i];

  t1->largx[i] = gli->LargX[i];  
  t1->largy[i] = gli->LargY[i];  
  t1->midx[i]  = gli->MidX[i];  
  t1->midy[i]  = gli->MidY[i];  
  t1->xmin[i]  = gli->XMin[i];  
  t1->xmax[i]  = gli->XMax[i];  
  t1->ymin[i]  = gli->YMin[i];  
  t1->ymax[i]  = gli->YMax[i];
  j = (i == 0) ? 1 : 0;
  t2->largx[j] = gli->LargX[i];  
  t2->largy[j] = gli->LargY[i];  
  t2->midx[j]  = gli->MidX[i];  
  t2->midy[j]  = gli->MidY[i];  
  t2->xmin[j]  = gli->XMin[i];  
  t2->xmax[j]  = gli->XMax[i];  
  t2->ymin[j]  = gli->YMin[i];  
  t2->ymax[j]  = gli->YMax[i];
  
  }
t1->DegPolxy = t2->DegPolxy = gli->DegPolTG;
return;
}


/* Nouvelle-Fonction */
void TimeInfoToTransf(TIMEINFO *tminf, TRANSFO *t1, TRANSFO *t2)
{
int i,j;

for(i=0; i<50; i++)  
  t1->Polxy[0][0][i] = t2->Polxy[0][0][i]= 0.; 
 
for(i=0; i<2; i++)
  {
  t1->Polxy[0][0][i] = tminf->PolxyRC[0][i];
  t1->Polxy[0][1][i] = tminf->PolxyRC[1][i];
  t1->Polxy[1][0][i] = tminf->PolxyRC[2][i];

  t2->Polxy[0][0][i] = tminf->PolxyCR[0][i];
  t2->Polxy[0][1][i] = tminf->PolxyCR[1][i];
  t2->Polxy[1][0][i] = tminf->PolxyCR[2][i];

  t1->largx[i] = tminf->LargX[i];  
  t1->largy[i] = tminf->LargY[i];  
  t1->midx[i]  = tminf->MidX[i];  
  t1->midy[i]  = tminf->MidY[i];  
  t1->xmin[i]  = tminf->XMin[i];  
  t1->xmax[i]  = tminf->XMax[i];  
  t1->ymin[i]  = tminf->YMin[i];  
  t1->ymax[i]  = tminf->YMax[i];
  j = (i == 0) ? 1 : 0;
  t2->largx[j] = tminf->LargX[i];  
  t2->largy[j] = tminf->LargY[i];  
  t2->midx[j]  = tminf->MidX[i];  
  t2->midy[j]  = tminf->MidY[i];  
  t2->xmin[j]  = tminf->XMin[i];  
  t2->xmax[j]  = tminf->XMax[i];  
  t2->ymin[j]  = tminf->YMin[i];  
  t2->ymax[j]  = tminf->YMax[i];
  
  }
t1->DegPolxy = t2->DegPolxy = tminf->DegPolTG;
return;
}


/* Nouvelle-Fonction */
void PrtGlobInfo (GLOBINFO *glinf, int lp)
/* Impression de la struture GlobInfo */
{
int i;
TRANSFO t1,t2;
char strg[32], s[5];

if (!glinf->NumChamp)
  printf("GLOBINFO: (Codage EROS-1) NumCCD=%d Couleur=%d\n"
            ,glinf->NumCCD,glinf->Couleur);
else
  {
  unsigned long numchamp = glinf->NumChamp;
  dec2zeza(numchamp, strg, 32);
  if( strlen(strg) < 5) for(i=(int) strlen(strg); i<5; i++) strg[i] = '?';

  strg[5] = ' ';
  strg[6] = '0' + glinf->Couleur%10;
  dec2zeza((unsigned long) glinf->Couleur/10, s, 5);
  if(strlen(s)>0) strg[9] = s[0]; else strg[9] = '?';

  strg[7] = '0' + glinf->NumCCD%10;
  dec2zeza((unsigned long) glinf->NumCCD/10, s, 5);
  if(strlen(s)>0) strg[8] = s[0]; else strg[8] = '?';

  strg[10] = '\0';

  printf("GLOBINFO: (Codage EROS-2) %s ",strg);
  HMStoStr(HtoHMS((double)glinf->AlphaHr),strg);  
  printf(" Alpha,Delta= %s ", strg);
  HMStoStr(DtoDMS((double)glinf->DeltaDg),strg);
  printf(" %s ", strg);
  printf(" gain= %g e/ADU\n",glinf->GainCCD);
  if (lp > 2) printf("         Codage  Champ=%d  Coul=%d  CCD=%d\n",
                    glinf->NumChamp,glinf->Couleur,glinf->NumCCD);
  }
if (lp > 0)
  {
  printf("  IRes:");
  for(i=0;i<4;i++) printf(" %d",glinf->IRes[i]);
  putchar('\n');
  printf("  FRes:");
  for(i=0;i<2;i++) printf(" %g",glinf->FRes[i]);
  putchar('\n');
  }
if (lp > 1) 
  {
  GlobInfoToTransf(glinf,&t1,&t2);
  printf("  Transfo Col1->Col2\n"); PrintTransfo(&t1);
  printf("  Transfo Col2->Col1\n"); PrintTransfo(&t2);
  }

return;
}

/* Nouvelle-Fonction */
void PrtStarInfo (STARINFO *sti,int n,int lp)
/* Impression de la struture StarInfo */
{
int i;

printf("STARINFO[%d]: NumEt=%d XRef=%d X/YPos=%g %g \n",n
      ,sti->NumEt,sti->XRef,sti->XPos,sti->YPos);

if(lp>0)
  {
  printf("  FlxMean/Sig=%g %g FluxRef=%g FgRef=%d\n"
        ,sti->FlxMean,sti->FlxSig,sti->FluxRef,sti->FgRef);
  printf("  NbVois=%d Voisin=",sti->NbVois);
  for(i=0;i<8;i++) printf(" %d",sti->Voisin[i]);
  printf("\n");
  printf("  DisMin,DisM2,DisM2R=%g %g %g\n"
        ,sti->DisMin,sti->DisM2,sti->DisM2R);
  }

}


/* Nouvelle-Fonction */
void PrtMesure (MESURE *mes,int n,int lp)
/* Impression de la struture Mesure */
{
printf("MES[%d]: Flx=%g (+/-%d) c2=%g Fnd=%d S9=%d pmx=%d\n",n
      ,mes->Flux,mes->ErrFlux,mes->Xi2,mes->Fond,mes->S9Pix,mes->PixMax);

if(lp>0)
  printf("  Flx0=%d Fnd0=%d Xi20=%d X/Y=%d %d SigX/Y=%d %d\n"
        ,mes->Flx0,mes->Fnd0,mes->Xi20,mes->X,mes->Y,mes->SigX,mes->SigY);

}

/* Nouvelle-Fonction */
void PrtMesureU (MESUREU *mesu,int n,int lp)
/* Impression de la struture MesureU */
{
printf("MESU[%d]: Flx=%g (err=%g) FlB=%g c2=%g Fd=%g S9=%g pmx=%g\n",n
      ,mesu->Flux,mesu->ErrFlux,mesu->FluxB
      ,mesu->Xi2,mesu->Fond,mesu->S9Pix,mesu->PixMax);

if(lp>0)
  printf("  Flx0=%g Fnd0=%g Xi20=%g X/Y=%g %g SigX/Y=%g %g\n"
        ,mesu->Flx0,mesu->Fnd0,mesu->Xi20,mesu->X,mesu->Y,mesu->SigX,mesu->SigY);

}

/* Nouvelle-Fonction */
void PrtTimeInfo (TIMEINFO *tim,int n,int lp)
/* Impression de la struture TimeInfo */
{
TRANSFO t1,t2;
float td;
int i;
int_4 date,t;  HMS T;  JMA J;
char strg[32];

DecodeNumPhoto(tim->NumPhoto, strg);

td = (float)tim->TStart/86400.;
printf("TimeInfo[%d]: Photo %s (%d) TStart=%d s (%g d) V=%5.2f (Rev=%d)\n",
       n, strg, tim->NumPhoto, tim->TStart, td,  
       (float)tim->Version/1000.,tim->Revision);

if (lp < 1) 
  printf(" .Exp=%d s SigX,Y/Rho= %6.3f %6.3f %6.3f Absor= %5.2f DelX/Y= %6.2f %6.2f\n",
         tim->Expose, tim->SigX,tim->SigY,tim->Rho,
         tim->Absorption,tim->DelX,tim->DelY);

if(lp>=1)
  {
  printf(" .Exp=%d SigX,Y/Rho= %6.3f %6.3f %6.3f Absor= %5.2f AirMass= %5.2f\n",
         tim->Expose,tim->SigX,tim->SigY,tim->Rho,
         tim->Absorption,tim->AirMass);
  if (lp == 1)
    printf("  ..Cal (%d) %g %g %g DelX/Y=%6.2f %6.2f \n"
          ,tim->FgCalib,tim->Calib[0],tim->Calib[1],tim->Calib[2]
          ,tim->DelX,tim->DelY);
  }

if(lp>1)
  {
  printf("  TypPSF 1D= %d  2D= %d  SgX= %6.3f  SgY= %6.3f\n",
         tim->PSF1D, tim->PSF2D, tim->SgX, tim->SgY); 
  printf("  Cal (%d)",tim->FgCalib);
  for(i=0;i<8;i++) printf(" %g",tim->Calib[i]);
  printf("\n");

  printf("  Fond=%g SFond=%g NbOkPS/GF=%d %d DelX/Y=%g %g\n"
        ,tim->Fond,tim->SigFond,tim->NbOkPS,tim->NbOkGF
        ,tim->DelX,tim->DelY);

  printf("  PFitErr[0]=");
  for(i=0;i<5;i++) printf("  %g",tim->PFitErr[0][i]);
  printf("\n");
  printf("  PFitErr[1]=");
  for(i=0;i<5;i++) printf("  %g",tim->PFitErr[1][i]);
  printf("\n");
  }

if(lp>2)
  {
  printf("  Resol[0]:");
  for(i=0;i<6;i++) printf("  %7.4f",tim->Resol[0][i]);
  printf("\n");
  printf("  Resol[1]:");
  for(i=0;i<6;i++) printf("  %7.4f",tim->Resol[1][i]);
  printf("\n");
  printf("  Resol[2]:");
  for(i=0;i<6;i++) printf("  %7.4f",tim->Resol[2][i]);
  printf("\n");

    InttoDateTs((uint_4) tim->DateHeure,&date,&t);
    StrgtoJMA("1/1/1990",J); date += JMAtoJ(J);
    J = JtoJMA(date);
    T = SectoHMS((double) t);
    JMAtoStrg(J,&strg[15]);
    HMStoStr(T,&strg[0]);
  printf("  DateHeure: %d (%s %s)",tim->DateHeure,&strg[15],&strg[0]);
    InttoDateTs((uint_4) tim->TSid,&date,&t);
    T = SectoHMS((double) t);
    HMStoStr(T,&strg[0]);
  printf(" TSid= %d (%s)\n",tim->TSid,&strg[0]);
    InttoDateTs((uint_4) tim->DTU,&date,&t);
    StrgtoJMA("1/1/1990",J); date += JMAtoJ(J);
    J = JtoJMA(date);
    T = SectoHMS((double) t);
    JMAtoStrg(J,&strg[15]);
    HMStoStr(T,&strg[0]);
  printf("  DTU:  %d (%s %s)",tim->DTU,&strg[15],&strg[0]);
  printf("  FRes:  %g \n", tim->FRes);

  printf(" ObsId=%d PxSiz=%g %g CrVal=%g %g\n",tim->ObsId
        ,tim->PxSiz[0],tim->PxSiz[1],tim->CrVal[0],tim->CrVal[1]);

  TimeInfoToTransf(tim,&t1,&t2);
  printf("  Transfo Ref->Cur\n"); PrintTransfo(&t1);
  printf("  Transfo Cur->Ref\n"); PrintTransfo(&t2);
  }

}

/* Nouvelle-Fonction */
void PrtTimeInfoU (TIMEINFOU *tim,int n,int lp)
/* Impression de la struture TimeInfoU */
{
int i;
float td;
char strg[32];

DecodeNumPhoto(tim->NumPhoto, strg);

td = (float)tim->TStart/86400.;

printf("TIMU[%d]: Photo# %d (%s)  TStart=%d (%g d) Exp=%d psf=%d,%d\n",
       n,tim->NumPhoto,strg,tim->TStart,td,tim->Expose,tim->PSF1D,tim->PSF2D);

if (lp < 1) 
  printf(".SigX,Y/Rho= %6.3f %6.3f %6.3f Absor= %5.2f DelX/Y= %6.2f %6.2f \n",
         tim->SigX,tim->SigY,tim->Rho,tim->Absorption,tim->DelX,tim->DelY);

if(lp>=1)
  {
  printf(".SigX,Y/Rho= %6.3f %6.3f %6.3f Absor= %5.2f AirMass= %6.2f\n"
        ,tim->SigX,tim->SigY,tim->Rho,tim->Absorption,tim->AirMass);
  printf(".Fond/SFond= %g %g  DelX/Y=%6.2f %6.2f\n"
        ,tim->Fond,tim->SigFond,tim->DelX,tim->DelY);
  printf("  Cal (%d)",tim->FgCalib);
  for(i=0;i<8;i++) printf(" %g",tim->Calib[i]);
  printf("\n");
  }

if(lp>1)
  {
  printf("  PFitErr[0]=");
  for(i=0;i<5;i++) printf("  %g",tim->PFitErr[0][i]);
  printf("\n");
  printf("  PFitErr[1]=");
  for(i=0;i<5;i++) printf("  %g",tim->PFitErr[1][i]);
  printf("\n");
  }

}

