/*   Structure du fichier de suivi type 10             */
/*               CMV + RA  Juillet 94  La Silla        */

#ifndef  FSVST_H_SEEN  
#define  FSVST_H_SEEN  

#include "machdefs.h"

#include "transfost.h"

#ifdef __cplusplus
extern "C" {
#endif


struct GlobInfo 
  {
  int_4 NumCCD;
  int_4 Couleur;
  int_4 NumChamp;
  int_4 IRes[4];
  float AlphaHr;
  float DeltaDg;
  float GainCCD;
  float FRes[2];

  double PolxyBR[3][2];
  double PolxyRB[3][2];
  double LargX[2],LargY[2],MidX[2],MidY[2];
  double XMin[2],XMax[2],YMin[2],YMax[2];
  int_4  DegPolTG;

  };

typedef  struct  GlobInfo   GLOBINFO;


struct StarInfo
  {
  int_4  NumEt, XRef;
  float  FlxMean,FlxSig;
  float  FluxRef;
  float  XPos,YPos;
  float  DisMin,DisM2,DisM2R;
  uint_2 FgRef;
  uint_2 NbVois,Voisin[8];
  };

typedef  struct  StarInfo  STARINFO;


struct TimeInfo
  {
  int_4  NumPhoto;
  int_4  TStart,Expose;
    
  int_4  NbOkPS,NbOkGF;
  float  Fond,SigFond;

  float  SigX,SigY,Rho;
  float  SgX,SgY;

  float  PxSiz[2], CrVal[2];
  float  DelX,DelY;

  double PolxyRC[3][2];
  double PolxyCR[3][2];
  double LargX[2],LargY[2],MidX[2],MidY[2];
  double XMin[2],XMax[2],YMin[2],YMax[2];
  int_4  DegPolTG;

  float  Absorption;
  float  AirMass;
  
  int_4  FgCalib;
  float  Calib[8];
  float  Resol[3][6];
  float  PFitErr[2][5];

  uint_2 PSF1D, PSF2D;
  uint_2 Version, Revision;
  int_4  DateHeure;
  uint_2 TSid, ObsId;
  int_4  DTU;
  float FRes;
  };

typedef  struct  TimeInfo  TIMEINFO;

struct TimeInfoU
  {
  int_4  NumPhoto;
  int_4  TStart,Expose;
  float  Fond,SigFond;
  float  SigX,SigY,Rho;
  float  DelX,DelY;
  float  Absorption,AirMass;
  int_4  FgCalib;
  float  Calib[8];
  float  PFitErr[2][5];
  uint_2 PSF1D, PSF2D;
  };

typedef  struct  TimeInfoU  TIMEINFOU;

struct Mesure
  {
  float  Flux,Xi2;
  int_2 ErrFlux,Fond;
  int_2 Flx0,Fnd0,Xi20;
  int_2 S9Pix,PixMax;
  uint_2 X,Y;
  uint_2 SigX,SigY; 
  };

typedef struct Mesure  MESURE;

struct MesureU
  {
  float  Flux,FluxB;
  float  Xi2,ErrFlux,ErrFluxB;
  float  Fond;
  float  Flx0,Fnd0,Xi20;
  float  S9Pix,PixMax;
  float  X,Y;
  float  SigX,SigY; 
  } ;

typedef struct MesureU  MESUREU;


float FluxCalibre(float fluxb, int typcal, float *pcal);
float ErrCalibre(float efluxb,float fluxb,float fluxc,float *pfite);
float Erreur_Ext(float fluxc,float *pfite);
void Calibre_F_E(MESUREU *mesu,TIMEINFOU *timu);
MESUREU * DecodeMes( MESURE *mesc, MESUREU *mesu);
void Mes_a_zero(MESUREU *mesu);
TIMEINFOU * DecodeTim( TIMEINFO *time, TIMEINFOU *timeu);

void GlobInfoToTransf(GLOBINFO *gli, TRANSFO *t1, TRANSFO *t2);
void TimeInfoToTransf(TIMEINFO *tminf, TRANSFO *t1, TRANSFO *t2);

void PrtGlobInfo (GLOBINFO *glinf, int lp);
void PrtStarInfo (STARINFO *sti, int n, int lp);
void PrtMesure (MESURE *mes, int n, int lp);
void PrtMesureU (MESUREU *mesu, int n, int lp);
void PrtTimeInfo (TIMEINFO *tim, int n, int lp);
void PrtTimeInfoU (TIMEINFOU *tim, int n, int lp);

#ifdef __cplusplus
}
#endif

#endif



