/*
Ecriture des corubes de lumieres individuelles pour database ErosI
*/
#include "sopnamsp.h"
#include "machdefs.h"
#include <iostream>
#include <string>
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <string.h>

#include "fsvcache.h"
#include "fsvst.h"
#include "fmath.h"
#include "nbmath.h"
#include "nbrandom.h"
#include "nbsread.h"
#include "nbgene.h"

/*================================================================*/
void UINIT(void)
{
 printf("UINIT\n");
}

/*=================== ============================================*/
void UDATCLEAN(int coul)
/*
  Attention ici coul = 1,2
    donc pour tuer une image pour la couleur coul:
    date[coul-1][...] = GRAND2;
*/
{
 int ic = coul - 1;
 cout<<"UDATCLEAN: couleur "<<coul<<", indice tableau "<<ic<<endl;
 if(nmes[ic]<=0) return;

 for(int i=0;i<nmes[ic];i++) {
   if(date[ic][i]<0.)  date[ic][i] = GRAND2;
   if(timeu[ic][i].FgCalib<=0) date[ic][i] = GRAND2;
 }

}

/*================================================================*/
void UINITCCD(void)
{
 printf("UINITCCD: Debut de l'etude du CCD %d %d\n",numccd,ccdnum);
}

/*================================================================*/
void UEVT(void)
{
 printf("> Et=%d (%d) %d (%d)  fref=%g %g  nmes=%d %d  nmesure=%d %d\n"
       ,iet[0],staru[0].XRef,iet[1],staru[1].XRef,staru[0].FluxRef,staru[1].FluxRef
       ,nmes[0],nmes[1],nmesure[0],nmesure[1]);

 if(nmesure[0]<=0) return;
 if(iet[0]<=0) return;

 // Generate file name
 char fname[512];  sprintf(fname,"e%d.data",iet[0]);

 // Open file
 FILE *file = fopen(fname,"w");
 if(file == NULL) {
   cout<<"ERROR: file "<<fname<<" NOT OPENED"<<endl;
   return;
 }

 // Fill header
 for(int ic=0;ic<NCOULMX;ic++) {
   string sname = "?";
   if(nbfil[ic]>0) {
     sname = lunnam[ic][0];
     int ip = sname.find_last_of('/');
     if(ip<0 || ip>=(int)sname.size()) ip = -1;
     sname = sname.substr(++ip);
   }
   fprintf(file,"# %d %d %s\n",ic,nbfil[ic],sname.c_str());
 }
 
 fprintf(file,"# color(0/1) nmesure NumEt XRef FluxRef XPos YPos DisMin DisM2 NbVois\n");
 for(int ic=0;ic<NCOULMX;ic++) {
   fprintf(file,"@ %d %d %d %d %.3f %.3f %.3f %.3f %.3f %d\n",
          ic,nmesure[ic],
          staru[ic].NumEt,staru[ic].XRef,staru[ic].FluxRef,
          staru[ic].XPos,staru[ic].YPos,
          staru[ic].DisMin,staru[ic].DisM2,staru[ic].NbVois);
 }


 // Fill mesures
 fprintf(file,"# color(0/1) TStart(s) Flux ErrFlux FluxB ErrFluxB Fond PixMax S9Pix global_(Fond SigX SigY Rho)\n");
 for(int ic=0;ic<NCOULMX;ic++) {
     if(iet[ic]<=0) continue;   // pas d'etoile associee
     if(nmesure[ic]<=0) continue;
     for(int j=0;j<nmesure[ic];j++) {
       int i = indexu[ic][j];
       fprintf(file,"%d %d %.3f %.3f %.3f %.3f %.3f %.0f %.0f %.3f %.3f %.3f %.5f\n",
               ic,
	       timeu[ic][i].TStart,
               mesu[ic][i].Flux,mesu[ic][i].ErrFlux,
               mesu[ic][i].FluxB,mesu[ic][i].ErrFluxB,
               mesu[ic][i].Fond,mesu[ic][i].PixMax,mesu[ic][i].S9Pix,
               timeu[ic][i].Fond,
               timeu[ic][i].SigX,timeu[ic][i].SigY,timeu[ic][i].Rho);
     }
 }

 // Close file
 fclose(file);
}

/*================================================================*/
void UENDCCD(void)
{
 printf("UENDCCD: Fin de l'etude du CCD %d %d\n",numccd,ccdnum);
}

/*================================================================*/
void UEND(void)
{
 printf("UEND: Fin du job\n");
}
