#ifndef FSVCACHE_H_SEEN
#define  FSVCACHE_H_SEEN

#include <stdio.h>
#include "machdefs.h"

#include "filecache.h"

#ifdef __cplusplus
extern "C" {
#endif

 
/*    Structure du fichier de suivi :                             */
/*           1) Entete : Structure entetesuivi                    */
/*           2) Zone commentaire   (1 * Rec0 )                    */
/*           3) Enregistrement Info generale fichier  (1 * Rec1)  */
/*           4) Enregistrements info etoiles  (NbStars * Rec2)    */
/*           5) Enregistrements mesures                           */
/*                1 * Rec3 + NbStars * Rec4                       */
/*                Rec3 contient le temps des mesures,             */
/*                Rec4 contient l'info mesures                    */
/*                Rec3 et Rec4 correspondent a un ensemble de     */
/*                NItem mesures.                                  */
/*           le groupe (5) peut etre repete plusieurs fois        */
 
 
 
struct entetesuivi
  {
  int_4 FileSize;             /*  Taille totale fichier  */
  int_4 HSize;                /*  Taille entete          */
  uint_2 RecSize[5];          /*  Tailles Rec 0/1/2/3    */
  uint_2 NItem;               /*  Nb de mesures / Record */
  int_4 NbStars;              /*  Nb. total d'etoiles    */
  int_4 NbMesTot;             /*  Nb. total de mesures   */
  uint_2 FmtSize[5];          /*  Longueur des formats   */
  uint_2 Swap;                /*  Sens de byte-swap      */
  uint_2 Type;                /*  Type de suivi          */
  int_4  FgCorrupt;           /*  test fichier corrompu  */
  };
 
typedef  struct entetesuivi  ENTETESUIVI;
 
struct suivifip
  {
  FILE *fip;
  FILECACHE *fcp;
  ENTETESUIVI Head;
  char *Nom;
  int_4 OffsetMes;
  int FgRW;
  int FgSwap;
  char* RecFmt[5];
  };
 
typedef  struct suivifip  SUIVIFIP;
 
 
/*    Pour l'IBMVM, Je redefinis les noms  (Pb = Max 8 car)   */
#ifdef IBMVM
 
#define   SuiviCreate           SuvCreat
#define   SuiviOpen             SuvOpen
#define   SuiviClose            SuvClos
#define   SuiviGetNbStars       SuvGNbSt
#define   SuiviGetNbMesures     SuvGNMes
#define   SuiviGetNbytstars     SuvGNByt
#define   SuiviGetType          SuvGTyp
#define   SuiviWriteComment     SuvWrCom
#define   SuiviReadComment      SuvRdCom
#define	  SuiviWriteGlobInfo    SuvWrGlI
#define	  SuiviReadGlobInfo     SuvRdGlI
#define   SuiviWriteStarInfo    SuvWrStI
#define   SuiviReadStarInfo     SuvRdStI
#define   SuiviAddMesure        SuvAdMes
#define   SuiviWriteTimeInfo    SuvWrTmI
#define   SuiviWriteMesure      SuvWrMes
#define   SuiviReadTimeInfo     SuvRdTmI
#define   SuiviReadMesures      SuvRdMes
 
#endif
 
 
/*     Flag d'ouverture fichier  Lecture / Lecture-Ecriture    */
 
#define    SUOF_RO     0
#define    SUOF_RW     1
#define    SUOF_RO_MEM     10
#define    SUOF_RW_MEM     11
#define    SUOF_RO_MEM2    20
#define    SUOF_RW_MEM2    21
#define    SUOF_RO_MEM3    30
#define    SUOF_RW_MEM3    31
#define    SUOF_RO_MEM4    40
#define    SUOF_RW_MEM4    41
 
 
int SuiviCreate(char *filename, int typ, int rec0size, char *rec1fmt,
                char *rec2fmt, char *rec3fmt, char *rec4fmt, int nitem);
 
SUIVIFIP *SuiviOpen(char *filename, int rw);
 
int SuiviClose(SUIVIFIP *suivfip);
 
int_4 SuiviGetNbStars(SUIVIFIP *suivfip);
 
int_4 SuiviGetNbMesures(SUIVIFIP *suivfip);
 
int_4 SuiviGetNbytStars(SUIVIFIP *suivfip);
 
int_4 SuiviGetType(SUIVIFIP *suivfip);

int_4 SuiviGetSize(SUIVIFIP *suivfip);

int_4 SuiviPredictSize(SUIVIFIP *sfip, int nbst, int nbmes);

void  SuiviSetPrtLevel(int lev);
 
int SuiviWriteComment(SUIVIFIP *suivfip, char *buff);
 
int SuiviReadComment(SUIVIFIP *suivfip, char *buff);
 
int SuiviWriteGlobInfo(SUIVIFIP *suivfip, char *buff);
 
int SuiviReadGlobInfo(SUIVIFIP *suivfip, char *buff);
 
int SuiviWriteStarInfo(SUIVIFIP *suivfip, int_4 num, char *buff);
 
int SuiviReadStarInfo(SUIVIFIP *suivfip, int_4 num, char *buff);
 
int SuiviAddMesure(SUIVIFIP *suivfip, char *buff);
 
int SuiviWriteTimeInfo(SUIVIFIP *suivfip, int_4 numes, char *buff);
 
int SuiviWriteMesure(SUIVIFIP *suivfip, int_4 numet,
                     int_4 nummes, char *buff);
 
int SuiviReadTimeInfo(SUIVIFIP *suivfip, int_4 debut,
                      int_4 fin, char *buff);
 
int SuiviReadMesures(SUIVIFIP *suivfip, int_4 numet,
                     int_4 debut, int_4 fin, char *buff);
#ifdef __cplusplus
}
#endif
 
#endif

