#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "strutil.h"
#include "nomfits.h"

/*  RZ + CMV  07/94, modifs EROS II CMV 27/11/96  */

/* 
++ 
  Module	Codage des noms de fichiers Eros 1 et 2 (C)
  Lib	LibsUtil
  include	nomfits.h

	Pour coder et decoder les noms de fichiers Fits Eros 1 et 2.
--
*/

/* Nouvelle-Fonction */
/*
++
int CodeFitsName(char const* nom)
	Decodage d'un `nom' de fichier pour fournir un entier code (Rc).
| Rc :   C A MM JJ NNN  pour EROS I
|      1 C A MM JJ NNN  pour EROS II
|     (Une lettre = un chiffre decimal)
| C Couleur : 1 = Rouge, 2= Bleu, 0 Sinon (cas EROS I)
|   Camera  : 1 = Rouge, 2= Bleu, 0 Sinon (cas EROS II)
| A  Annee  (Ex 1994 -> 4)
| MM Mois   (01 a 12)   JJ  Jour (01 a 31)
| NNN Numero de sequence en decimal (jusqu'a 999)
| Remarque: Marche pour un nom EROS I ou EROS II
--
*/
int CodeFitsName(char const* nom)
{
int c,a,jj,mm,nn,l,rc;
int ieros,ic,ia,im,ij,in;
char name[30],s[6];

strncpy(name,nom,28);  name[29] = '\0';
strip(name,'B',' '); 
if ( (l=posc(name,'.')) >= 0)  name[l] = '\0';
l = strlen(name);
if (l < 8) {  /* type de nom inconnu */
  return(0);
} else if (l < 15 ) { /* c'est un nom EROS I */
  ieros = 1;
  ic = 1; ia = 2; im = 3; ij = 4; in = 6;
} else {              /* c'est un nom EROS II */
  ieros = 2;
  ic = 5; ia = 10; im = 11; ij = 12; in = 14;
}

/* codage de la couleur/camera */
if( ieros == 1 ) {
  if(name[ic] == 'r')        c = 1;
    else if(name[ic] == 'b') c = 2;
      else                   c = 0;
} else {
   c = (int)name[ic] - (int)'0'; c += 10;
}
rc = c*100000000;

/* codage de l'annee */
s[0] = name[ia];  s[1] = '\0';
a = atoi(s);
rc += a*10000000;

/* codage du mois */
mm = (int)name[im]-(int)'a'+1;
rc += mm*100000;

/* codage du jour */
s[0] = name[ij];  s[1] = name[ij+1];  s[2] = '\0';
jj = atoi(s);
rc += jj*1000;

if( ieros == 1 ) {
  nn = strtol(name+in,NULL,16);
} else {
  strncpy(s,&name[in],3); /* pas plus de 999 */
  nn = atoi(s);
}
rc += nn;

return(rc);
}

/* Nouvelle-Fonction */
/*
++
char * DecodeNumPhoto(int num, char* nom)
	Fonction inverse de CodeFitsName(). Retourne
	le `nom' de fichier Fits Eros correspondant a l'entier `num'.
--
*/
char * DecodeNumPhoto(int num, char* nom)
{
int f,a,m,j,n;
char cm,cf[3];
cf[0] = '-'; cf[1] = 'r'; cf[2] = 'b';

n = num%1000;
num = (num-n)/1000;  j = num%100;
num = (num-j)/100;  m = num%100;
if ((m<1) || (m > 12) )  cm = '-';
else  cm = 'a'+(m-1);
num = (num-m)/100;  a = num%10;
num = (num-a)/10;   f = num;
if( f >= 10 ) {  /* c'est un nom EROS II */
  f -= 10;
  sprintf(nom,"@%1d%1d%c%02d%d",f,a,cm,j,n);
} else {        /* c'est un nom EROS I  */
  if ((f>2) || (f<0))  f = 0;
  sprintf(nom,"@%c%1d%c%02d%02x",cf[f],a,cm,j,n);
}

return(nom);
}

/* Nouvelle-Fonction */
int CodeFilterName(char const* filtre)
/*  Renvoie 1 pour filtre rouge , 2 Bleu, 0 sinon */
{
char name[25];

strncpy(name,filtre,20);  name[20] = '\0';
strip(name,'B',' '); 
if (tolower(name[0]) == 'r')  return(1);
if (tolower(name[0]) == 'b')  return(2);
return(0);
}

/* Nouvelle-Fonction */
/*
++
int CodeFilterName2(char const* nom,int* champ,int* coul,int* ccd)
	Decortique un nom de fichier EROS II et le code dans 3 entiers.
| champ = conversion decimale du champ ex: cg601 -> 20909665
| coul  = codage numero de camera (D) + numero de filtre (Z)
|       = nfilt*10 + ncam,  ex: camera 1 filtre z -> 35*10+1 = 351
|       recup rapide du num de camera: coul%10
| ccd   = codage du mumero de sous image (Z) et de CCD (D)
|       = nssima*10 + nccd, ex: ssima=t ccd 7 -> 29*10+7 = 297
|       recup rapide du num de ccd: ccd%10
| Rc = 0 si OK, -1 sinon
--
*/
int CodeFilterName2(char const* nom,int* champ,int* coul,int* ccd)
{
int i1,i2,l;
char name[30],s[6];
*champ = *coul = *ccd = 0;

strncpy(name,nom,28);  name[29] = '\0';
strip(name,'B',' '); 
if ( (l=posc(name,'.')) >= 0)  name[l] = '\0';
l = strlen(name);
if (l < 15 ) return(-1); /* c'est pas un nom EROS II */

strncpy(s,name,5); s[5]='\0';
*champ = strtol(s,NULL,36);

strncpy(s,&name[8],1); s[1]='\0';
i1 = strtol(s,NULL,36);
i2 = (int)name[5] - (int)'0';
*coul = i1*10 + i2;

strncpy(s,&name[7],1); s[1]='\0';
i1 = strtol(s,NULL,36);
i2 = (int)name[6] - (int)'0';
*ccd = i1*10 + i2;

return(0);
}
