// This may look like C code, but it is really -*- C++ -*-
// Classe de gestion d objets nommes pour piapp
// Reza      Aout 97 , Juillet,Aout 98
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef NOBJMGR_H_SEEN
#define NOBJMGR_H_SEEN

#include "machdefs.h"
#include "anydataobj.h"
#include "dlftypes.h"

#include <string>
#include <vector>
#if defined(__KCC__)
using std::string ;
#include <vector.h>
#endif

class NObjMgrAdapter;
class PIStdImgApp;
class Services2NObjMgr;

class NamedObjMgr {
public:
// Constructeur et destructeur
			NamedObjMgr();
  virtual		~NamedObjMgr();

  virtual void 		SetImgApp(PIStdImgApp* app);


// Gestion des repertoires
  virtual void		CreateDir(string const& dirname);
  virtual void		DeleteDir(string const& dirname);
  virtual void		SetCurrentDir(string const& dirname);
  virtual void		CleanTmpDir();
  virtual void		CleanOldDir();

//  Pour ajouter, supprimer et acceder aux objets 
  virtual void		AddObj(AnyDataObj* obj, string & nom, bool crd=false);
  virtual void		RenameObj(string & nom, string& nomnew);
  virtual void          DelObj(string & nom, bool fgd=true);
  virtual void		DelObjects(string & patt, bool fgd=true); 
  virtual void          DelObj_Id(int oid);
  virtual AnyDataObj*	GetObj(string & nom);
  virtual void          ListObjs(string & patt);  		
  virtual void          GetObjList(string & patt, vector<string>& );  		

//  Lecture et sauvegarde des objets sur fichier
  virtual void		ReadObj(PInPersist& s, int num=-1);
  virtual void		ReadObj(string const & nomppf, string & nobj);
  virtual void		ReadAll(string const & nomppf);
  virtual void		ReadFits(string const & flnm, string & nobj);
  virtual void          SaveObj(string & nom, POutPersist& s);
  virtual void          SaveAll(string const& nomppf);
  virtual void          SaveFits(string & nom, string const & flnm);

// Info sur les objets 
  virtual void          PrintObj(string & nom);

//  Affichage des objets 
  virtual void          DisplayObj(string & nom, string dopt="");
  virtual void          DisplayImage(string & nom, string dopt="");
  virtual void          DisplaySurf3D(string & nom, string dopt="");
  virtual void          DisplayNT(string & nom, string& nmx, string& nmy, string& nmz,  
                                  string& erx, string& ery, string& erz, string dopt="");
  virtual void          DisplayGFD(string & nom, string& numvarx, string& numvary, string& err, string dopt="");

  virtual void		SetGraphicAttributes(string gratt="");
  virtual void		SetGraphicWinZone(int nzx, int nzy, bool fcr=false);


//  Trace d'expression de NTuple, et d'autres objets
  virtual void          DisplayPoints2D(string & nom, string& expx, string& expy,
                                        string& experrx, string& experry, 
                                        string& expcut, string dopt="");
  virtual void          DisplayPoints3D(string & nom, string& expx, string& expy, string& expz, 
                                        string& expcut, string dopt="");
//  Projection d'expressions dans histogramme (et trace) 
  virtual void          ProjectH1(string & nom, string& expx, string& expwt, string& expcut, 
                                  string& nomh1, string dopt="");
  virtual void          ProjectH2(string & nom, string& expx, string& expy, string& expwt, 
                                  string& expcut, string& nomh2, string dopt="");
  virtual void          ProjectHProf(string & nom, string& expx, string& expy, string& expwt, 
                                  string& expcut, string& nomprof, string dopt="");
//  Projection d'expression dans vecteurs et dans n-tuple
  virtual void          FillVect(string & nom, string& expx, string& expcut, 
                                 string& nomvec, string dopt="");
  virtual void          FillNT(string & nom, string& expx, string& expy, string& expz,
                               string& expt, string& expcut, string& nomnt); 
  virtual void          FillGFD(string & nom, string& expx, string& expy, string& expz,
                               string& experr, string& expcut, string& nomgfd);

//   Methodes de fit, a rajouter  (pour CMV , deux methodes H1 H2 ou 1 seule ??) ...
  virtual void          Fit12D(string & nom, string& func,
                              string par,string step,string min,string max,string opt);

// Acces au PIApplication et a la classe de service 
  virtual PIStdImgApp*		GetImgApp();
  virtual Services2NObjMgr* 	GetServiceObj();

protected :
  virtual NObjMgrAdapter*	GetObjAdapter(string & nom);
};


#endif
