#ifndef COSMOCALC_SEEN
#define COSMOCALC_SEEN

#include "machdefs.h"
#include <vector>

#include "genericfunc.h"

namespace SOPHYA {

  class CSpline;

//-----------------------------------------------------------------------------------
class CosmoCalc : public GenericFunc {
public:
  CosmoCalc(unsigned short flat=0,bool usespline=false,double zmax=0.);
  CosmoCalc(CosmoCalc& univ);
  virtual ~CosmoCalc(void);

  unsigned short Flat(void) { return _flat;}

  double ZMax(void) { return _zmax;}
  void SetInteg(double dperc=-1.,double dzinc=-1.,double dzmax=-1.,unsigned short order=4);
  void PrtInteg(void);

  void SetDynParam(double h100,double om0,double or0,double ol0,double w0=-1.);
  void SetObaryon0(double v);
  void DefaultParam(void);

  inline double h100(void) {return _h100;}
  inline double H0(void) {return _H0;}
  inline double Dhubble(void) {return _Dhubble;}
  inline double Olambda0(void) {return _Olambda0;}
  inline double W0(void) {return _W0;}
  inline double Omatter0(void) {return _Omatter0;}
  inline double Obaryon0(void) {return _Obaryon0;}
  inline double Orelat0(void) {return _Orelat0;}
  inline double Ocurv0(void) {return _Ocurv0;}
  inline double Otot0(void) {return _Otot0;}
  double Rhoc(double z);

  inline double H(double z) {return _H0 * E(z);}
  double Olambda(double z);
  double Omatter(double z);
  double Obaryon(double z);
  double Orelat(double z);
  double Ocurv(double z);
  double Otot(double z);

  double Dtrcom(double z);
  double Dloscom(double z);
  double Dang(double z);
  double Dlum(double z);

  double dVol(double z);
  double Vol4Pi(double z);
  double Vol4Pi(double z1,double z2);

  void Print(double z=0.);

  double E2(double z) const;
  inline double E(double z) const {return sqrt(E2(z));}

  double NInteg(double z);
  inline double Integrand(double z) const {return 1./E(z);}

  virtual double operator() (double z) {return Integrand(z);}
protected:
  int_4 Init_Spline(void);
  void Clone(CosmoCalc& univ);

  // La cosmology
  unsigned short _flat;
  double _h100, _H0;  /* km/s/Mpc */
  double _Olambda0,_W0;
  double _Omatter0,_Obaryon0;
  double _Orelat0;
  double _Otot0,_Ocurv0;
  double _Dhubble;  /* Mpc */

  // Parametres d'integration
  double _dperc,_dzinc,_dzmax;
  unsigned short _glorder;
  vector<double> _xgausl, _wgausl;

  // Pour le calcul direct
  double _zold,_integval;

  // Pour les splines
  bool _usespline,_computespl;
  double _zmax;
  CSpline * _spline;
  int_4 _nspl;
  double *_xspl, *_yspl;

};

} // Fin du namespace

#endif
