#ifndef SCHECHTER_SEEN
#define SCHECHTER_SEEN

#include "machdefs.h"
#include "genericfunc.h"

namespace SOPHYA {

class Histo;
class FunRan;

//-----------------------------------------------------------------------------------
class Schechter : public GenericFunc {
public:
  Schechter(double nstar,double mstar,double alpha);
  Schechter(Schechter& f);
  Schechter(void);
  virtual ~Schechter(void);

  void SetOutValue(unsigned short outvalue=0);
  unsigned short GetOutValue(void);
  void SetParam(double nstar,double mstar,double alpha);
  void GetParam(double& nstar,double& mstar,double& alpha);

  virtual double operator() (double m);

  double Integrate(double massmin,double massmax,int npt=100);

  virtual void Print(void);

protected:
  double nstar_,mstar_,alpha_;
  unsigned short outvalue_;
};

//-----------------------------------------------------------------------------------
class SchechterMassDist : public AnyDataObj {
  friend class ObjFileIO<SchechterMassDist>;
public:
  SchechterMassDist(Schechter sch,double massmin,double massmax,int nbinmass);
  SchechterMassDist(void);
  virtual ~SchechterMassDist(void);

  int GetMassLim(double& massmin,double& massmax);
  int SetNgalLim(int ngalmax,int ngalmin=1,unsigned long nalea=10000);
  int GetNgalLim(int& ngalmax,int& ngalmin);
  int GetNgalLim(void) {return nvalngal_;}
  Schechter GetSchechter(void) {return sch_;}

  inline int IndexFrNGal(int ngal) {
    int i = ngal-ngalmin_;
    if(nvalngal_<1 || i<0) return -1;
    if(i>=nvalngal_) return -2; else return i;
  }
  inline int NGalFrIndex(int i) {
    if(nvalngal_<1 || i<0 || i>=nvalngal_) return -1;
    return ngalmin_+i;
  }

  Histo GetHmDnDm(void) const;
  FunRan GetTmDnDm(void) const;

  Histo GetHisto(int i) const;
  FunRan GetFunRan(int i) const;

  double TirMass(int ngal);

  void Print(void);
  void PrintStatus(void);

  void WritePPF(string ppfname);
  void ReadPPF(string ppfname);

protected:
 void Delete(void);

 Schechter sch_;
 unsigned short sch_outvalue_;

 double massmin_,massmax_;   int nbinmass_;
 int ngalmin_,ngalmax_,nvalngal_;
 unsigned long ntrial_dir, ntrial_tab;

 Histo* hmdndm_;
 FunRan* tirhmdndm_;

 vector<Histo> hmass_;
 vector<FunRan> tmass_;
};

} // Fin du namespace

//-----------------------------------------------------------------------------------
bool IsCompatible(Schechter& sch1,Schechter& sch2,double eps=1.e-4);

//-----------------------------------------------------------------------------------
double Msol2FluxHI(double m,double d);
double FluxHI2Msol(double f,double d);

#endif
