/*
Check if suivi is OK
> chkfsv -e 1,99999,10 -m 1,99999,10 -p 2 -d 1001,11 s4l074l15R.suivi01
> echo $status
*/
#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <iostream>
#include <typeinfo>
#include <unistd.h>

#include "fsvcache.h"
#include "fsvst.h"

void usage(void)
{
 printf("Usage: chkfsv NomSuivi\n");
 printf("  -e n1,n2,inc : Traitement des etoiles n1 a n2 avec increment inc\n");
 printf("  -m m1,m2,inc : Traitement des mesures m1 a m2 avec increment inc\n");
 printf("  -p lp : print level\n");
 printf("  -d et,mes : debug by full printing for star et and mesure mes\n");
 printf("Warning: number go [1,n]\n");
}

int main(int narg, char *arg[] )
{
 //---- Decodage des arguments
 int lp=1, etdbg=-1, mesdbg=-1;
 int numes1=1, numes2=9999999, incmes=1;
 int numet1=1, numet2=9999999, incet=1;
 if(narg<2)  {usage(); return 1;}
 char c;
 while((c = getopt(narg, arg, "he:m:p:d:")) != -1) {
   switch (c) {
   case 'e' :
     sscanf(optarg,"%d,%d,%d",&numet1,&numet2,&incet);
   case 'm' :
     sscanf(optarg,"%d,%d,%d",&numes1,&numes2,&incmes);
   case 'p' :
     sscanf(optarg,"%d",&lp);
     if(lp<0) lp=0;
   case 'd' :
     sscanf(optarg,"%d,%d",&etdbg,&mesdbg);
   break;
   case 'h' :
   default:
     usage();
     return 1;
   }
 }
 if(optind>=narg) {usage(); return 2;}
 char svf[2048];
 strcpy(svf,arg[optind]);

 int rc = 0;

 //---- Ouverture du fichier de suivi
 SUIVIFIP *sfip = NULL;
 if( (sfip=SuiviOpen(svf,SUOF_RO_MEM2)) == NULL ) {
   cout<<"Error opening: "<<svf<<endl;
   return(10);
 }
 if(lp>0) cout<<svf<<endl;
 int nbstar = SuiviGetNbStars(sfip);
 int nbmes = SuiviGetNbMesures(sfip);
 if(lp>0) cout<<"nbstar = "<<nbstar<<" nbmes = "<<nbmes<<endl;

 if(incet<=0) incet = 1;
 if(numes1<1) numes1 = 1;
 if(numes2<1) numes2 = 1;
 if(numes2>nbmes) numes2 = nbmes;
 if(numes2<numes1) numes1 = numes2;
 if(incmes<=0) incmes = 1;
 if (numet1<1) numet1 = 1;
 if (numet2<1) numet2 = 1;
 if (numet2>nbstar) numet2 = nbstar;
 if (numet2<numet1) numet1 = numet2;
  
 //----  Lecture GlobInfo
 GLOBINFO glinf;
 if(lp>0) cout<<"Reading GlobInfo"<<endl;
 rc = SuiviReadGlobInfo(sfip, (char *)(&glinf));
 if(rc!=0) {
   cout<<"Error reading GlobInfo rc="<<rc<<endl;
   return 11;
 } 
 if(lp>1) {cout<<"\n>>> GLOBINFO"<<endl; PrtGlobInfo(&glinf,99);}
  
 //---- Lecture TimeInfo
 TIMEINFO tminf;
 TIMEINFOU tminfu;
 if(lp>0) cout<<"Reading TimeInfo from "<<numes1<<" to "<<numes2<<" with inc "<<incmes<<endl;
 if(nbmes>0) for(int i=numes1;i<=numes2;i++) {
   rc = SuiviReadTimeInfo(sfip,i,i,(char *)(&tminf));
   if(rc!=0) {
     cout<<"Error reading TimeInfo mes="<<i<<" rc="<<rc<<endl;
     return 12;
   }
   if(mesdbg==i) {
     cout<<"\n>>> TIMEINFO"<<endl; PrtTimeInfo(&tminf,i,99);
     DecodeTim(&tminf,&tminfu);
     cout<<"\n>>> TIMEINFOU"<<endl; PrtTimeInfoU(&tminfu,i,99);
   }
 }
  
 //---- Lecture StarInfo
 STARINFO  star;
 if(lp>0) cout<<"Reading StarInfo from "<<numet1<<" to "<<numet2<<" with inc "<<incet<<endl;
 if(nbstar>0) for(int i=numet1;i<=numet2;i+=incet) {
   rc = SuiviReadStarInfo(sfip,i,(char *)(&star));
   if(rc!=0) {
     cout<<"Error reading StarInfo star="<<i<<" rc="<<rc<<endl;
     return 13;
   }
   if(etdbg==i) {cout<<"\n>>> STARINFO"<<endl; PrtStarInfo(&star,i,99);}
 }
  
  //---- Lecture Mesures
  MESURE mes;
  MESUREU mesu;
  if(lp>0) cout<<"Reading Mesures"<<endl;
  if(nbstar>0) for(int i=numet1;i<=numet2;i+=incet) {
    if(nbmes>0) for(int j=numes1;j<=numes2;j+=incmes) {
      rc = SuiviReadMesures(sfip,i,j,j,(char *)(&mes));
      if(rc!=0) {
        cout<<"Error reading Mesures star="<<i<<" mes="<<j<<" rc="<<rc<<endl;
        return 14;
      }
      if(etdbg==i && mesdbg==j) {
        cout<<"\n>>> MESURE"<<endl; PrtMesure(&mes,j,99);
        DecodeMes(&mes,&mesu);
        cout<<"\n>>> MESUREU"<<endl; PrtMesureU(&mesu,j,99);
        Calibre_F_E(&mesu,&tminfu);
        cout<<"\n>>> MESUREU apres Calib"<<endl; PrtMesureU(&mesu,j,99);
      }
    }
  }
  
  //---- Fermeture du fichier de Suivi
  rc = SuiviClose(sfip);
  if(rc!=0) {
    cout<<"Error Closing Suivi file rc="<<rc<<endl;
    return 15;
  }

  return(rc);
}
