#ifndef PLANCKSPECTRA_SEEN
#define PLANCKSPECTRA_SEEN

#include "machdefs.h"
#include "genericfunc.h"

namespace SOPHYA {

//-----------------------------------------------------------------------------------
class PlanckSpectra : public GenericFunc {
public:
  PlanckSpectra(double T);
  PlanckSpectra(PlanckSpectra& s);
  virtual ~PlanckSpectra(void);

  inline void SetTemperature(double T) {T_ = T;}
  inline double GetTemperature(void) {return T_;}

  void SetApprox(unsigned short approx=0);
  void SetDeriv(unsigned short deriv=0);
  void SetVar(unsigned short typvar=0);
  void SetTypSpectra(unsigned short typspec=0);
  void SetUnitOut(unsigned short unitout=0);


  virtual double operator() (double x);

  double F2L(double nu_or_lambda);
  double PlanckEnergie(void);
  double PlanckPhoton(void);
  double WienLaw(void);
  double FindMaximum(double eps=0.001);

protected:
  double T_;
  unsigned short approx_,deriv_,typvar_,typspec_,unitout_;

  double PlanckExp(double fl);
  double DPlanckExp_DT(double fl);

};

} // Fin du namespace SOPHYA

#endif
