/*
 *  PIButtonQuartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on Tue Aug 17 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include "PIButtonQuartz.h"

EventTypeSpec controlEvents[] = {{kEventClassControl, kEventControlHit}};

vector<PIButton*> vpib;

static void MyControlActionCallback (ControlRef theControl, ControlPartCode partCode);

PIButtonQuartz::PIButtonQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py)
:PIButtonGen(par,nom,msg,sx,sy,px,py)
{
    CreatePushButtonControl (par->GetWindowPtr(),&wdgRect,title,&contH);
    SetControlTitleWithCFString (contH, title);
	_actionProc = NewControlActionUPP (MyControlActionCallback);
	SetControlAction (contH, _actionProc);
	vpib.push_back(this);
}


PIButtonQuartz::~PIButtonQuartz()
{
}

void PIButtonQuartz::ActivatePress(bool acp)
{
	return;
}	

void PIButtonQuartz::SetLabel(string const& sText)
{
    title = CFStringCreateWithCString (NULL, sText.c_str(), kCFStringEncodingMacRoman);
	SetControlTitleWithCFString(contH,title);
	return;
}

static void MyControlActionCallback (ControlRef theControl, ControlPartCode partCode)
{
	vector<PIButton*>::iterator it;
	for(it = vpib.begin(); it != vpib.end(); it++)
        {
            if (((*it)->GetControlRef())==theControl)
            {
                (*it)->Send((*it)->Msg(),PIMsg_Click,NULL);
				printf ("click : %d \n",(*it)->Msg());
                break;
            }
        }
}

