/*
 *  pistdwdgmosx.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on 24/08/07.
 *  Copyright 2007 __MyCompanyName__. All rights reserved.
 *
 */

#include "pistdwdgmosx.h"


/* ========== PILabelQuartz ========== */

/* --Methode-- */
PILabelQuartz::PILabelQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PILabelGen(par, nom, sx, sy, px, py)
{
}

/* --Methode-- */
PILabelQuartz::~PILabelQuartz()
{
}

/* --Methode-- */
void PILabelQuartz::SetLabel(string const& sLabel)
{
	OSStatus err;
	
	cfsrLabel = CFStringCreateWithCString(kCFAllocatorDefault,sLabel.c_str(),kCFStringEncodingMacRoman);
	err = DrawThemeTextBox (cfsrLabel,
							kThemeSystemFont,
							kThemeStateInactive,
							false,
							&wdgRect,
							teJustLeft,
							NULL);
			
	return;
} 


/* ========== PITextQuartz ========== */

/* --Methode-- */
PITextQuartz::PITextQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
	OSStatus err;
	HIRect	hiRect; // = { { 0, 0 }, { 100, 100 } };
	int ox,oy,fx,fy;
	int mx,my;
	wParent = ((PIContainer *)par)->GetWindowPtr();
	mx = sx/50;
	my = sy/50; 
	ox = px+mx;
	oy = py+my;
	fx = px+sx-mx;
	fy = py+sy-my;
	
	SetRect(&userPaneRect,ox,oy,fx,fy);
	hiRect.origin.x = ox;
	hiRect.origin.y = oy;
	hiRect.size.width = fx-ox;
	hiRect.size.height = fy-oy;
	err = HITextViewCreate (&hiRect,0,0,&outTextView);
	err = CreateUserPaneControl (wParent, &userPaneRect,kControlSupportsEmbedding,&fUserPane);
	err = SetControlVisibility(fUserPane, true, true );
}

/* --Methode-- */
PITextQuartz::PITextQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx, int sy, int px, int py)
: PITextGen(par, nom, vsb, hsb, sx, sy, px, py)
{
}

/* --Methode-- */
PITextQuartz::~PITextQuartz()
{
}


/* --Methode-- */
void PITextQuartz::SetText(string const& s)
{	
	OSStatus err;
	CFStringRef cfsrText;
	
	cfsrText = CFStringCreateWithCString (NULL,(char *)s.c_str(), kCFStringEncodingMacRoman);

	TXNObject txn = HITextViewGetTXNObject(outTextView);
	textLength = CFStringGetLength(cfsrText);
	uniChars = (UniChar*) malloc( sizeof( UniChar ) * textLength );
	CFStringGetCharacters(cfsrText, CFRangeMake( 0, textLength ), uniChars );
	err = TXNSetData(txn,kTXNUnicodeTextData, uniChars, textLength * sizeof( UniChar ), 0, 0 );
	err = HIViewAddSubview (fUserPane, outTextView);
	HIViewPlaceInSuperviewAt (outTextView,10,10);
	ShowControl (fUserPane);
	err = HIViewSetVisible (outTextView, true);

	return;
}

/* --Methode-- */
string PITextQuartz::GetText() const
{
	CFStringRef str;
	char* cText;

	GetControlData(outTextView, kControlEditTextPart, kControlEditTextCFStringTag, sizeof(str),&str,NULL);
	cText = (char *)CFStringGetCStringPtr(str,kCFStringEncodingMacRoman);
	/*
	textLength = CFStringGetLength(str);
	uniChars = (UniChar*) realloc( sizeof( UniChar ) * textLength );
	CFStringGetCharacters(str, CFRangeMake( 0, textLength ), uniChars );
	*/
	
	string sText(cText);	
	return (sText);
}


/* --Methode-- */
void PITextQuartz::SetMutiLineMode(bool mlm)
{
	return;
}


/* --Methode-- */
void PITextQuartz::SetTextEditable(bool te)
{
	return;
}


/* --Methode-- */
void PITextQuartz::SetMsg(PIMessage msg)
{

}
