/*
 *  piwdgmosx.h
 *  PI
 *
 *  Created by Bruno MANSOUX on Tue Mar 30 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include <Carbon/Carbon.h>

#ifndef PIWDG_QUARTZ_SEEN
#define PIWDG_QUARTZ_SEEN

#include "piwdggen.h"



/*
EventTypeSpec drawEvents[] = {{kEventClassControl, kEventControlDraw},
                            {kEventClassWindow,kEventWindowDrawFrame},
                            {kEventClassWindow,kEventWindowDrawPart},
                            };

*/


class PIWdgQuartz : public PIWdgGen 
{
public:
// Les methodes ...
        PIWdgQuartz(PIContainerGen *par, const char *nom, 
                int sx=10, int sy=10, int px=0, int py=0);

  virtual 	 ~PIWdgQuartz();

  virtual void	 FinishCreate(); // apres avoir installe les sous-vues

  virtual void   SetSize(int sx, int sy);
  virtual void   SetPos(int px, int py);
  virtual void   SetBorderWidth(int bw);


//  Divers : couleur de fond, et d'avant plan Effacement fenetre,
  virtual void           SetBackgroundColor(PIColors col=PI_White);
  virtual void           SetForegroundColor(PIColors col=PI_Black);
  virtual void           EraseWindow(int x0=0, int y0=0, int dx=0, int dy=0);
  virtual PIColors       GetBackgroundColor();
  virtual PIColors       GetForegroundColor();

  virtual void   SetBinding(PIBindingKind left, PIBindingKind top, 
                            PIBindingKind right, PIBindingKind bottom);
  virtual bool   GetBinding(PIBindingKind& left, PIBindingKind& top, 
                            PIBindingKind& right, PIBindingKind& bottom);

  virtual int    XSize();
  virtual int    YSize();
  virtual int    XPos();
  virtual int    YPos();

  virtual string Nom();  
  virtual void   GetScreenPos(int & spx, int & spy);

  virtual void   Manage();
  virtual void   UnManage();
  virtual bool   IfManaged();
  virtual bool   IsVisible();

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
  virtual void       	 Refresh();

//  Pour rendre un composant graphique (PIWdg) sensible/insensible 
  virtual void           SetSensitive();
  virtual void           SetUnSensitive();
  virtual bool           IfSensitive();

//  Gestion de copier-coller
  virtual bool           ClaimSelection(unsigned int typ=PICP_string);
  virtual void           SelectionLost();
  virtual unsigned int   RequestSelection(unsigned int typ=PICP_string);
  virtual void*          ProvideSelection(unsigned int& typ, unsigned int& len);
  virtual void           SelectionTransferEnd();
  virtual void           PasteSelection(unsigned int typ, void *, unsigned int l);

//  Copie depuis un PIWdgGen
  virtual void		 CopyFrom(PIWdgGen* wdg, int ox, int oy, int dx, int dy, int x, int y);

//  Gestion des EventHandler
  virtual void		 AddDrawHandler(PIEventHandler* drwh, bool ad=false);
  virtual void		 RemoveDrawHandler(PIEventHandler* drwh);
  virtual void		 AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad=false);
  virtual void		 RemoveEventHandler(PIEventHandler* evh);

// En public, pour permettre l'acces depuis call-back Xt
  virtual void		 CallDrawHandlers(int x0, int y0, int dx, int dy); 
  virtual void		 CallEventHandlers(unsigned long evt, int px, int py,
                                           int k, int km, unsigned long tm);

protected:
    Rect	wdgRect;
    CFStringRef	title;
    ControlRef	contH;
    WindowPtr	wPtr;
//  pas utilisable dans MOSX/Carbon
    PIColors mFCol, mBCol;
};

typedef PIWdgQuartz PIWdg;

#endif/* PIWDG_QUARTZ_SEEN */

