/*
    QuartzAppTest.cpp
    
    BMX 14/06/04 
    
    Test Program for PI4Mac validation
    
*/

#include <PIApplQuartz.h>
#include <PIMenuBarQuartz.h>
#include <PIWindowQuartz.h>
#include <PIButtonQuartz.h>
#include <pistdwdgmosx.h>


int main(int argc, char *argv[])
{
    PIApplication* mainApp;
    PIMenu* firstMenu;
    PIMenu* underMenu;    
    PIMenubar* mBar;
    PIWindow* windowFirst;				
    PIContainer* piCont;
    PIWindowGen* wGen;
    PIContainer* piContQ; 
    PIWdg* piWdg;
	PILabel *piLabel;
    PIButton* piButton;
    vector<int> points;

    /* Creation of general objects */

    mainApp = new PIApplication();
    piCont = mainApp->MainWin();

    firstMenu = new PIMenu((PIWdg *)mainApp, (const char *)"First Menu");
    firstMenu->AppendItem("One from first", 1000);
    firstMenu->AppendSeparator();
    firstMenu->AppendItem("Two from first", 1001);
    firstMenu->AppendCheckItem("Three from first", 1002);
	
	underMenu = new PIMenu((PIWdg *)firstMenu,(const char *)"submenu");
    firstMenu->AppendCascadeMenu(underMenu,1001);
    printf ("Menus created \n");
    fflush (stdout);
	underMenu->AppendItem("Sub from 2",2001);
	printf ("SubMenus created \n");
    fflush (stdout);

    mBar = mainApp->Menubar();
    mBar->AppendMenu(firstMenu);
    
    windowFirst = new PIWindow((PIMsgHandler *)piCont, (const char *)"Window First",PIWK_normal,50,50,600,200);
    wGen = new PIWindowGen((PIMsgHandler *)piCont,(const char *)"Window Gen",PIWK_normal,50,50,600,20);
    piContQ = new PIContainer (piCont,(const char *)"Container First",50,50,600,20);
    piWdg = new PIWdg (piCont,(const char *)"Wdg First",50,50,600,20);
	piLabel = new PILabel(windowFirst,(const char *)"Label",80,80,150,150);

	piButton = new PIButton(windowFirst, "Hello",777,20,40,80,80);

    windowFirst->Refresh();
	piLabel->SetLabel("Etiquette");

    mainApp->Run(); // Main loop

    return 0;
}
