/*
 *  PIControl.h
 *  PI
 *
 *  Created by Bruno MANSOUX on Wed Apr 07 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include <Carbon/Carbon.h>

#ifndef PICONTROL_SEEN
#define PICONTROL_SEEN

#include "piwdgmosx.h"

/*
EventTypeSpec controlEvents[] = {{kEventClassControl, kEventControlHit}};
*/

class PIControl : public PIWdgQuartz
{
public:
// Les methodes ...
    PIControl(PIContainerGen *par, const char *nom, 
                int sx=10, int sy=10, int px=0, int py=0);

  virtual 	 ~PIControl();

  virtual void   SetSize(int sx, int sy);
  virtual void   SetPos(int px, int py);

  virtual void   Manage();
  virtual void   UnManage();
  virtual bool   IfManaged();
  virtual bool   IsVisible();

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
  virtual void       	 Refresh();

//  Pour rendre un composant graphique (PIControl) sensible/insensible 
  virtual void           SetSensitive();
  virtual void           SetUnSensitive();
  virtual bool           IfSensitive();

//  Gestion des EventHandler
  virtual void		 AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad=false);
  virtual void		 RemoveEventHandler(PIEventHandler* evh);
  virtual void		 AddDrawHandler(PIEventHandler* drwh, bool ad=false);
  virtual void		 RemoveDrawHandler(PIEventHandler* drwh);


// En public, pour permettre l'acces depuis call-back Xt
  virtual void		 CallDrawHandlers(int x0, int y0, int dx, int dy); 
  virtual void		 CallEventHandlers(unsigned long evt, int px, int py,
                                           int k, int km, unsigned long tm);

};

#endif

