/*
 *  PIMenuBarQuartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on Fri May 28 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */
 
#include "PIMenuBarQuartz.h"
#include PIAPP_H

static PIMenubar* MainMenuBar;

PIMenuBarQuartz::PIMenuBarQuartz(PIApplicationGen* par, const char* nom)
: PIMenubarGen(par, nom)
{
    EventTypeSpec menuEvent = {kEventClassCommand, kEventCommandProcess};
    
    DrawMenuBar();
    InstallApplicationEventHandler(NewEventHandlerUPP(MenuEventHandler),1,&menuEvent,0,NULL);
    MainMenuBar = this;
	piApp = par;
}

PIMenuBarQuartz::~PIMenuBarQuartz()
{
}

void PIMenuBarQuartz::AppendMenu(PIMenu *pdm)
{
    InsertMenu (pdm->GetMenuRef(),0);
    vPIMenu.push_back(pdm);
    return;
}

void PIMenuBarQuartz::RemoveMenu(PIMenu *pdm)
{
    vector<PIMenu*>::iterator it;

    for(it = vPIMenu.begin(); it != vPIMenu.end(); it++)
        {
            if ((*it)->GetMenuID()==(pdm->GetMenuID()))
            {
                vPIMenu.erase(it);
                break;
            }
        }
    DeleteMenu (pdm->GetMenuID());
    return;
}

void PIMenuBarQuartz::SetSensitivity(PIMenu *pdm, bool sens)
{
    // Not relevant in Carbon/MACOSX
    return;
}

bool PIMenuBarQuartz::IsSensitive(PIMenu *pdm)
{
    // Not relevant in Carbon/MACOSX
    return true;
}

PIMessage PIMenuBarQuartz::GetMsg(MenuRef menuRef, int commandID)
{
    vector<PIMenu*>::iterator it;
    for(it = vPIMenu.begin(); it != vPIMenu.end(); it++)
        {
            if ((*it)->GetMenuRef() == menuRef)
            {
                return (*it)->GetMsgItem(commandID);
            }
        }
	return 0;
} 

void PIMenuBarQuartz::Dispatch(HICommand commandStruct, void* userData)
{
	PIMessage msg;
	
	msg = GetMsg(commandStruct.menu.menuRef,commandStruct.commandID);
	Process(BuildMsg(msg,PIMsg_Click), piApp, userData);
		
	return;
}

/* ========== Common Handler for Menu Events ========== */
OSStatus MenuEventHandler (EventHandlerCallRef myHandler, EventRef event, void* userData)
{
    OSStatus result = eventNotHandledErr;
    HICommand commandStruct; 
    short itemHit;

    GetEventParameter (event, kEventParamDirectObject, 
                        typeHICommand, NULL, sizeof(HICommand), 
                        NULL, &commandStruct);
    
    if ((commandStruct.commandID) == kHICommandAbout)
    {
        /*        RunStandardAlert (aboutBox, NULL, &itemIndex);*/
        StandardAlert (kAlertStopAlert, 
                        "\pQuartz Test",
                        "\pPeida Interactive based",
                        NULL,
                        &itemHit);

        result = noErr;
    }
    else if ((commandStruct.commandID) == kHICommandQuit)
    {
        ExitToShell ();
        result = noErr;
    }
    else
    {
		printf("Menu Item selected %u \n", commandStruct.commandID);
		fflush (stdout);		
		MainMenuBar->Dispatch(commandStruct, userData);
		result = noErr;
    }

    return (result);
}

