/*
 *  PIWindowQuartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on Tue Apr 13 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include "PIWindowQuartz.h"

PIWindowQuartz::PIWindowQuartz(PIMsgHandler *par, const char *nom, PIWindowKind k, int sx, int sy, int px, int py)
:PIWindowGen(par, nom, k, sx, sy, px, py) 
{
    OSStatus err = 0;
    WindowAttributes windowAttributes;
    
    printf ("New Window Quartz %s \n",nom);
    fflush (stdout);
    windowAttributes = kWindowStandardDocumentAttributes | kWindowCompositingAttribute ;

    err = CreateNewWindow (kDocumentWindowClass,windowAttributes,&wdgRect,&wPtr);
    if (err)
        printf ("PIWindowQuartz Create Err = %d \n",err);
    fflush (stdout);
    
    err = SetWindowTitleWithCFString (wPtr,title);
    
    if (err)
        printf ("PIWindowQuartz Title Err = %d \n",err);
    fflush (stdout);
    InstallStandardEventHandler(GetWindowEventTarget(wPtr)); /* installs the default */    
    printf("Window installed with title %s\n",nom);
    fflush (stdout);
}

PIWindowQuartz::~PIWindowQuartz()
{

}

void PIWindowQuartz::SetSize(int sx, int sy)
{
    SizeWindow (wPtr, sx, sy, true);
    return;
}

void PIWindowQuartz::SetPos(int px, int py)
{
    MoveWindow (wPtr, px, py, false);
    return;
}

void PIWindowQuartz::Manage()
{
    return;	
}

void PIWindowQuartz::UnManage()
{
	HideWindow(wPtr);
    return;
}

bool PIWindowQuartz::IfManaged()
{
    return true;
}
 
bool PIWindowQuartz::IsVisible()
{
    return (IsWindowVisible(wPtr));
}

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
void PIWindowQuartz::Refresh()
{
    SetPortWindowPort(wPtr);
    ShowWindow (wPtr);
    BeginUpdate(wPtr);
 //   EraseRect(GetWindowPortBounds(window, &tempRect));
    DrawControls(wPtr);
    DrawGrowIcon(wPtr);
    EndUpdate(wPtr);

    return ;
}

//  Pour rendre un composant graphique (PIWdg) sensible/insensible 
void PIWindowQuartz::SetSensitive()
{
    ActivateWindow (wPtr, true);
    return;
}

void PIWindowQuartz::SetUnSensitive()
{
    ActivateWindow (wPtr, false);
    return;
}

bool PIWindowQuartz::IfSensitive()
{
    return (IsWindowActive(wPtr));
}

//  Gestion des EventHandler
void PIWindowQuartz::AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad)
{
/*
    InstallWindowEventHandler (contH, 
                                NewEventHandlerUPP (evh),
                                GetEventTypeCount(evtmask),
                                evtmask,
                                contH,
                                NULL);
                                
*/
    return;
}

void PIWindowQuartz::RemoveEventHandler(PIEventHandler* evh)
{
    RemoveEventHandler(evh);
    return;
}


// En public, pour permettre l'acces depuis call-back Xt
void PIWindowQuartz::CallDrawHandlers(int x0, int y0, int dx, int dy)
{
    return;
}

void PIWindowQuartz::CallEventHandlers(unsigned long evt, int px, int py,
                                    int k, int km, unsigned long tm)
{
    return;
}

