#include "piacmd.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "basexecut.h"

#include "pdlmgr.h"
#include "ctimer.h"
// #include "dlftypes.h"

#include "pistdimgapp.h"
#include "nobjmgr.h"

#include PISTDWDG_H 
#include PILIST_H 

// ------------------------------------------------------------
//         Gestion d'une fenetre d'aide interactive        
// ------------------------------------------------------------

class PIAHelpWind : public PIWindow {
public :
		PIAHelpWind(PIStdImgApp* par, PIACmd* piacmd);
  virtual	~PIAHelpWind();
  virtual void  Show();
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
  inline  void  AddHelpGroup(const char * hgrp, int gid)
                    { hgrpom->AppendItem(hgrp, 20000+gid); }
  inline  void  ClearHelpList() 
                    { mNitem=0; hitemlist->DeleteAllItems(); }
  inline  void	AddHelpItem(const char * hitem) 
		    { mNitem++;  hitemlist->AppendItem(hitem, 100+mNitem); }
protected :
  PIStdImgApp* dap;
  PIACmd* piac;
  int mNitem;
  PIList* hitemlist;
  PIOptMenu* hgrpom;
  PIButton * mBut;
  PILabel * mLab;
  PIText* mTxt;
};

/* --Methode-- */
PIAHelpWind::PIAHelpWind(PIStdImgApp *par, PIACmd* piacmd)
  : PIWindow((PIMsgHandler *)par, "Help-PIApp", PIWK_normal,  400, 300, 100, 350)
{
dap = par;
piac = piacmd;
mNitem = 0;
SetMsg(77);

int bsx, bsy;
int tsx, tsy;
int spx, spy;
PIApplicationPrefCompSize(bsx, bsy);
spx = bsx/6;   spy = bsy/6;
tsx = 10*bsx+2*spx;  tsy = 7*bsy+3*spy;
SetSize(tsx,tsy);
hgrpom = new PIOptMenu(this, "hgrpoptmen", bsx*2.0, bsy, spx/2, spy);
hgrpom->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
hitemlist = new PIList(this, "hitemlist", bsx*2.0, tsy-3*spy-bsy, spx/2, 2*spy+bsy);
hitemlist->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
// hitemlist->SetBorderWidth(2);
mTxt = new PIText(this, "helptext", true, true, bsx*8.0, 6*bsy, bsx*2.0+1.5*spx, spy);
// mTxt->SetMutiLineMode(true);
mTxt->SetTextEditable(false);
mTxt->SetText("");
mTxt->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mLab = new PILabel(this, "helpitem", bsx*4, bsy, bsx*2.5+2*spx, tsy-spy-bsy);
mLab->SetBorderWidth(1);
mLab->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mLab->SetLabel("");
mBut = new PIButton(this, "Close", 70, bsx, bsy, tsx-bsx*1.5-spx, tsy-spy-bsy);
mBut->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
}

/* --Methode-- */
PIAHelpWind::~PIAHelpWind()
{
delete hgrpom;
delete hitemlist;
delete mTxt;
delete mLab;
delete mBut;
}

/* --Methode-- */
void PIAHelpWind::Process(PIMessage msg, PIMsgHandler* sender, void* /*data*/)
{
PIMessage um = UserMsg(msg);
if (((um == 77) && (ModMsg(msg) == PIMsg_Close)) || (um == 70) ) {
  Hide();
  return;
  }
else if ( (um >= 20000) && (sender == hgrpom)) {  // Selection de groupe de Help
  mTxt->SetText("");
  mLab->SetLabel("");
  piac->UpdateHelpList(this, um-20000);
}
else if ( (um > 100) && (sender == hitemlist) && (ModMsg(msg) == PIMsg_Select) ) {
  string s = hitemlist->GetSelectionStr();
  mTxt->SetText(piac->GetUsage(s));
  mLab->SetLabel(s);
  }  
}

/* --Methode-- */
void PIAHelpWind::Show()
{
hgrpom->SetValue(20000);   // Groupe All
mTxt->SetText("");
mLab->SetLabel("");
piac->UpdateHelpList(this, 0); 
PIWindow::Show();
}

static PIACmd* curpiacmd = NULL;
/* --Methode-- */
PIACmd::PIACmd(NamedObjMgr* omg, PIStdImgApp* app)
{
mObjMgr = omg; 
mImgApp = app;
system("cp history.pic hisold.pic");
hist.open("history.pic");
trace = false;   timing = false;
gltimer = NULL;

cmdhgrp["All"] = 0;
cmdgrpid = 1;
cmdhgrp["Commands"] = 1;
helpwin = new PIAHelpWind(app, this);
helpwin->AddHelpGroup("All", 0);
helpwin->AddHelpGroup("Commands", 1);

string kw = "piacmd";
string usage;
usage = ">>> (piacmd) Interpreter's keywords : \n";
usage += "  timingon  timingoff traceon  traceoff \n";
usage += "  set unset listvar listcommands exec shell \n";
usage += "  > set varname 'string'   # To set a variable, $varname \n";
usage += "  > setol varname patt     # Fills varname with object list \n";
usage += "  > unset varname          # clear variable definition \n";
usage += "  > echo string            # output string \n";
usage += "  > listvars   # List of variable names and values \n";
usage += "  > listcommands # List of all known commands \n";
usage += "  > exec filename  # Execute commands from file \n";
usage += "  > shell comand_string  # Execute shell command \n";
usage += "  > help <command_name>  # <command_name> usage info \n"; 
usage += "  > helpwindow           # Displays help window \n";
string grp = "Commands";
RegisterHelp(kw, usage, grp);

basexec = new PIABaseExecutor(this, omg, app);
AddInterpreter(this);
curcmdi = this;
}

/* --Methode-- */
PIACmd::~PIACmd()
{
hist.close();
if (gltimer) { delete gltimer;  gltimer = NULL; }
Modmap::iterator it;
for(it = modmap.begin(); it != modmap.end(); it++) {
  string name = (*it).first + "_end";
  DlModuleInitEndFunction fend = (*it).second->GetFunction(name);
  if (fend) fend();
  delete (*it).second;
  }
delete helpwin;
if (curpiacmd == this)  curpiacmd = NULL;
}

/* --Methode-- */
PIACmd* PIACmd::GetInterpreter()
{
return(curpiacmd);
}

/* --Methode-- */
string PIACmd::Name()
{
return("piacmd");
}

/* --Methode-- */
void PIACmd::RegisterCommand(string& keyw, string& usage, CmdExecutor * ce, string grp)
{
if (!ce) { 
  RegisterHelp(keyw, usage, grp);
  return;
  }
int gid = CheckHelpGrp(grp);
cmdex cme;
cme.group = gid;
cme.us = usage;
cme.cex = ce;
cmdexmap[keyw] = cme;
}

/* --Methode-- */
void PIACmd::RegisterHelp(string& keyw, string& usage, string& grp)
{
int gid = CheckHelpGrp(grp);
cmdex cme;
cme.group = gid;
cme.us = usage;
cme.cex = NULL;
helpexmap[keyw] = cme;
}

/* --Methode-- */
int PIACmd::CheckHelpGrp(string& grp)
{
int gid=0;
CmdHGroup::iterator it = cmdhgrp.find(grp);
if (it == cmdhgrp.end()) {
  cmdgrpid++;   gid = cmdgrpid;
  cmdhgrp[grp] = gid;
  helpwin->AddHelpGroup(grp.c_str(), gid);
  }
else gid = (*it).second;
return(gid);
}

/* --Methode-- */
void PIACmd::UpdateHelpList(PIAHelpWind* hw, int gid)
{
helpwin->ClearHelpList();
CmdExmap::iterator it;
for(it = helpexmap.begin(); it != helpexmap.end(); it++) {
  if ( (gid != 0) && ((*it).second.group != gid) ) continue;
  helpwin->AddHelpItem((*it).first.c_str());
  }
for(it = cmdexmap.begin(); it != cmdexmap.end(); it++) {
  if ( (gid != 0) && ((*it).second.group != gid) ) continue;
  helpwin->AddHelpItem((*it).first.c_str());
  }
}

/* --Methode-- */
void PIACmd::LoadModule(string& fnameso, string& name)
{
PDynLinkMgr * dynlink = new PDynLinkMgr(fnameso, false);
if (dynlink == NULL) {
  cerr << "PIACmd/LoadModule_Error: Pb opening SO " << fnameso << endl;
  return;
  }
string fname = name + "_init";
DlModuleInitEndFunction finit = dynlink->GetFunction(fname);
if (!finit) {
  cerr << "PIACmd/LoadModule_Error: Pb linking " << fname << endl;
  return;
  }
cout << "PIACmd/LoadModule_Info: Initialisation module" << name 
     << "  " << fname << "() ..." << endl;
finit();
modmap[name] = dynlink;
return;
}

/* --Methode-- */
void PIACmd::AddInterpreter(CmdInterpreter * cl)
{
if (!cl) return;
interpmap[cl->Name()] = cl;
}

/* --Methode-- */
void PIACmd::SelInterpreter(string& name)
{
InterpMap::iterator it = interpmap.find(name);
if (it == interpmap.end())   return;
curcmdi = (*it).second;
}


//  Pour le decoupage des commandes en lignes 
typedef vector<string> cmdtok;

/* --Methode-- */
int PIACmd::Interpret(string& s)
{
int rc = 0;
cmdtok tokens;
if (s.length() < 1)  return(0);

hist << s << endl;   // On enregistre les commandes 

if (s[0] == '#') {
  cout << "PIACmd::Interpret() Comment-Line:" << s << endl;
  return(0); 
  } 
string toks,kw;
size_t p = s.find_first_not_of(" ");
s = s.substr(p);
p = 0;
size_t q = s.find_first_of(" ");
size_t l = s.length();

if (q < l)
  {  kw = s.substr(p,q-p);  toks = s.substr(q, l-q); }
else { kw = s.substr(p,l-p);  toks = ""; }

q = 0;
while (q < l)  {
  p = toks.find_first_not_of(" ",q+1); // au debut d'un token
  if (p>=l) break;
  q = toks.find_first_of(" ",p); // la fin du token;
  string token = toks.substr(p,q-p);
  tokens.push_back(token);
  }

for(int k=0; k<tokens.size(); k++) { // On remplace les $varname par la valeur de la variable
  if ((tokens[k])[0] != '$')  continue; 
  CmdVarList::iterator it = mVars.find(tokens[k].substr(1));
  if (it != mVars.end())  tokens[k] = (*it).second;
  }

// cout << "PIACmd::Do() DBG  KeyW= " << kw << " NbArgs= " << tokens.size() << endl;
//  for(int ii=0; ii<tokens.size(); ii++)
//  cout << "arg[ " << ii << " ] : " << tokens[ii] << endl;

// >>>>>>>>>>> Commande d'interpreteur
if (kw == "helpwindow") ShowHelpWindow();
else if (kw == "help") {
  if (tokens.size() > 0) cout << GetUsage(tokens[0]) << endl;
  else {  
    string kwh = "piacmd";
    cout << GetUsage(kwh) << endl;
    }
  }

else if (kw == "set") {
  if (tokens.size() < 2) { cout << "PIACmd::Interpret() Usage: set varname string" << endl;  return(0); }
  string xx = "";
  for (int kk=0; kk<tokens.size(); kk++)  xx += (tokens[kk] + ' ');
  mVars[tokens[0]] = xx;
  }
else if (kw == "setol") {
  if (tokens.size() < 2) { cout << "PIACmd::Interpret() Usage: setol varname objnamepattern" << endl;  return(0); }
  vector<string> ol;
  mObjMgr->GetObjList(tokens[1], ol); 
  string vol = ""; 
  for (int kk=0; kk<ol.size(); kk++)  vol += (ol[kk] + ' ');
  mVars[tokens[0]] = vol;
  }
else if (kw == "unset") {
  if (tokens.size() < 1) { cout << "PIACmd::Interpret() Usage: unset varname" << endl;  return(0); }
  CmdVarList::iterator it = mVars.find(tokens[0]);
  if (it != mVars.end())  mVars.erase(it);
  else cerr << "PIACmd::Interpret() No variable with name " << tokens[0] << endl;
  }
else if (kw == "echo") {
  for (int kk=0; kk<tokens.size(); kk++)  cout << tokens[kk] << " " ;
  cout << endl;
  }
else if (kw == "listvars") {
  cout << "PIACmd::Interpret()  Variable List , VarName = Value \n";
  CmdVarList::iterator it;
  for(it = mVars.begin(); it != mVars.end(); it++)  
    cout << (*it).first << " = " <<  (*it).second << "\n";
  cout << endl;
  }
else if (kw == "listvars") {
  cout << "---- PIACmd::Interpret()  Command Variable List ----- \n";
  CmdExmap::iterator it;
  int kc = 0;
  for(it = cmdexmap.begin(); it != cmdexmap.end(); it++) {
    cout << (*it).first << "  ";
    kc++;
    if (kc >= 5) { cout << "\n"; kc = 0; }
    }
  cout << endl;
  }
else if (kw == "traceon")  { cout << "PIACmd::Interpret()  -> Trace ON mode " << endl; trace = true; }
else if (kw == "traceoff") { cout << "PIACmd::Interpret()  -> Trace OFF mode " << endl; trace = false; }
else if (kw == "timingon") { 
  cout << "PIACmd::Interpret()  -> Timing ON mode " << endl; 
  if (gltimer)   delete gltimer;   gltimer = new Timer("PIA-CmdInterpreter ");   timing = true; 
  }
else if (kw == "timingoff") { 
  cout << "PIACmd::Interpret()  -> Timing OFF mode " << endl; 
  if (gltimer)  delete gltimer;  gltimer = NULL;  timing = false; 
  }
else if (kw == "exec") {
  if (tokens.size() < 1) { cout << "PIACmd::Interpret() Usage: exec filename" << endl;  return(0); }
  ExecFile(tokens[0]);
  }
else if (kw == "shell") {
  if (tokens.size() < 1) { cout << "PIACmd::Interpret() Usage: shell cmdline" << endl;  return(0); }
  system(toks.c_str());
  }
//  Execution d'une commande enregistree
else rc = ExecuteCommand(kw, tokens);

if (timing)  gltimer->Split();
return(rc);
}

/* --Methode-- */
int PIACmd::ExecuteCommandLine(string& line)
{
cmdtok tokens;
if (line.length() < 1)  return(0);

string toks,kw;
size_t p = line.find_first_not_of(" ");
line = line.substr(p);
p = 0;
size_t q = line.find_first_of(" ");
size_t l = line.length();

if (q < l)
  {  kw = line.substr(p,q-p);  toks = line.substr(q, l-q); }
else { kw = line.substr(p,l-p);  toks = ""; }

q = 0;
while (q < l)  {
  p = toks.find_first_not_of(" ",q+1); // au debut d'un token
  if (p>=l) break;
  q = toks.find_first_of(" ",p); // la fin du token;
  string token = toks.substr(p,q-p);
  tokens.push_back(token);
  }

return(ExecuteCommand(kw, tokens));  
}

/* --Methode-- */
int PIACmd::ExecuteCommand(string& keyw, vector<string>& args)
{
  int rc = -1;
  CmdExmap::iterator it = cmdexmap.find(keyw);
  if (it == cmdexmap.end())  cout << "No such command : " << keyw << " ! " << endl;
  else { 
    if ((*it).second.cex) rc = (*it).second.cex->Execute(keyw, args);
    else cout << "Dont know how to execute " << keyw << " ? " << endl;
    }
  return(rc);
}

/* --Methode-- */
int PIACmd::ExecFile(string& file)
{
char line_buff[512];
FILE *fip;

if ( (fip = fopen(file.c_str(),"r")) == NULL ) {
  cerr << "PIACmd::Exec() Error opening file " << file << endl;
  hist << "##! PIACmd::Exec() Error opening file " << file << endl;
  return(0);
  }
 
hist << "### Executing commands from " << file << endl;
if (trace) { 
  mImgApp->GetConsole()->AddStr("### Executing commands from ", PIVA_Magenta);
  mImgApp->GetConsole()->AddStr(file.c_str(), PIVA_Magenta);
  mImgApp->GetConsole()->AddStr("\n", PIVA_Magenta);
  }

while (fgets(line_buff,511,fip) != NULL)
  {
  if (trace) mImgApp->GetConsole()->AddStr(line_buff, PIVA_Magenta);
  line_buff[strlen(line_buff)-1] = '\0';   /*  LF/CR de la fin */
  string line(line_buff);
  Interpret(line);
  }
hist << "### End of Exec( " << file << " ) " << endl;
if (trace) { 
  mImgApp->GetConsole()->AddStr("### End of Exec( ", PIVA_Magenta);
  mImgApp->GetConsole()->AddStr(file.c_str(), PIVA_Magenta);
  mImgApp->GetConsole()->AddStr(" ) \n", PIVA_Magenta);
  }

return(0);
}


static string* videstr = NULL;
/* --Methode-- */
string& PIACmd::GetUsage(const string& kw)
{
bool fndok = false;
CmdExmap::iterator it = cmdexmap.find(kw);
if (it == cmdexmap.end()) {
  it = helpexmap.find(kw);
  if (it != helpexmap.end())  fndok = true;
  }
  else  fndok = true; 
if (fndok)   return( (*it).second.us ); 
// Keyword pas trouve
if (videstr == NULL) videstr = new string("");
*videstr =  "Nothing known about " + kw + " ?? ";
return(*videstr);
 
}

/* --Methode-- */
void PIACmd::ShowHelpWindow()
{
helpwin->Show();
}
