#ifndef PLANCKSPECTRA_SEEN
#define PLANCKSPECTRA_SEEN

#include "machdefs.h"
#include "genericfunc.h"

namespace SOPHYA {

//-----------------------------------------------------------------------------------
class PlanckSpectra : public GenericFunc {
public:

  typedef enum {PLANCK=0, RAYLEIGH=1, WIEN=2} SpectraApprox;
  typedef enum {POWER=0, PHOTON=1} SpectraPower;
  typedef enum {VALUE=0, DERIV=1} SpectraFunc;
  typedef enum {NU=0, LAMBDA=1} SpectraVar;
  typedef enum {ANGSFLUX=0, SFLUX=1, DENSENERG=2, EXPON=3} SpectraUnit;

  PlanckSpectra(double T);
  PlanckSpectra(PlanckSpectra& s);
  virtual ~PlanckSpectra(void);

  inline void SetTemperature(double T) {T_ = T;}
  inline double GetTemperature(void) {return T_;}

  void SetSpectraApprox(SpectraApprox spectraapprox=PLANCK);
  void SetSpectraFunc(SpectraFunc spectrafunc=VALUE);
  void SetSpectraVar(SpectraVar spectravar=NU);
  void SetSpectraUnit(SpectraUnit spectraunit=ANGSFLUX);
  void SetSpectraPower(SpectraPower spectrapower=POWER);


  virtual double operator() (double x);

  double F2L(double nu_or_lambda);
  double PlanckEnergie(void);
  double PlanckPhoton(void);
  double WienLaw(void);
  double FindMaximum(double eps=0.001);

protected:
  double T_;
  SpectraApprox spectraapprox_;
  SpectraFunc spectrafunc_;
  SpectraVar spectravar_;
  SpectraUnit spectraunit_;
  SpectraPower spectrapower_;

  double PlanckExp(double fl);
  double DPlanckExp_DT(double fl);

};

} // Fin du namespace SOPHYA

#endif
