#include "sopnamsp.h"
#include "piacmd.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "graphexecut.h"

#include "strutilxx.h"

#include "pistdimgapp.h"
#include "nobjmgr.h"

#include "nomgadapter.h"
#include "piyfxdrw.h"
#include "pibargraph.h"
#include "pitxtdrw.h"



/* --Methode-- */
PIAGraphicExecutor::PIAGraphicExecutor(PIACmd* piac, NamedObjMgr* omg, PIStdImgApp* app)
{
mpiac = piac;
mObjMgr = omg; 
mImgApp = app;
RegisterCommands();
}

PIAGraphicExecutor::~PIAGraphicExecutor()
{
}


/* Macro pour tester si flag normalized coordinate est present */
#define _CkBoolNC_(_jk_) ((tokens.size()>_jk_) && (tokens[_jk_] == "true")) ? true : false;


/* --Methode-- */
int PIAGraphicExecutor::Execute(string& kw, vector<string>& tokens, string& toks)
{
// >>>>>>>>>>> Fenetre graphique , changement d'attributs graphiques 
if (kw == "zone") {
  while (tokens.size() < 2) tokens.push_back("1");
  int nx, ny;
  nx = ny = 1;
  nx = atoi(tokens[0].c_str());    ny = atoi(tokens[1].c_str());
  if (mImgApp) { 
    mImgApp->LockMutex();  // <ZThread> global event loop synchronisation 
    mImgApp->SetZone(nx, ny);
    mImgApp->UnlockMutex(true);  // <ZThread> global event loop synchronisation 
  }
}  
else if (kw == "newwin") {
  int nx=1, ny=1;
  int sx=0, sy=0;
  //if(tokens.size() < 2) { cout << "Usage: newwin nx ny" << endl;  return(0); }
  if(tokens.size() > 0) nx = atoi(tokens[0].c_str());
  if(tokens.size() > 1) ny = atoi(tokens[1].c_str());
  if(tokens.size() > 3) { 
    sx = atoi(tokens[2].c_str());
    sy = atoi(tokens[3].c_str());
  }
  if (mImgApp) { 
    mImgApp->LockMutex();   // <ZThread> global event loop synchronisation 
    mImgApp->CreateGraphWin(nx, ny, sx, sy);
    mImgApp->UnlockMutex(true); // <ZThread> global event loop synchronisation 
  }
}  
else if (kw == "stacknext") { 
  mImgApp->LockMutex();  // <ZThread> global event loop synchronisation 
  mImgApp->StackWinNext(); 
  mImgApp->UnlockMutex(true);  // <ZThread> global event loop synchronisation 
}
else if (kw == "graphicatt") {
  if (tokens.size() < 1) { cout << "Usage: graphicatt attributes_list (att=def->defaut)" << endl;  return(0); }
  string opts = tokens[0];
  if (tokens.size() > 1) 
    for(unsigned int kt=1; kt<tokens.size(); kt++)  { opts += ' '; opts += tokens[kt]; }
  if (mImgApp) mImgApp->SetDefaultGraphicAttributes(opts);
  }
else if (kw == "setaxesatt") {
  if (tokens.size() < 1) { cout << "Usage: setaxesatt attributes_list " << endl;  return(0); }
  string opts = tokens[0];
  if (tokens.size() > 1) 
    for(unsigned int kt=1; kt<tokens.size(); kt++)  { opts += ' '; opts += tokens[kt]; }
  if (mImgApp) mImgApp->SetDefaultAxesAttributes(opts);
  }
else if (kw == "setinsetlimits") {
  if (tokens.size() < 4) { cout << "Usage: setinsetlimits xmin xmax ymin ymax" << endl;  return(0); }
  double xmin = atof(tokens[0].c_str());
  double xmax = atof(tokens[1].c_str());
  double ymin = atof(tokens[2].c_str());
  double ymax = atof(tokens[3].c_str());
  mImgApp->SetInsetLimits(xmin, xmax, ymin, ymax);
  }
else if (kw == "drpanel") {
  if (tokens.size() < 4) { 
    cout << "Usage: drpanel xmin xmax ymin ymax [gratt] [name]" << endl;  
    return(0); 
  }
  double xmin = atof(tokens[0].c_str());
  double xmax = atof(tokens[1].c_str());
  double ymin = atof(tokens[2].c_str());
  double ymax = atof(tokens[3].c_str());
  char buff[128];
  sprintf(buff, "axesnone xylimits=%g,%g,%g,%g ", xmin, xmax, ymin, ymax);
  string sop = buff;
  if (tokens.size() > 4) sop += tokens[4];
  string name;
  if (tokens.size() > 5) name = tokens[5];
  PIFuncDrawer* gdr = new PIFuncDrawer(NULL);
  mImgApp->DispScDrawer(gdr, name, sop); 
}
//---- Ajout d'elements graphiques
else if (kw == "addtext") {
  if (tokens.size() < 3) { 
    cout << "Usage: addtext x y txt [colfontatt] [fgnc]" << endl;  
    return(0); 
  }
  double xp = atof(tokens[0].c_str());
  double yp = atof(tokens[1].c_str());
  string txt = tokens[2];
  string sop;
  if (tokens.size() > 3) sop = tokens[3];
  bool fgnc = _CkBoolNC_(4);  
  mImgApp->AddText(txt, xp, yp, sop, fgnc);
  }
else if (kw == "addctext") {
  if (tokens.size() < 5) { 
    cout << "Usage: addctext x y txt s_up s_dn [colfontatt] [updnfatt] [fgnc] " << endl;  
    return(0); 
  }
  double xp = atof(tokens[0].c_str());
  double yp = atof(tokens[1].c_str());
  string sop;
  if (tokens.size() > 5) sop = tokens[5];
  string sopfss;
  if (tokens.size() > 6) sopfss = tokens[6];
  bool fgnc = _CkBoolNC_(7);  
  mImgApp->AddCompText(tokens[2], tokens[3], tokens[4], xp, yp, sop, sopfss, fgnc);
  }
else if ((kw == "addline") || (kw == "addrect") || (kw == "addfrect") ||
         (kw == "addoval") || (kw == "addfoval") || 
	 (kw == "addarrow") ) {
  if (tokens.size() < 4) { 
    if ( (kw == "addoval") || (kw == "addfoval") )
      cout << "Usage  addoval/addfoval/addarrow xc yc dx dy [colatt] [fgnc]" << endl;  
    else 
      cout << "Usage: addline/addrect/addfrect/addarrow x1 y1 x2 y2 [colatt] [fgnc]" << endl;  
    return(0); 
  }
  double xp1 = atof(tokens[0].c_str());
  double yp1 = atof(tokens[1].c_str());
  double xp2 = atof(tokens[2].c_str());
  double yp2 = atof(tokens[3].c_str());
  string sop;
  if (tokens.size() > 4) sop = tokens[4];
  bool fgnc = _CkBoolNC_(5);  
  if (kw == "addline") mImgApp->AddLine(xp1, yp1, xp2, yp2, sop, false, fgnc);
  else if (kw == "addarrow") mImgApp->AddLine(xp1, yp1, xp2, yp2, sop, true, fgnc);
  else { 
    bool fgfill = ((kw == "addrect") || (kw == "addoval")) ? false : true;
    if ( (kw == "addrect") || (kw == "addfrect") )
      mImgApp->AddRectangle(xp1, yp1, xp2, yp2, sop, fgfill, fgnc);
    else  mImgApp->AddOval(xp1, yp1, xp2, yp2, sop, fgfill, fgnc);
  }
}
else if ((kw == "addcirc") || (kw == "addfcirc")) {
  if (tokens.size() < 3) { 
    cout << "Usage: addcirc/addfcirc xc yc r [colatt] [fgnc]" << endl;  
    return(0); 
  }
  double xc = atof(tokens[0].c_str());
  double yc = atof(tokens[1].c_str());
  double rad = atof(tokens[2].c_str());
  string sop;
  if (tokens.size() > 3) sop = tokens[3];
  bool fgnc = _CkBoolNC_(4);  
  bool fgfill = (kw == "addcirc") ? false : true;
  mImgApp->AddCircle(xc, yc, rad, sop, fgfill, fgnc);
  }
else if ((kw == "addarca") || (kw == "addfarca")) {
  if (tokens.size() < 5) { 
    cout << "Usage: addarca/addfarca xc yc r a da [colatt] [fgnc]" << endl;  
    return(0); 
  }
  double xc = atof(tokens[0].c_str());
  double yc = atof(tokens[1].c_str());
  double rad = atof(tokens[2].c_str());
  double ang = atof(tokens[3].c_str());
  double dang = atof(tokens[4].c_str());
  string sop;
  if (tokens.size() > 5) sop = tokens[5];
  bool fgnc = _CkBoolNC_(6);  
  bool fgfill = (kw == "addarca") ? false : true;
  mImgApp->AddArc(xc, yc, rad, ang, dang, sop, fgfill, fgnc);
  }
else if (kw == "addmarker") {
  if (tokens.size() < 2) { 
    cout << "Usage: addmarker x y [gratt] [fgnc]" << endl;  
    return(0); 
  }
  double xm = atof(tokens[0].c_str());
  double ym = atof(tokens[1].c_str());
  string sop;
  if (tokens.size() > 2) sop = tokens[2];
  bool fgnc = _CkBoolNC_(3);  
  mImgApp->AddCircle(xm, ym, -1, sop, false, fgnc);
}
else if ((kw == "addarc") || (kw == "addfarc") ) {
  if (tokens.size() < 6) { 
    cout << "Usage: addarc/addfarc x1 y1 x2 y2 x3 y3 [gratt] [fgnc]" << endl;  
    return(0); 
  }
  double x1 = atof(tokens[0].c_str());
  double y1 = atof(tokens[1].c_str());
  double x2 = atof(tokens[2].c_str());
  double y2 = atof(tokens[3].c_str());
  double x3 = atof(tokens[4].c_str());
  double y3 = atof(tokens[5].c_str());
  string sop;
  if (tokens.size() > 6) sop = tokens[6];
  bool fgnc = _CkBoolNC_(7);  
  bool fgfill = (kw == "addarc") ? false : true;
  mImgApp->AddArc(x1, y1, x2, y2, x3, y3, sop, fgfill, fgnc);
}
else if ((kw == "addpoly") || (kw == "addfpoly")) {
  if (tokens.size() < 1) { 
    cout << "Usage: addpoly/addfpoly 'x1,y1 x2,y2 x3,y3 ...' [gratt] [fgnc]" << endl;  
    return(0); 
  }
  vector<string> sxy;
  vector<double> xpol, ypol;
  double xp, yp;
  FillVStringFrString(tokens[0], sxy);
  for(int jkk=0; jkk<sxy.size(); jkk++) {
    xp = yp = 0;
    if (sscanf(sxy[jkk].c_str(), "%lg,%lg", &xp, &yp) == 2) { 
      xpol.push_back(xp); 
      ypol.push_back(yp);
    }
  }
  string sop;
  if (tokens.size() > 1) sop = tokens[1];
  bool fgnc = _CkBoolNC_(2);  
  bool fgfill = (kw == "addpoly") ? false : true;
  mImgApp->AddPoly(xpol, ypol, sop, fgfill, fgnc);
  }


else if ((kw == "settitle") || (kw == "addtitle")) {
  if (tokens.size() < 1) { cout << "Usage: settitle/addtitle TopTitle [BotTitle] [fontatt]" << endl;  return(0); }
  if(tokens.size()<2) tokens.push_back("");
  string gropt;
  if(tokens.size()>2) gropt = tokens[2];
  mImgApp->SetTitle(tokens[0], tokens[1], gropt);
}

else if ((kw == "setaxelabels") || (kw == "addaxelabels")) {
  if (tokens.size() < 2) { cout << "Usage: setaxelabels/addaxelabels xLabel yLabel [fontatt]" << endl;  return(0); }
  string gropt;
  if(tokens.size()>2) gropt = tokens[2];
  mImgApp->SetAxeLabels(tokens[0], tokens[1], gropt);
}
  
// >>>>>>>>>>>  Affichage des objets 
else if ( (kw == "disp") || (kw == "surf") || (kw == "imag") || (kw == "imagnav") ) {
  if (tokens.size() < 1) { cout << "Usage: disp/surf/imag/imagnav nameobj [opt]" << endl; return(0); }
  string opt = "next";
  if (tokens.size() > 1)  opt = tokens[1];
  if (kw == "disp") mObjMgr->DisplayObj(tokens[0], opt);
  else if (kw == "surf")  mObjMgr->DisplaySurf3D(tokens[0], opt);
  else if (kw == "imag")  mObjMgr->DisplayImage(tokens[0], opt, false);
  else if (kw == "imagnav")  mObjMgr->DisplayImage(tokens[0], opt, true);
  }

else if (kw == "nt2d") {
  if (tokens.size() < 3) { 
    cout << "Usage: nt2d nameobj varx vary [errx erry wt label opt]" << endl; 
    return(0); 
  }
  while (tokens.size() < 8) tokens.push_back("");
  string ph = "";
  mObjMgr->DisplayNT(tokens[0], tokens[1], tokens[2], ph, tokens[3], tokens[4], ph, 
                     tokens[5], tokens[6], ph, false, tokens[7], false);
  }
else if ((kw == "nt2dcn")||(kw == "nt2dci")) {
  if (tokens.size() < 4) { 
    cout << "Usage: nt2dcn nameobj color varx vary [errx erry wt label opt]" << endl; 
    return(0); 
  }
  while (tokens.size() < 9) tokens.push_back("");
  string ph = "";
  bool colidx = false;
  if (kw == "nt2dci")  colidx = true;
  mObjMgr->DisplayNT(tokens[0], tokens[2], tokens[3], ph, tokens[4], tokens[5], ph, 
                     tokens[6], tokens[7], tokens[1], colidx, tokens[8], false);
  }
else if (kw == "nt3d") {
  if (tokens.size() < 7) { 
    cout << "Usage: nt3d nameobj varx vary varz [errx erry errz wt label opt]" << endl; 
    return(0); 
  }
  while (tokens.size() < 10) tokens.push_back("");
  string ph = "";
  mObjMgr->DisplayNT(tokens[0], tokens[1], tokens[2], tokens[3], tokens[4], tokens[5],
                     tokens[6], tokens[7], tokens[8], ph, false, tokens[9], true);
  }
else if (kw == "vecplot") {
  if (tokens.size() < 2) { 
    cout << "Usage: vecplot nameVecX nameVecY [opt]" << endl;
    return(0); 
  }
  while (tokens.size() < 3) tokens.push_back("");
  mObjMgr->DisplayVector(tokens[0], tokens[1], tokens[2]);
}
else if (kw == "bargraph") return BarGraph(kw, tokens);
else if (kw == "textdrawer") return TextDrawer(kw, tokens);

// Obsolete : ne pas virer SVP, cmv 26/7/99
else if (kw == "gfd2d") {
  cout<<"----- gfd2d OBSOLETE: utilisez nt2d -----"<<endl;
  if(tokens.size()<2)
    {cout<<"Usage: gfd2d nomobj numvarx erreur=(x y xy) opt"<<endl;
     return(0);}
  string numvary = "";
  string err = "";
  string opt = "next";
  if(tokens.size()>2) err = tokens[2];
  if(tokens.size()>3) opt = tokens[3];
  mObjMgr->DisplayGFD(tokens[0],tokens[1],numvary,err,opt);
  }
else if (kw == "gfd3d") {
  cout<<"----- gfd3d OBSOLETE: utilisez nt3d -----"<<endl;
  if(tokens.size()<3)
    {cout<<"Usage: gfd3d nameobj numvarx numvary erreur=(x y z xy xz yz xyz) opt"<<endl;
     return(0);}
  string err = "";
  string opt = "next";
  if(tokens.size()>3) err = tokens[3];
  if(tokens.size()>4) opt = tokens[4];
  mObjMgr->DisplayGFD(tokens[0],tokens[1],tokens[2],err,opt);
  }


else  { 
  cerr << "PIAGraphicExecutor::Do() Erreur - Commande " << kw << " inconuue ! " << endl;    
  return(-1);
  }

return(0);
}

/* --Methode-- */
bool PIAGraphicExecutor::IsThreadable(string const & keyw)
{
  return false;	
}


/* --Methode-- */
void PIAGraphicExecutor::RegisterCommands()
{
string kw, usage, grp;

RegisterPIGraphicsHelp(mpiac);

grp = "Graphics";
string gdesc = "Basic graphics and object display commands";
mpiac->AddHelpGroup(grp, gdesc);
kw = "zone";
usage = "To Divide the Graphic window \n  Usage: zone [nx=1 ny=1]";
usage += "\n  Related commands: newwin";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "newwin";
usage = "To Create a New Graphic window, with zones \n";
usage += "  Window size can be specified \n";
usage += "    Usage: newwin [nx ny [sizeX sizeY]] ";
usage += "\n  Related commands: zone";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "stacknext";
usage = "Displays the next widget on stack window \n  Usage: stacknext";
mpiac->RegisterCommand(kw, usage, this, grp);

kw = "graphicatt";
usage = "To change default graphic options\n  Usage: graphicatt att_list\n";
usage += "att_list=def back to default values, Example: gratt 'red circlemarker5'";
usage += "\n ------------------ Graphic attribute list ------------------\n";
usage += ">> Colors: defcol black white grey red blue green yellow\n";
usage += "           magenta cyan turquoise navyblue orange siennared purple\n";
usage += "           limegreen gold violet violetred blueviolet darkviolet\n";
usage += "   or \"color=name\" \"fgcolor=name\" \"bgcolor=name\" ex: \"color=red\"\n";
usage += ">> Lines: defline normalline thinline thickline dashedline thindashedline\n";
usage += "          thickdashedline dottedline thindottedline thickdottedline\n";
usage += "   or \"line=type,width\"   ex: \"line=dotted,7\"\n";
usage += ">> Fonts:\n";
usage += "   > Att: deffontatt normalfont boldfont italicfont bolditalicfont \n";
usage += "           smallfont smallboldfont smallitalicfont smallbolditalicfont\n";
usage += "           bigfont bigboldfont bigitalicfont bigbolditalicfont\n";
usage += "           hugefont  hugeboldfont hugeitalicfont hugebolditalicfont\n";
usage += "   > Names: deffont courierfont helveticafont timesfont symbolfont \n";
usage += "   or \"font=name,type,size\"   ex: \"font=courrier,bolditalic,10\"\n";
usage += ">> Marker: dotmarker<T>  plusmarker<T>  crossmarker<T> circlemarker<T>\n";
usage += "           fcirclemarker<T> boxmarker<T> fboxmarker<T> trianglemarker<T>\n";
usage += "           ftrianglemarker<T>  starmarker<T>  fstarmarker<T>\n";
usage += "       with <T> = 1 3 5 7 .. 15 , Example fboxmarker5 , plusmarker9 ...\n";
usage += "   or \"marker=type,size\"   ex: \"marker=plus,10\"\n";
usage += ">> ArrowMarker: basicarrow<T>  trianglearrow<T>  ftrianglearrow<T>\n";
usage += "                arrowshapedarrow<T> farrowshapedarrow<T>\n";
usage += "       with <T> = 5 7 .. 15 , Example trianglearrow7 ...\n";
usage += "   or \"arrow=type,size\"   ex: \"arrow=arrowshaped,10\"\n";
usage += "------ Specific options for image displays:\n";
usage += ">> ColorTables: defcmap  grey32  invgrey32  colrj32  colbr32\n";
usage += "                grey128  invgrey128  colrj128  colbr128\n";
usage += "                red32cm  green32cm  blue32cm  yellow32cm\n";
usage += "                orange32cm cyan32cm violet32cm\n";
usage += "                midas_pastel midas_heat midas_rainbow3 midas_bluered\n";
usage += "                midas_bluewhite midas_redwhite\n";
usage += "                multicol16 multicol64\n";
usage += ">> revcmap : reverse colorMap\n";
usage += ">> ZoomFactors :  zoomxN   ex: zoomx1 zoomx2 zoomx3 ...\n";
usage += "                  zoom/N   ex: zoom/2 zoom/3 zoom/4 ...\n";
usage += ">> imagecenter=ix,iy : Position the image in widget\n";
usage += ">> lut=ltyp,min,max : Sets LUT type and min/max\n";
usage += "                   (ltyp=lin/log/sqrt/square)\n";
usage += ">> autolut=alt[,ns[,min,max]] : AutoLut method selection \n";
usage += "                   (alt=minmax/meansig/hispeak/histail)\n";
usage += ">> invx,invy,exchxy : image axes configuration\n";
usage += "--- General purpose options:\n";
usage += ">> stat,stats / nsta,nstat,nostat,nostats : Toggle statistic display\n";
usage += ">> title,tit / notitle,notit -> Toggle automatic title display\n";
usage += ">> Choose display window: next same win stack inset\n";
usage += ">> for Axes / Axe labels / LogScale / xylimits / defdrrect\n";
usage += "       see setaxesatt command\n";
usage += "\n";  
usage += "   Related commands: setaxesatt setinsetlimits ";  
mpiac->RegisterCommand(kw, usage, this, grp);

kw = "setaxesatt";
usage = "To set default axes attributes \n  Usage: setaxesatt att_list \n";
usage += "Color/Line/Font attributes and axes attributes \n";
usage += ">> Axes: axesnone stdaxes=defaxes=boxaxes boxaxesgrid \n";
usage += "         fineaxes fineaxesgrid centeredaxes finecenteredaxes \n"; 
usage += "         centeredaxesgrid finecenteredaxesgrid\n"; 
usage += "         axescenter=x0,y0 (only with centered axes, default \"axescenter=\")\n"; 
usage += "         grid nogrid labels nolabels  \n"; 
usage += "         ticks noticks minorticks nominorticks \n"; 
usage += "         extticks intticks extintticks \n"; 
usage += "         nbticks=X_NTicks,Y_NTicks  \n"; 
usage += "         tickslen=MajTickLenFrac,MinTickLenFrac \n"; 
usage += ">> Axe labels font size: fixedfontsize/autofontsize=fszf \n";
usage += "         autofontsize=fsizef: Font size computed automatically \n";
usage += "         fixedfontsize: Use font size attribute (BaseDrawer) \n";
usage += ">> Scale type: linx liny logx logy -> Lin/Log Scales for 2D plots \n";
usage += ">> xylimits=xmin,xmax,ymin,ymax  -> Forces X-Y limits in 2-D plots \n";
usage += ">> defdrrect=xmin,xmax,ymin,ymax -> Defines drawing rectangle 2-D plots \n";
usage += "          The rectangle is defined as a fraction of the widget size\n";
mpiac->RegisterCommand(kw, usage, this, grp);

kw = "setinsetlimits";
usage = "Define the display rectangle for drawers added as insets \n";
usage += " over existing graphic objects - limits expressed as fraction \n";  
usage += " graphic object size (0. .. 1.) Xmax at right, YMax top \n ";
usage += " Usage: setinsetlimits xmin xmax ymin ymax";
usage += "\n  Related commands: graphicatt /inset";  
mpiac->RegisterCommand(kw, usage, this, grp);

kw = "drpanel";
usage = "Creates a new 2D drawing zone for addtext, addline \n";
usage += " Usage: drpanel xmin xmax ymin ymax [GrAtt] [Name]";
usage += "\n  Related commands: addtext addline addrect addcirc ...";  
mpiac->RegisterCommand(kw, usage, this, grp);

kw = "addtext";
usage = "Adds a text string to the current graphic object";
usage += "\n at the specified position (+ color/font/pos/dir attributes) ";
usage += "\n The Base/AxesDrawer is used to handle added text strings" ;
usage += "\n Alt<E> to remove the added element";
usage += "\n  Usage: addtext x y TextString [ColFontPosAtt] [fgnc=false/true]";
usage += "\n  (use quotes '' for multi word text strings) ";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n Text position/direction attribute: "; 
usage += "\n      horizleft horizcenter horizright";
usage += "\n      vertbottom vertcenter verttop ";
usage += "\n      textdirhoriz textdirvertup textdirvertdown ";
usage += "\n  Related commands: addctext addline addarrow addrect addfrect";
usage += "\n      addcirc addfcirc addarc addfrac addpoly addfpoly settitle graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addctext";
usage = "Adds a composite text string with superscript and subscripts ";
usage += "\n at the specified position (+ color/font/pos/dir attributes) ";
usage += "\n  Usage: addctext x y Text sUp sDown [ColFontPosAtt] [UpDownFontAtt] [fgnc]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addrect ...";
usage += "\n      (See command addtext and graphicatt for more details)";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addline";
usage = "Adds a line to the current graphic object";
usage += "\n at the specified position (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added lines"; 
usage += "\n Alt<E> to remove the added element";
usage += "\n  Usage: addline x1 y1 x2 y2 [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addarrow addtext addrect addfrect ";
usage += "\n       addmarker addcirc addfcirc addarc addfarc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addarrow";
usage = "Adds an arrow to the current graphic object";
usage += "\n at the specified position (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added lines"; 
usage += "\n Alt<E> to remove the added element";
usage += "\n  Usage: addarrow x1 y1 x2 y2 [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addline addtext addrect addfrect ";
usage += "\n       addmarker addcirc addfcirc addarc addfarc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");
kw = "addarrow_nc";

kw = "addrect";
usage = "Adds a rectangle to the current graphic object";
usage += "\n between the specified positions (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added rectangle"; 
usage += "\n Alt<E> to remove added element";
usage += "\n  Usage: addrect x1 y1 x2 y2 [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarrow addfrect";
usage += "\n       addcirc addfcirc addarc addfarc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addfrect";
usage = "Adds a filled rectangle to the current graphic object";
usage += "\n between the specified positions (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added rectangle"; 
usage += "\n Alt<E> to remove added element";
usage += "\n  Usage: addfrect x1 y1 x2 y2 [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarrow addrect";
usage += "\n       addcirc addfcirc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addmarker";
usage = "Adds a marker to the current graphic object";
usage += "\n at the specified position (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added circles"; 
usage += "\n Alt<E> to remove added element";
usage += "\n  Usage: addmarker xpos ypos [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarrow addfrect addfrect";
usage += "\n       addcirc addfcirc addarc addfarc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addcirc";
usage = "Adds a circle to the current graphic object";
usage += "\n with the specified center and radius (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added circles"; 
usage += "\n Alt<E> to remove added element";
usage += "\n  Usage: addcirc xcenter ycenter radius [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarrow addfrect addfrect";
usage += "\n       addfcirc addarc addfarc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addfcirc";
usage = "Adds a filled circle to the current graphic object";
usage += "\n with the specified center and radius (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added circles"; 
usage += "\n Alt<E> to remove added element";
usage += "\n  Usage: addcirc xcenter ycenter radius [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarrow addfrect addfrect";
usage += "\n       addcirc addarc addfarc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addoval";
usage = "Adds an oval (ellipse) to the current graphic object";
usage += "\n centered on xc,yc - semi-axis ds,dy (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added rectangle"; 
usage += "\n Alt<E> to remove added element";
usage += "\n  Usage: addoval xc yc dx dy [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addfoval addline addarrow addfrect addcirc addfcirc";
usage += "\n       addcirc addfcirc addarc addfarc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addfoval";
usage = "Adds a filled oval (ellipse) to the current graphic object";
usage += "\n centered on xc,yc - semi-axis ds,dy (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added rectangle"; 
usage += "\n Alt<E> to remove added element";
usage += "\n  Usage: addfoval xc yc dx dy [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addoval addline addarrow addfrect addcirc addfcirc";
usage += "\n       addcirc addfcirc addarc addfarc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addarca";
usage = "Adds an arc to the current graphic object";
usage += "\n defined by the circle (center+radius), start angle and angular extension";
usage += "\n Angles are specified in degrees";
usage += "\n  Usage: addarca xc yc r a0deg dadeg [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addfarca addarc ...";
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addfarca";
usage = "Adds a filled arc to the current graphic object";
usage += "\n defined by the circle (center+radius), start angle and angular extension";
usage += "\n Angles are specified in degrees";
usage += "\n  Usage: addfarca xc yc r a0deg dadeg [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarca addarc ...";
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addarc";
usage = "Adds an arc to the current graphic object";
usage += "\n defined by 3 points (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added arcs"; 
usage += "\n Alt<E> to remove the added element";
usage += "\n  Usage: addarc x1 y1 x2 y2 x3 y3 [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarrow addfrect addfrect";
usage += "\n       addcirc addfcirc addfarc addarca addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addfarc";
usage = "Adds a filled arc to the current graphic object";
usage += "\n defined by 3 points (+ graphic attribute)";
usage += "\n The Base/AxesDrawer is used to handle added arcs"; 
usage += "\n Alt<E> to remove added element";
usage += "\n  Usage: addarc x1 y1 x2 y2 x3 y3 [GraphicAtt] [fgnc=false/true]";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarrow addfrect addfrect";
usage += "\n       addcirc addfcirc addfarc addpoly addfpoly graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addpoly";
usage = "Adds a polyline/polygon to the current graphic object";
usage += "\n  Usage: addploy 'x1,y1 x2,y2 x3,y3 ...' [GraphicAtt] [fgnc=false/true]";
usage += "\n  Coordinates specified as pairs x,y in a single word (use simple or double quotes";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarrow addfrect addfrect";
usage += "\n       addcirc addfcirc addfarc  graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "addfpoly";
usage = "Adds a filled polygon to the current graphic object";
usage += "\n  Usage: addploy 'x1,y1 x2,y2 x3,y3 ...' [GraphicAtt] [fgnc=false/true]";
usage += "\n  Coordinates specified as pairs x,y in a single word (use simple or double quotes";
usage += "\n  if fgnc==true : Normalized 0..1 coordinates specification (def=false)";
usage += "\n  Related commands: addtext addline addarrow addfrect addfrect";
usage += "\n       addcirc addfcirc addfarc  graphicatt";  
mpiac->RegisterCommand(kw, usage, this, "Graphic-Elts");

kw = "settitle";
usage = "Set the title string (top title / bottom title) for the current graphic object";
usage += "\n  Usage: settitle TopTitle [BottomTitle] [fontAtt]";
usage += "\n  Related commands: addtext graphicatt";  
mpiac->RegisterCommand(kw, usage, this, grp);

kw = "addtitle";
usage = "Set the title string (top title / bottom title) \n";
usage += "   alias for settitle ";
mpiac->RegisterCommand(kw, usage, this, grp);

kw = "setaxelabels";
usage = "Set the X and Y axis labels for the current 2D graphic object \n";
usage += "\n  Usage: setaxelabels xLabel yLabel [ColorFntAtt]";
usage += "\n  Related commands: settitle addtext graphicatt";  
mpiac->RegisterCommand(kw, usage, this, grp);

kw = "addaxelabels";
usage = "Set the X and Y axis labels for the current 2D graphic object";
usage += "   alias for setaxelabels ";
mpiac->RegisterCommand(kw, usage, this, grp);

grp = "Obj. Display";
kw = "disp";
usage = "Displays an object \n Usage: disp nameobj [graphic_attributes]";
usage += "\n  Related commands: surf nt2d nt3d vecplot";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "imag";
usage = "Displays an object as an image \n Usage: imag nameobj [graphic_attributes]";
usage += "\n  Related commands: disp imagnav surf nt2d nt3d vecplot";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "imagnav";
usage = "Displays an object as an image with the ImageNavigator viewer \n";
usage += "Usage: imagnav nameobj [graphic_attributes]";
usage += "\n  Related commands: disp imag surf nt2d nt3d vecplot";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "surf";
usage = "Displays an object as a 3D surface \n Usage: surf nameobj [graphic_attributes]";
usage += "\n  Related commands: disp nt2d nt3d vecplot";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "nt2d";
usage = "Displays Points (X-Y) [with error-bar / Weight / Label ] from an NTuple ";
usage += "\n Usage : nt2d nameobj varx vary [errx erry wt label graphic_attributes]";
usage += "\n  Related commands: disp surf nt2dcn nt2dci nt3d  gfd2d vecplot";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "nt2dcn";
usage = "Displays Points (X-Y) [with error-bar / Weight / Label ] from an NTuple ";
usage = "   with colors specified by a column content (as color names) ";
usage += "\n Usage : nt2dcn nameobj color varx vary [errx erry wt label graphic_attributes]";
usage += "\n  Related commands: disp  surf  nt2d nt2dci nt3d  gfd2d vecplot";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "nt2dci";
usage = "Displays Points (X-Y) [with error-bar / Weight / Label ] from an NTuple ";
usage = "   with colors specified by a column content (as color index) ";
usage += "\n Usage : nt2dci nameobj color varx vary [errx erry wt label graphic_attributes]";
usage += "\n  Related commands: disp  surf  nt2d nt2dci nt3d  gfd2d vecplot";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "nt3d";
usage = "Displays 3D-Points (X-Y-Z) [with error-bars / Weight / Label ] from an NTuple ";
usage += "\n Usage : nt3d nameobj varx vary varz [errx erry errz wt label graphic_attributes]";
usage += "\n  Related commands: disp  surf  nt2d gfd3d ";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "vecplot";
usage = "Displays Points (X-Y) with coordinates defined by two vectors ";
usage += "\n Usage : vecplot nameVecX nameVecY [graphic_attributes]";
usage += "\n  Related commands: disp nt2d ";  
mpiac->RegisterCommand(kw, usage, this, grp);

kw = "bargraph";
usage = "Bar-Graph view of a sequence of values ";
usage += "\n Usage: bargraph ValueVarName [gr_opt]  ";
usage += "\n    or  bargraph ValueVarName LabelVarName ColPosVarName [gr_opt] ";
usage += "\n  ValueVarName,LabelVarName,ColPosVarName are PIACmd interpreter "; 
usage += "\n     variable name (vectors) ";
usage += "\n - ValueVarName: Sequence of values to be represented";
usage += "\n - LabelVarName: Corresponding labels";
usage += "\n - ColPosVarName: Corresponding colors or color,position pairs ";
usage += "\n Use a dash (-) or ! as placeholder for LabelVarName/ColPosVarName";
usage += "\n Specific graphic options: fill/nofill packfrac=value ";
usage += "\n    horizontalbars/verticalbars  barvaluelabel/nobarvaluelabel";
usage += "\n Related commands: disp nt2d vecplot ...";  
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "textdrawer";
usage = "Multi line text darwer ";
usage += "\n Usage : textdrawer LinesVarName AttVarName [gr_opt] ";
usage += "\n  LinesVarName,AttVarName are PIACmd interpreter variables"; 
usage += "\n - LinesVarName: Lines to be displayed";
usage += "\n - AttVarName: Corresponding font/marker/color attributes";
usage += "\n Use a dash (-) or ! as placeholder for AttVarName";
usage += "\n Specific graphic options: frame/noframe";
usage += "\n Related commands: disp ... ";  
mpiac->RegisterCommand(kw, usage, this, grp);


// Ceci est maintenant obsolete, on garde pour info.
kw = "gfd2d";
usage = "Displays Points (X-Y) with error-bars from a GeneralFit Data ";
usage += "\n Usage : gfd2d nameobj numvarx erreur=(x y xy) [graphic_attributes]";
usage += "\n  Related commands: gfd3d nt2d nt3d ";
usage += "\n  ----- OBSOLETE: utilisez nt2d -----";
mpiac->RegisterCommand(kw, usage, this, grp);
kw = "gfd3d";
usage = "Displays 3D-Points (X-Y-Z) with error-bars from a GeneralFit Data ";
usage += "\n Usage : gfd3d nameobj numvarx numvary erreur=(x y z xy xz yz xyz) [graphic_attributes]";
usage += "\n  Related commands: gfd2d nt2d nt3d ";  
usage += "\n  ----- OBSOLETE: utilisez nt3d -----";
mpiac->RegisterCommand(kw, usage, this, grp);

}


/* --Methode-- */
void PIAGraphicExecutor::RegisterPIGraphicsHelp(PIACmd* piac)
// Methode pour enregistrer le Help des Widgets et Windows de piapp 
{
string kw,grp,usage;

grp = "Graphics";

kw = "PIImage";
usage = "Manages the display of a 2-D array (P2DArrayAdapter) as an image \n";
usage += "and controls a zoom widget, as well as a global image view widget \n";
usage += ">>>> Mouse controls : \n";
usage += "o Button-1: Display current coordinates and pixel value\n";
usage += "  Position the cursor an refresh the zoom widget\n";
usage += "o Button-2: Defines an image zone and positions the cursor \n";
usage += "o Button-3: Moves the viewed portion of the array inside the window \n";
usage += ">>>> Keyboard controls : \n";
usage += "o <Alt>R : Refresh display \n";
usage += "o <Alt>O : Shows the PIImageTools (image display parameter controls) \n";
usage += "o <Alt>G : Show the PIDrawerTools (Graphic attributes of overlayed graphics (Drawers)) \n";
usage += "o <Alt>D : Shows the drawer manipulation pop-up menu \n";
usage += "o <Alt>V : Copy/Paste / Text paste at the current cursor position \n";
usage += "o <Alt>C : Copy/Paste / Copies the selected regions content as text in the copy/paste buffer \n";
usage += "o <Alt>X : Show/Hide the Cut Window \n";
usage += "o <Alt>Z : Removes added graphic elements (handled by BaseDrawer - 0) \n";
usage += "o <Alt>E : Removes the last added graphic element \n";
usage += "o <Alt>+ or <Cntl>+ : Zoom in \n";
usage += "o <Alt>- or <Cntl>- : Zoom out \n";
usage += "o Cursor keys : Moves the image cursor \n";
piac->RegisterHelp(kw, usage, grp);

kw = "PIScDrawWdg";
usage = "Manages display of 2-D drawers with interactive zoom \n";
usage += ">>>> Mouse controls : \n";
usage += "o Button-1: Display current coordinates \n";
usage += "o Button-2: Defines a rectangle for zoom \n";
usage += "o Button-3: Defines a rectangle for Text-Info (<Alt>I) \n";
usage += ">>>> Keyboard controls : \n";
usage += "o <Alt>R : Refresh display \n";
usage += "o <Alt>O : Displays a specific control window (default: PIDrawerTools) \n";
usage += "           (2-D histograms, contour plot ...) \n";
usage += "o <Alt>G : Show the PIDrawerTools (Graphic attributes of displayed Drawers) \n";
usage += "           Drawer 0 manages the axes, as well as the added text \n";
usage += "o <Alt>D : Shows the drawer manipulation pop-up menu \n";
usage += "o <Alt>V : Copy/Paste / Text paste at the current position \n";
usage += "o <Alt>Z : Removes added graphic elements (handled by BaseDrawer - 0) \n";
usage += "o <Alt>E : Removes the last added graphic element \n";
usage += "o <Alt>I : Shows (or updates) a text info window on the selected rectangle \n";
usage += "o <Alt>M : Activate/Deactivate a measurement cursor on Button-1\n";
usage += "o <Alt>L : Deactivate DX,DY print (see below)\n";
usage += ">>>> Mouse + Keyboard controls : \n";
usage += "o Button-1 + <Alt>K : Set (reset) the reference point for DX,DY print \n";
piac->RegisterHelp(kw, usage, grp);

kw = "PIDraw3DWdg";
usage = "Manages display of 3-D objects (drawers)  \n";
usage += ">>>> Mouse controls : \n";
usage += "o Button-2: Rotates the observer (camera) around object \n";
usage += "o Shift-Button-2: Rotates object with camera fixed \n";
usage += "  The object rotation mode can be assigned to Button-2 with <Alt>S \n";
usage += "o Button-3: Zoom control (Camera distance And/Or view angle) \n";
usage += ">>>> Keyboard controls : \n";
usage += "o <Alt>R : Resets the 3-D view and refreshes the display \n";
usage += "o <Alt>O : Displays a specific control window (default: PIDrawerTools) \n";
usage += "           (2-D histograms, contour plot ...) \n";
usage += "o <Alt>G : Show the PIDrawerTools (Graphic attributes of displayed Drawers) \n";
usage += "           Drawer 0 manages the axes, as well as the added text \n";
usage += "o <Alt>D : Shows the drawer manipulation pop-up menu \n";
usage += "o <Alt>V : Copy/Paste / Text paste at the current position (Drawer 0)\n";
usage += "o <Alt>Z : Removes added graphic elements (handled by BaseDrawer - 0) \n";
usage += "o <Alt>E : Removes the last added graphic element \n";
usage += "o <Alt>A : Activate/Deactivate axes drawing \n";
usage += "o <Alt>S : Activate/Deactivate object rotation mode on Button-2 \n";
piac->RegisterHelp(kw, usage, grp);

kw = "Windows";
usage = "Objects can be displayed in different windows, or overlayed on the \n";
usage += "previous display. The graphics attributes next,win,stack,same control \n";
usage += "the display window. \n";
usage += "o GraphicWindow : This is the default mode (gr_att=next)\n";
usage += "  Graphic windows can be divided int zones. Object is displayed \n";
usage += "  in the next available position, removing a previously displayed \n";
usage += "  widget if necessary \n";
usage += "o Window : An object is displayed in its own window (gr_att= win) \n";
usage += "o StackWindow : multpile widgets can be stacked in a StackWindow (gr_att= stack) \n";
usage += "  A single widget is displayed a any time. Different widgets in a StackWindow \n";
usage += "  can be displayed using the stacknext command, as well as the StackTools item \n";
usage += "  in the Tools menu (from Menubar). An automatic cyclic display mode can also \n";
usage += "  be activated using the StackTools menu (Blink) \n";
usage += "o Most objects can be also be displayed overlayed \n";
usage += "  on the last displayed widget (gr_att= same) \n";
usage += "  or by specifying a widget name samew=Widgetname \n";
usage += "o The widget/window name can be specified (gr_att wname=Name) \n";
usage += "o The overlay can be on a selected rectangle of the last \n";  
usage += "  displayed widget (gr_att: inset  or inset=fxmin,fxmax,fymin,fymax) \n";
usage += "\n  Related commands: newwin zone stacknext graphicatt setinsetlimits";  
piac->RegisterHelp(kw, usage, grp);

kw = "PIConsole";
usage = "Text output area and command editing window (console) \n";
usage += ">>>> Mouse controls : \n";
usage += "o Button-1: Rectangle selection for copy/paste \n";
usage += "o Button-2: Paste text in the command editing line \n";
usage += "o Button-3: activate display option menu \n";
usage += ">>>> Keyboard controls : \n";
usage += "o <Alt>O : activate display option menu   \n";
usage += "o <Alt>V : Paste text in the command editing line \n";
usage += "o <Alt>A : Selection of the whole window for copy \n";
usage += "o <Alt>L : Command history (List of command history buffer) \n";
usage += "o <Ctl>A : Command editing -> Goto the beginning of line \n";
usage += "o <Ctl>E : Command editing -> Goto the end of line \n";
usage += "o <Ctl>K : Command editing -> Clear to the end of line \n";
usage += "o <Ctl>C : Command editing -> Clear the line \n";
usage += "o Cursor left,right : Command editing -> Move cursor \n";
usage += "o Cursor Up,Down : recall command from history buffer \n";
usage += "o Backspace,Del : Command editing \n";
usage += "o <Return>,<Enter> : Execute command \n";
piac->RegisterHelp(kw, usage, grp);
}

/* --Methode-- */
int PIAGraphicExecutor::BarGraph(string& keyw, vector<string>& tokens)
{
  //PAS necessaire pour le moment-- if (kw != "bargraph") return 2;
  if (tokens.size() < 1) { 
    cout << "Usage: bargraph ValueVarName [gr_opt]" << endl;
    cout << "   or  bargraph ValueVarName LabelVarName ColPosVarName [gr_opt]" << endl;
    return(0); 
  }
  PIBarGraph* bgd = NULL; 
  vector<string> barvals;
  string gropt;
  if (!mpiac->GetVar(tokens[0], barvals)) {
    cout << "bargraph/Error: No variable with name " << tokens[0] << endl;
    return(1);
  }
  if (tokens.size() < 3) {   
    bgd = new PIBarGraph;
    for(int k=0; k<barvals.size(); k++)
      bgd->AddBar(atof(barvals[k].c_str()));
    if (tokens.size() > 1)  gropt = tokens[1]; 
  }
  else {
    vector<string> barlabs;
    if (!mpiac->GetVar(tokens[1], barlabs)) {
      cout << "bargraph/Warning: No variable with name "  << tokens[1] 
           << " using Values as labels " << endl;
      barlabs = barvals;
    }
    vector<string> barcols;
    if (!mpiac->GetVar(tokens[2], barcols)) {
      cout << "bargraph/Warning: No variable with name "  << tokens[1] 
           << " using default attributes " << endl;
      for(int kad=0; kad<barvals.size(); kad++) barcols.push_back("");
    }
    if ( (barvals.size() != barlabs.size()) || 
	 (barvals.size() != barcols.size()) ) {
      cout << "bargraph/Error: Variables " << tokens[0] << "," << tokens[1]
	   << "," << tokens[2] << " have different sizes" << endl;
      return(1);      
    }
    bgd = new PIBarGraph;
    // Synchronisation necessaire a cause de PIGraphicAtt qui peuvent faire appel a des fontes (Pb Serveur X)
    mImgApp->LockMutex();   // <ZThread> global event loop synchronisation 
    for(int k=0; k<barvals.size(); k++) {
      double id = k+1;
      size_t p = barcols[k].find(',');
      vector<string> sgra;
      if (p < barcols[k].length()-1) {
	mImgApp->ParseDisplayOption(barcols[k].substr(0, p), sgra);
        id = atof(barcols[k].substr(p+1).c_str());
      }
      else  mImgApp->ParseDisplayOption(barcols[k], sgra);
      PIGraphicAtt gracol(sgra);
      bgd->AddBar(id, atof(barvals[k].c_str()), barlabs[k], gracol.GetColor());
    }
    mImgApp->UnlockMutex(true); // <ZThread> global event loop synchronisation 
    if (tokens.size() > 3)  gropt = tokens[3]; 
  }
  string grname = "BarGraph";
  mImgApp->DispScDrawer(bgd, grname, gropt); 
  return 0;
}

/* --Methode-- */
int PIAGraphicExecutor::TextDrawer(string& keyw, vector<string>& tokens)
{
  if (tokens.size() < 2) { 
    cout << "Usage: textdrawer TextLinesVarName AttVarName [gr_opt]" << endl;
    return(0); 
  }
  vector<string> txtlines;
  if (!mpiac->GetVar(tokens[0], txtlines)) {
    cout << "textdrawer/Error: No variable with name" << tokens[0] << endl;
    return(1);
  }
  vector<string> lineatt;
  if (!mpiac->GetVar(tokens[1], lineatt)) {
    cout << "textdrawer/Warning: No variable with name" << tokens[1] 
	 << " using default attributes " << endl;
    for(int kad=0; kad<txtlines.size(); kad++) lineatt.push_back("");    
  }
  if ( (txtlines.size() != lineatt.size()) ) { 
    cout << "textdrawer/Error: Variables " << tokens[0] << "," << tokens[1]
	 << " have different sizes" << endl;
    return(1);      
  }
  PITextDrawer* txd = new PITextDrawer;
  // Synchronisation necessaire a cause de PIGraphicAtt qui peuvent faire appel a des fontes (Pb Serveur X)
  mImgApp->LockMutex();   // <ZThread> global event loop synchronisation 
  for(int k=0; k<txtlines.size(); k++) {
    vector<string> sgra;
    mImgApp->ParseDisplayOption(lineatt[k], sgra);
    PIGraphicAtt gra(sgra);
    txd->AddLine(txtlines[k], gra);
  }
  mImgApp->UnlockMutex(true); // <ZThread> global event loop synchronisation 
  string grname = "TextDrawer";
  string gropt = "inset ";
  if (tokens.size() > 2)  gropt += tokens[2]; 
  mImgApp->DispScDrawer(txd, grname, gropt); 
  return 0;
}
