#include <stdio.h>
#include "pintuple.h"

 
/* --Methode-- */
PINTuple::PINTuple(NTupleInterface* nt, bool ad)
: PIDrawer()
{
  mNT = nt;
  mAdDO = ad; 
  SelectXY(NULL, NULL);
  SelectWt(NULL, 1);
  SelectErrBar();
}

PINTuple::~PINTuple()
{
  if (mAdDO && mNT)  delete mNT;
}

/* --Methode-- */
void  PINTuple::SelectXY(const char* px, const char* py)
{
string name;
if (mNT == NULL)  xK = yK = -1;
if (px == NULL) xK = -1;
else { name = px; xK = mNT->ColumnIndex(name); }
if (py == NULL) yK = -1;
else { name = py; yK = mNT->ColumnIndex(name); }
}

/* --Methode-- */
void  PINTuple::SelectWt(const char* pw, int nbins)
{
nWbins = (nbins > 0) ? nbins : 10;
if (pw == NULL) wK = -1;  
else { string name = pw;   wK = mNT->ColumnIndex(name);  }
 
if (wK >= 0) mNT->GetMinMax(wK, wMin, wMax);
else  { wMin = 0.; wMax = 1.; }
}

/* --Methode-- */
void  PINTuple::SelectErrBar(const char* erbx, const char* erby)
{
string name;
if (mNT == NULL)  xebK = yebK = -1;
if (erbx == NULL) xebK = -1;
else { name = erbx;  xebK = mNT->ColumnIndex(name); }
if (erby == NULL) yebK = -1;
else { name = erby;  yebK = mNT->ColumnIndex(name); }
}


/* --Methode-- */
void PINTuple::UpdateLimits()
{
  if (!mNT) return;
  if (mNT->NbLines() <= 0)  return;
  if ( (xK < 0) || (yK < 0) )   return;

  // Commencer par trouver nos limites
  double dx, dy;
  double xmin, xmax, ymin, ymax;
  xmin = ymin = 9.e19;
  xmax = ymax = -9.e19;
  mNT->GetMinMax(xK, xmin, xmax);
  mNT->GetMinMax(yK, ymin, ymax);
    
  dx = 0.02*(xmax-xmin);
  dy = 0.02*(ymax-ymin);
  
  SetLimits(xmin-dx, xmax+dx, ymin-dy, ymax+dy);
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


/* --Methode-- */
void PINTuple::Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax)
{
double xp,yp,xer,yer,wp;
double xl,yl;
int nok;

if (!mNT) return;
if ( (xK < 0) || (yK < 0) )  return;
if (mLAtt == PI_NotDefLineAtt)  g->SelLine(PI_ThinLine);

//  Pour tracer des markers avec taille fonction de Wt (poids)
double dw = (wMax-wMin)/nWbins;
if (dw < 1.e-19) dw = 1.e19;
int msz,sz;

PIMarker mrk;
if (wK >= 0)  mrk = (mMrk != PI_NotDefMarker) ? mMrk : PI_CircleMarker;
else   mrk = (mMrk != PI_NotDefMarker) ? mMrk : PI_DotMarker;
msz = mMSz;
if (msz < 1) msz = 1;
g->SelMarker(sz, mrk);

nok = 0;  
xp = yp = xl = yl = 0;
for (int i=0; i<mNT->NbLines(); i++) {
  xl = xp;  yl = yp; 
  xp = mNT->GetCell(i, xK);
  yp = mNT->GetCell(i, yK);
  if ( (xp < xmin) || (xp > xmax) || (yp < ymin) || (yp > ymax) )  continue;
  if ( (i > 0) && (mLAtt != PI_NotDefLineAtt) )   // On relie les points ...
    g->DrawLine(xl, yl, xp, yp);
  nok++;
  if ( xebK >= 0 ) {
    xer = mNT->GetCell(i, xebK);
    if(xer>0.) g->DrawLine(xp-xer, yp, xp+xer, yp);
  }
  if ( yebK >= 0 ) {
    yer = mNT->GetCell(i, yebK);
    if(yer>0.) g->DrawLine(xp, yp-yer, xp, yp+yer);
  }
  if (wK >= 0) { // Taille de marker en fonction du poids
    wp = mNT->GetCell(i, wK);
    sz = (int)((wp-wMin)/dw);
    if (sz < 0) sz = 0;
    if (sz > nWbins)  sz = nWbins;
    sz += msz;
    if (sz < 2)  g->SelMarker(sz, PI_DotMarker);
    else g->SelMarker(sz, mrk);
  }
  g->DrawMarker(xp, yp); 
}

/*
sprintf(buff, "NTuple:  NEntry= %d  NDisp= %d", (int)mNT->NEntry(), nok);
g->BaseGraphic()->DrawString(15,15,buff);
*/
return;
}

