#ifndef PSFILE_H_SEEN
#define PSFILE_H_SEEN

/*
 *  PSFile.h
 * 
 *  14/06/96, 19/06/96
 *
 *  Gestion des fichier .ps et .eps
 *
 *     - L'unite de mesure est lUnite Courante (UC)
 *        Au depart, 1UC == 1cm 
 *     - Les reperes sont orientes a la maniere XWindow
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "defs.h"
#ifdef __mac__
#include <stat.h>
#endif
#include "pisysdep.h"

#include PIBWDG_H      // Types enumeres repris de Peida:PIFontSize...
#include PICMAP_H

#include <list.h>


/* 
 *  Unique format actuellement gere : A4
 *
 */
enum PIPaperSizes { PI_A3 = 0, PI_A4 = 1, PI_A5 = 2, PI_NotDef = -1};

#define PAGE_WIDTH   21.0   /* == 595 points */
#define PAGE_HEIGHT  29.7   /* == 842 points */

#define PORTRAIT  1
#define LANDSCAPE 0



/* Valable pour une page, ou un bloc */
typedef struct {
    float X0;         /* Coordonnes sommet NO  */
    float Y0;         /*  en unites courantes  */
    float Tx;         /* Format                */
    float Ty;         /*  en unites courantes  */
    float Dx;         /* Coord sommet SE       */
    float Dy;         /*  en unites courantes  */
    int orientation;  /* LANDSCAPE OU PORTRAIT */
} Format;


typedef struct{
    char *Name;
    int  Tx;     /* En 1/72e de pouce  !!  */
    int  Ty;     /* unite naturelle de ps  */
} PIMedia;




class PSFile{

public:

		  PSFile (char * FileName, float Tx = 0, float Ty = 0,
			  float Dx = 0, float Dy = 0);
/*		  PSFile (PSFile *File, int PageNum, int BlocNum);*/
/*		  PSFile (char * FileName, int PageNum, int BlocNum);*/

    virtual      ~PSFile();

    virtual int     IsEPS();
    virtual char*   GetFileName();


    /* A changer ?
     * Pourrait introduire des incompatibilites
     * en cas de chgt sur la struct format ?
     */
    virtual Format* GetFormat();

    /*Attributs graphiques */
    virtual PIColors    GetDrawColor();
    virtual PIColors    GetFillColor();
    virtual PIFontAtt   GetFontAtt();
    virtual PIFontSize  GetFontSize();
    virtual PILineAtt   GetLineAtt();
    virtual PIMarker    GetMarker();

    virtual void  NewPage(float Dx, float Dy, int orientation);
    virtual void  EndPage();
    virtual void  NewBloc(float x0, float y0, float Tx, float Ty,
			  float Dx, float Dy);
    virtual void  EndBloc();

    /* Trace */
    virtual void  DrawString  (float x,  float y, char *s, 
			       PIColors DrawColor  = PI_NotDefColor, 
			       PIFontAtt FontAtt   = PI_NotDefFontAtt, 
			       int FontSize        = 8);
    virtual void  DrawLine    (float x1, float y1, float x2, float y2, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawBox     (float x0, float y0, float Tx, float Ty, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawFBox    (float x0, float y0, float Tx, float Ty, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PIColors FillColor  = PI_NotDefColor, 
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawCircle  (float x0, float y0, float r, 
			       PIColors DrawColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawFCircle (float x0, float y0, float r,
			       PIColors DrawColor  = PI_NotDefColor,
			       PIColors FillColor  = PI_NotDefColor, 
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawPolygon (float *x, float *y, int n,
			       PIColors DrawColor  = PI_NotDefColor, 
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawFPolygon(float *x, float *y, int n,
			       PIColors DrawColor  = PI_NotDefColor,
			       PIColors FillColor  = PI_NotDefColor,
			       PILineAtt LineAtt   = PI_NotDefLineAtt);
    virtual void  DrawMarker  (float x0, float y0, 
			       PIMarker MrkType    = PI_NotDefMarker, 
			       PIColors DrawColor  = PI_NotDefColor);
    virtual void  DrawMarkers (float *x0, float *y0, int n,
			       PIMarker MrkType    = PI_NotDefMarker,
			       PIColors DrawColor  = PI_NotDefColor); 

    virtual void  Image(float x0, float y0, float Tx, float Ty,
			int Nx, int Ny,
			unsigned char *pict,
			PIColorMap *mColorMap);






private:

    typedef struct {
	off_t begin;
	off_t end;
    } Offset;
    
    /* Blocs */
    typedef struct {
	int    num;
	char*  label;
	Format format;
	Offset offset;
    } Bloc;
    typedef list<Bloc> BlocList;  /* STL */

    /* Pages */
    typedef struct {
	int num;
	int BlocCounter;
	Format format;
	Offset offset;
	BlocList mBlocList;       /* Page == Liste de blocs */
    } Page;
    typedef list<Page> PageList;  /* STL */


    /* --> Toute la classe */
    static PSFile** PSFiles;      /* Tableau des PSFiles existants */

    /* --> le fichier */
    FILE *   mPSFile;
    char *   mPSFileName;
    int      isEPS;               /* Vrai si PostScript Encapsule */
    Format   mFormat;             /* Format par defaut */
    int      PageCounter;         /* Nbre de pages */
    PageList mPageList;           /* Fichier == Liste de pages */

    /* Attributs graphiques */
    enum PIColors    mDrawColor;  /* Couleur de trace courante */
    enum PIColors    mFillColor;  /* Couleur de remplissage courante */
    enum PIFontAtt   mFontAtt;
    enum PIFontSize  mFontSize;
    enum PILineAtt   mLineAtt;    /* Epaisseur d une ligne */
    enum PIMarker    mMarker;     /* Marker courant */


    /* Ecriture du PostScript dans le fichier Physique */
    /* Le code se trouve ds PSDict.cc                  */
    virtual void  WriteHeader();
    virtual void  WriteTrailer();
    virtual void  WriteNewPage(Page *mPage);
    virtual void  WriteEndPage(Page *mPage);
    virtual void  WriteNewBloc(Bloc *mBloc);
    virtual void  WriteEndBloc(Bloc *mBloc);
    virtual void  WriteDrawString(float x, float y, char* s);
    virtual void  WriteDrawLine(float x1, float y1, float x2, float y2);
    virtual void  WriteDrawBox(float x0, float y0, float Tx, float Ty);
    virtual void  WriteDrawFBox(float x0, float y0, float Tx, float Ty);
    virtual void  WriteDrawCircle(float x0, float y0, float r);
    virtual void  WriteDrawFCircle(float x0, float y0, float r);
    virtual void  WriteDrawPolygon(float *x, float *y, int n);
    virtual void  WriteDrawFPolygon(float *x, float *y, int n);
    virtual void  WriteDrawMarker(float x0, float y0);
    virtual void  WriteDrawMarkers(float *x0, float *y0, int n);
    virtual void  WriteImage(float x0, float y0, float Tx, float Ty,
		     int Nx, int Ny, unsigned char *pict, PIColorMap *mColorMap);
    virtual void  WriteSetColor(PIColors mDrawColor);
    virtual void  WriteSetFont(PIFontAtt mFontAtt, int mFontSize);
    virtual void  WriteSetLineWidth(PILineAtt mLineAtt);
};  /* End class PSFile */

#endif/* PSFILE_H_SEEN */
