#ifndef GENERICFUNC_H
#define GENERICFUNC_H

#include "pexceptions.h"
#include "classfunc.h"
#include <vector>

namespace SOPHYA {

//! Abstract interface definition for functions viewed as classes
class GenericFunc : public ClassFunc {
public:
  GenericFunc(void) { }
  virtual ~GenericFunc(void) { }

  virtual double operator()(double x) const {
    cout<<"GenericFunc::operator(double) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(double) not implemented");
  }

  virtual double operator()(double x,double y) const {
    cout<<"GenericFunc::operator(double,double) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(double,double) not implemented");
  }

  virtual double operator()(double x,double y,double z) const {
    cout<<"GenericFunc::operator(double,double,double) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(double,double,double) not implemented");
  }

  virtual double operator()(double* x) const {
    cout<<"GenericFunc::operator(double*) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(double*) not implemented");
  }

  virtual double operator()(vector<double>& x) const {
    cout<<"GenericFunc::operator(vector<double>&) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(vector<double>&) not implemented");
  }

};

}  // Fin namespace SOPHYA

#endif
