#include "toisvr.h"

TOISvr::TOISvr()
{}

void TOISvr::SetDirectory(string d) {
  iter.directory = d;
  iter.fileName = "";
}

void TOISvr::SetFile(string f) {
  iter.directory = "";
  iter.fileName = f;
}

void TOISvr::AddFile(string f) {
  iter.directory = "";
  iter.files.insert(f);
}

void TOISvr::SetMJD0(double t0) {
  iter.tBlock0 = t0;
}


void TOISvr::OnBoardRecorderFiles(bool x) {
  iter.isOnBoardRecorder = x;
}

  
void TOISvr::SetTimeInterval(double tStart, double tEnd) {
  if (tStart>0) iter.tStart = tStart;
  if (tEnd>0)   iter.tEnd = tEnd;
}
  
void TOISvr::AddInfo(TOIKind kind, int index, bool triggering, bool interp) {
  TOIIter::info i;
  i.kind = kind; 
  i.index = index;
  i.triggering = triggering;
  i.interpolated= interp;
  iter.infos.push_back(i);
}

void TOISvr::AddInfo(TOIKind kind, bool triggering, bool interp) {
  AddInfo(kind,0,triggering,interp);
}
  
TOIIter TOISvr::DoQuery() {
  iter.Init();
  return iter;
}
