#include <string>
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>

#include "archeopsfile.h"
#include "toisvr.h"
#include "archtoi.h"

using namespace std; 


ArchTOI::ArchTOI(istream& str)
{
  init();
  readReq(str);
}


ArchTOI::ArchTOI(string const& filename)
{
  init();
  ifstream str(filename.c_str());
  readReq(str);
}

void ArchTOI::init()
{
  format = ascii;
  undef  = "#";
  allBolos = false;
}

void ArchTOI::readReq(istream& str)
{
   string line;
   while (str) {
     getline(str,line);
     if (!str) break;
     if (line[0] == '@') processTOIReq(line);
     else if (line[0] == '#') 
       if (!processOption(line)) break;
   }
}

#define tsttoi(toi)   if (key == "@"#toi) kind = toi;

void ArchTOI::processTOIReq(string line)
{
  // find TOI kind, index and options
  TOIKind kind= (TOIKind)-1;
  int index=0;
  bool interp=false;
  bool repet =false;
  bool flag  =false;
  bool notrig=false;
  int x = line.find(' ');
  string key = line.substr(0, x);
  string opts = (x>0) ? line.substr(x) : string("");
  tsttoi(sampleNum)
  else tsttoi(internalTime)
  else tsttoi(utc)
  else tsttoi(boloTens)
  else tsttoi(boloRaw)
  else tsttoi(sstSignal)
  else tsttoi(sstRaw)
  else tsttoi(sstStarZ)
  else tsttoi(sstStarF)
  else tsttoi(gyroRaw)
  else tsttoi(gpsTime)
  else tsttoi(longitude)
  else tsttoi(latitude)
  else tsttoi(altitude)
  else tsttoi(tsid)
  else tsttoi(azimut)
  else tsttoi(alphaAxis)
  else tsttoi(deltaAxis)
  else tsttoi(alphaBolo)
  else tsttoi(deltaBolo)
  else {
    cerr << "*Warning, unrecognized TOI " << line << endl;
    return;
  }
  if (kind  == sampleNum) notrig = true;
  while (opts != "") {
    if (opts[0] == ' ') {
      opts = opts.substr(opts.find_first_not_of(' '));
      if (opts == "") break;
    }
    x = opts.find(' ');
    string opt = opts.substr(0, x);
    opts = (x>0) ? opts.substr(x) : string("");
    if (opt[0]>='0' && opt[0]<='9') {
      index = atoi(opt.c_str());
    } else if (opt == "notrig") {
      notrig = true;
    } else if (opt == "repet") {
      repet = true; interp = false;
    } else if (opt == "interp") {
      interp = true; repet = false;
    } else if (opt == "flag") {
      flag = true;
    }
  }
  headertoi.push_back(line);
  toiflags.push_back(flg((flag?hasflag:0)+((!repet&&!interp)?useNA:0)));
  svr.AddInfo(kind, index, !notrig, interp);
} 

bool ArchTOI::processOption(string line)
{
  int x = line.find(' ');
  string key = line.substr(0, x);
  string arg = (x>0) ? line.substr(x) : string("");
  if (arg.length()>0 && arg[0] == ' ') {
    arg = arg.substr(arg.find_first_not_of(' '));
  }
  if (key == "#ASCII") {
    format = ascii;
  } else if (key == "#TRANGE") {
    double tmin, tmax;
    sscanf(arg.c_str(), "%lg %lg", &tmin, &tmax);
    svr.SetTimeInterval(tmin, tmax);
  } else if (key == "#PATH") {
    svr.SetDirectory(arg);
  } else if (key == "#FILE") {
    svr.AddFile(arg);
  } else if (key == "#UNDEF") {
    undef=arg;
  } else if (key == "#ALLBOLOS") {
    allBolos=true;
  } else if (key == "#RECORDER") {
    svr.OnBoardRecorderFiles(true);
  } else if (key == "#MJD0") {
    double t0;
    sscanf(arg.c_str(), "%lg", &t0);
    svr.SetMJD0(0);
  } else if (key == "#END") {
    return false;
  } else {
    cerr << "*Warning, unrecognized option " << line << endl;
    return true;
  }
  
  headeropt.push_back(line);
  return true;
}


void ArchTOI::run(string const& filename)
{
  ofstream str(filename.c_str());
  run(str);
}

void ArchTOI::run(ostream& str)
{
  // output header
  for (list<string>::iterator i = headertoi.begin(); i != headertoi.end(); i++)
    str << (*i) << '\n';
  for (list<string>::iterator i = headeropt.begin(); i != headeropt.end(); i++)
    str << (*i) << '\n';;
  
  cout << "starting query" << endl;
  TOIIter iter = svr.DoQuery();
  // Normalement, on a un bloc param...
  block_type_param* blk = iter.lastParam();
  if (blk) {
    int nb = blk->param.nb_bolo;
    for (int i=0; i<nb; i++) {
#if version_num > 25
      if (allBolos) {
        str << "$BOLO " << i << " " 
            << blk->param.nom_coef[blk->param.bolo[i].numero_nom_coef].bolo_nom << " " 
            << blk->param.bolo[i].bolo_code_util << '\n';
      } else if (blk->param.bolo[i].bolo_code_util != bolo_hors_service &&
                 blk->param.bolo[i].bolo_code_util != bolo_normal_non_transmis) {
        str << "$BOLO " << i << " " 
            << blk->param.nom_coef[blk->param.bolo[i].numero_nom_coef].bolo_nom << "\n";
      }
#else
      str << "$BOLO " << i << " " << 
        blk->param.bolo[i].bolo_nom << '\n';
#endif
    }
  }
  str << "#END" << endl;
  cout << "processing" << endl;
  string ofn;
  while (iter.Next()) {
    int nn = iter.getSampleIndex();
    // if (nn%200 == 0) {cout << "."; cout.flush();
    //   if (ofn != iter.currentFile()->filename()) {
    //    ofn = iter.currentFile()->filename();
    //   cout << "current file=" << ofn << endl;
    //  }
      //}
      //if (nn%(200*80) == 0) cout << endl;
    // Si rien de dispo parmi les triggering, alors on passe au suivant
    bool hasValue = false;
    for (int i=0; i<toiflags.size(); i++) {
       if (!iter.isTrig(i)) continue;
       if (iter.canGetValue(i)) {hasValue=true; break;}
    }
    if (!hasValue) continue;
    for (int i=0; i<toiflags.size(); i++) {
      double value = iter.getValue(i);
      bool   ok    = iter.canGetValue(i);
      bool   isnew = iter.newValue(i);
      flg    flag  = toiflags[i];
      if (flag & hasflag) str << (ok && isnew ? 1 : 0) << " \t";
      if (((flag & useNA)!=0 && !isnew) || !ok) 
        str << undef << "\t";
      else
        str << setprecision(11) << value << " \t";
    }
    str << '\n';
  }
  str.flush();
  cout << "\nDone." << endl;
}

