#ifndef GPSPARSER_H
#define GPSPARSER_H

#ifndef nb_max_bolo
#define _archeops		//  Acquisition Archeops (avec transputer) 
#define programme
extern "C" {
#include "archeops.h"
}
#endif

class GPSParser {
public:
  GPSParser();
  //GPSParser(GPSParser const&);
  //GPSParser& operator = (GPSParser const&);
  virtual ~GPSParser();

  void ProcessBlock(block_type_gps*);
  
  bool hasTime();      // Can be internal clock
  bool hasGPSTime();   // New GPS time
  bool hasPosition();
  bool hasAltitude();
  
  double getUTC();
  double getLatitude();
  double getLongitude();
  double getAltitude();
  
protected:

  char gpsString[100];
  bool   stringOk;
  double gpsutc;        //  secondes depuis minuit
  double gpslat;        //  degres, + = NORD
  double gpslong;       //  degres, + = EST
  int    quality;       //  0 = NO FIX, 1 = GPS FIX, 2 = DGPS FIX
  int    nsat;          //  nombre de satellites utilises
  double hdop;          //  horizontal dilution of precision
  double alt;           //  altitude en metres
  double gsep;          //  separation geoide en metres
};

#endif
