#ifndef ARCHTOI_H
#define ARCHTOI_H

#include <iostream.h>
#include <string>
#include <list>
#include <vector>
#include "toisvr.h"

using namespace std; 

class ArchTOI {
public:
  ArchTOI(istream& str);
  ArchTOI(string const& filename);

  void run(ostream& str);
  void run(string const& filename);
  
  enum fmt {ascii};
  enum flg {hasflag = 1,
            useNA   = 2};
  
protected:
  void init();
  void readReq(istream& str);
  bool processOption(string line); // false when #END : stop processing...
  void processTOIReq(string line);
  TOISvr svr;
  list<string> headertoi;
  list<string> headeropt;
  vector<flg>  toiflags;
  fmt format;
  string undef;
  bool allBolos; // tous les bolos dans le header. Sinon seulement bolos transmis.
};

#endif
