#include "machdefs.h"

#include <iostream>

#include "pexceptions.h"
#include "vfs.h"

//------------------------------------------------------
// An example to illustrate how to make a class 
//  persistent using the SOPHYA PPF services
// (C) LAL-IN2P3/CNRS   (C) DAPNIA-SPP/CEA 
// ----------------------------------------------------

using namespace SOPHYA;   

//--- The main program ----

int main(int narg, char* arg[])
{
  
  cout << " --------- tvfs.cc  test of class Vfs and ObjFileIO<Vfs>  ---------- "
       << endl;
  
  // We have to register the PPersist handler for our class Vfs
  // This should be performed at initialization
  // The following two lines (CPP macros) do the job :

  // First, register the PPF handler ObjFileIO<Vfs> 
  PPRegister(ObjFileIO<Vfs>);
  // Register the list of classes which can be handled by ObjFileIO<Vfs> 
  DObjRegister(ObjFileIO<Vfs>, Vfs);


  try {
    Vfs xa(5);
    xa.Set(0, 0., "Zero");
    xa.Set(1, 1., "Un");
    xa.Set(2, 2., "Deux");
    xa.Set(3, 3., "Trois");
    xa.Set(4, 4., "Quatre");
    cout << xa ;
    {
    // We save our objet ito a POutPersist flow
      POutPersist po("tvfs.ppf");
      po << xa;
    }
    {
    // We try to read in the saved Vfs xa object
      Vfs xb;
      cout << " Vfs xb before reading : \n " << xb << endl;
      PInPersist pi("tvfs.ppf");
      pi >> xb;
      cout << " After reading pi >> xb : \n " << xb << endl;
    }
    
  }

  catch (PThrowable & pex) {
    cerr << " tvfs.cc/Error - Exception catched " << (string)typeid(pex).name()
	 << " - Msg= " << pex.Msg() << endl;
  }
  catch (...) {
    cerr << " tx.cc/Error - Exception (...) catched " << endl;
    }
      
  cout << " ----------- End of tx.cc  ------------- " << endl;

  return(0);
 
}
