#ifndef VFS_H_SEEN
#define VFS_H_SEEN

#include "machdefs.h"

#include <string>
#include <vector>

#include "ndatablock.h"
#include "objfio.h"

//------------------------------------------------------
// An example to illustrate how to make a class 
//  persistent using the SOPHYA PPF services
// (C) LAL-IN2P3/CNRS   (C) DAPNIA-SPP/CEA 
// ----------------------------------------------------

// A simple class to hold pairs(float, string)
// we want to make this class persistent using SOPHYA PPF services

class Vfs : public SOPHYA::AnyDataObj {
public:
// We need a default constructor , if we want to use the ObjFileIO<Vfs> class
            Vfs(int sz=10);
  virtual   ~Vfs() { };

// Setting element k
  void      Set(int k, r_4 fv, string const sv);
// Accessing float part of element k
  r_4       GetF(int k);
// Accessing string part of element k
  string    GetS(int k);
// display/print object content
  void      Print(ostream& os) const ; 
//  For persistence handling
  friend class SOPHYA::ObjFileIO<Vfs> ;
 private:
	  SOPHYA::NDataBlock<r_4> mFVal;
	  vector<string> mSVal;	  	  
};

// For easy printing of Vfs through cout << x ;
inline ostream& operator << (ostream& s, Vfs const & x)
  {  x.Print(s);  return(s);  }

/* Writes the object in the POutPersist stream  os */
inline SOPHYA::POutPersist& operator << (SOPHYA::POutPersist& os, Vfs & obj)
{ SOPHYA::ObjFileIO<Vfs> fio(&obj);  fio.Write(os);  return(os); }
/* Reads the object from the PInPersist stream  is */
inline SOPHYA::PInPersist& operator >> (SOPHYA::PInPersist& is, Vfs & obj)
{ SOPHYA::ObjFileIO<Vfs> fio(&obj);  fio.Read(is);  return(is); }


#endif




