#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream.h>
#include <string>

#include "nomstladapter.h"
#include "stlist.h"
#include "pistlist.h"




//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet StarList
//-------------------------------------------------------------------------

/* --Methode-- */
NOMAdapter_StarList::NOMAdapter_StarList(StarList* o)
  : NObjMgrAdapter(o)
{
mStl = o;
}

/* --Methode-- */
NOMAdapter_StarList::~NOMAdapter_StarList()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_StarList::Clone(AnyDataObj* o)
{
StarList* stl = dynamic_cast<StarList *>(o);
if (stl) return ( new NOMAdapter_StarList(stl) );
return ( new NObjMgrAdapter(o) );
}


/* --Methode-- */
void NOMAdapter_StarList::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'objet est lui-meme PPersist
string tag = nom;  // A cause de const
mStl->Write(pos,0,tag);
#else
string s = typeid(*mStl).name();
cout << "NOMAdapter_StarList::SavePPF() - Error : Not supported for " << s << endl;
#endif
}

/* --Methode-- */
void NOMAdapter_StarList::Print(ostream& os)
{
os << (*mStl);
}

/* --Methode-- */
PIDrawer* NOMAdapter_StarList::GetDrawer(string & dopt)
{
return(new PIStarList(mStl, false));
}


/* --Methode-- */
NTupleInterface* NOMAdapter_StarList::GetNTupleInterface(bool& adel)
{
adel = true;
return( new NTupInt_StarList(mStl) );
}


// -------------------------------------------------------------

/* --Methode-- */
NTupInt_StarList::NTupInt_StarList(StarList* stl)
{
mStl = stl;
}

/* --Methode-- */
NTupInt_StarList::~NTupInt_StarList()
{
}

/* --Methode-- */
uint_4 NTupInt_StarList::NbLines() const
{
return(mStl->NbStars());
}

/* --Methode-- */
uint_4 NTupInt_StarList::NbColumns() const 
{
return(11);
}

/* --Methode-- */
r_8* NTupInt_StarList::GetLineD(int n) const 
{
BStar* bst = mStl->Star(n);
if (bst == NULL)  
  for(int k=0; k<11; k++)  mRet[k] = -9999.0;
else {
  mRet[0] = bst->PosX();
  mRet[1] = bst->PosY();
  mRet[2] = bst->Flux();
  mRet[3] = bst->Fond();
  mRet[4] = bst->PixMax();
  mRet[5] = bst->PosXRef();
  mRet[6] = bst->PosYRef();
  mRet[7] = bst->FluxRef();
  mRet[8] = bst->FondRef();
  mRet[9] = bst->PixMaxRef();
  mRet[10] = bst->Flags();
  }
return(mRet);
}

/* --Methode-- */
string NTupInt_StarList::VarList_C(const char* nx) const 
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xstl_";
string vardec = "double x,y,flux,fond,pixmax; \n";
vardec += "double xref,yref,fluxref,fondref,pixmaxref; \n";
vardec += "double flags; \n"; 
vardec += "x = " + nomx + "[0];  y = " + nomx + "[1]; \n";
vardec += "flux = " + nomx + "[2];  fond = " + nomx + "[3]; \n";
vardec += "pixmax = " + nomx + "[4]; \n";
vardec += "xref = " + nomx + "[5];  yref = " + nomx + "[6]; \n";
vardec += "fluxref = " + nomx + "[7];  fondref = " + nomx + "[8]; \n";
vardec += "pixmaxref = " + nomx + "[9]; \n";
vardec += "flags = " + nomx + "[10]; \n";
return(vardec);
}
