// This may look like C code, but it is really -*- C++ -*-
// Adaptateur d objets (pour NamedObjMgr) pour Histos/NTuple
//                                    Reza 05/99
//  LAL-IN2P3/CNRS               CEA-DAPNIA     
 
#ifndef NOMHISTADAPTER_H_SEEN
#define NOMHISTADAPTER_H_SEEN

#include "nomgadapter.h"
#include "histos.h"
#include "histos2.h"
#include "hisprof.h"
#include "ntuple.h"

//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Histo / HProf
//-------------------------------------------------------------------------

class NOMAdapter_Histo : public NObjMgrAdapter {
public:
				NOMAdapter_Histo(Histo* h = NULL);
  virtual			~NOMAdapter_Histo();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  //  virtual void			ReadFits(string const & flnm);
  //  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  virtual PIDrawer*		GetDrawer(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

protected:
  Histo* mHis;
};

// Class Interface NTuple pour Histo / HProf
class NTupInt_Histo : public NTupleInterface {
public:
			NTupInt_Histo(Histo* h);
  virtual		~NTupInt_Histo();
  virtual uint_4        NbLines() const ;
  virtual uint_4        NbColumns() const ;
  virtual r_8 *         GetLineD(int n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  Histo* mHis;
  mutable r_8 mRet[4];
};

//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Histo2D
//-------------------------------------------------------------------------

class NOMAdapter_Histo2D : public NObjMgrAdapter {
public:
				NOMAdapter_Histo2D(Histo2D* h = NULL);
  virtual			~NOMAdapter_Histo2D();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  //  virtual void			ReadFits(string const & flnm);
  //  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  virtual PIDrawer*		GetDrawer(string& dopt);
  virtual P2DArrayAdapter*      Get2DArray(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

protected:
  Histo2D* mHis;
};

// Class Interface NTuple pour Histo2D
class NTupInt_Histo2D : public NTupleInterface {
public:
			NTupInt_Histo2D(Histo2D* h);
  virtual		~NTupInt_Histo2D();
  virtual uint_4        NbLines() const ;
  virtual uint_4        NbColumns() const ;
  virtual r_8 *         GetLineD(int n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  Histo2D* mHis;
  mutable r_8 mRet[6];
};


//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet NTuple 
//-------------------------------------------------------------------------

class NOMAdapter_NTuple : public NObjMgrAdapter {
public:
				NOMAdapter_NTuple(NTuple* h = NULL);
  virtual			~NOMAdapter_NTuple();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  //  virtual void			ReadFits(string const & flnm);
  //  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

protected:
  NTuple* mNt;
};



#endif
