// This may look like C code, but it is really -*- C++ -*-
// Classe de services destinee a NamedObjMgr pour piapp
// Reza                             Aout 98
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef SERVNOBJM_H_SEEN
#define SERVNOBJM_H_SEEN

#include "machdefs.h"
#include <string>
#include <list>
#include <map>
#if defined(__KCC__)
using std::string ;
#include <list.h>
#include <map.h>
#endif

#include "pdlmgr.h"
#include "dlftypes.h"
#include "anydataobj.h"

class NTuple;
class Histo;
class Histo2D;
class HProf;
class NamedObjMgr;
class PIStdImgApp;
class NObjMgrAdapter;

class Services2NObjMgr {
public:
         	Services2NObjMgr(NamedObjMgr* omg, string& tmpdir);
  virtual	~Services2NObjMgr();

// Pour enregistrer les objets de donnees et leurs adaptateurs
  void			RegisterClass(AnyDataObj* o, NObjMgrAdapter* oa);
// Pour recuperer l'adaptateur pour un objet o 
  NObjMgrAdapter*	GetAdapter(AnyDataObj* o);

  inline void   SetImgApp(PIStdImgApp* app) {mImgapp = app; }

// Trace de fonctions 1-D , 2-D
  virtual void  PlotFunc(string const & expfunc, string & nom, double xmin, double xmax, 
                         int np=100, string dopt="");
  virtual void  PlotFunc2D(string const & expfunc, string & nom, double xmin, double xmax, 
                           double ymin, double ymax, int npx=50, int npy=50, string dopt="");
  virtual void  PlotFuncFrCFile(string const & fname, string const & func, string & nom, 
                                double xmin, double xmax, int np=100, string dopt="");
  virtual void  PlotFunc2DFrCFile(string const & fname, string const & func, string & nom, 
                                  double xmin, double xmax, double ymin, double ymax, 
                                  int npx=50, int npy=50, string dopt="");
  virtual void  PlotFunc(DlFunctionOfX f, string & nom, double xmin, double xmax, 
                         int np=100, string dopt="");
  virtual void  PlotFunc2D(DlFunctionOfXY f, string & nom, double xmin, double xmax, 
                           double ymin, double ymax, int npx=50, int npy=50, string dopt="");

//  Trace d'expression de NTuple, et d'autres objets
  virtual void          DisplayPoints2D(string & nom, string& expx, string& expy,
                                        string& experrx, string& experry, 
                                        string& expcut, string dopt="");
  virtual void          DisplayPoints3D(string & nom, string& expx, string& expy, string& expz, 
                                        string& expcut, string dopt="");
  virtual void          DisplayPoints2DW(string & nom, string& expx, string& expy, 
                                         string& expwt, string& expcut, string dopt="");
//  Projection d'expressions dans histogramme (et trace) 
  virtual void          ProjectH1(string & nom, string& expx, string& expwt, string& expcut, 
                                  string& nomh1, string dopt="");
  virtual void          ProjectH2(string & nom, string& expx, string& expy, string& expwt, 
                                  string& expcut, string& nomh2, string dopt="");
  virtual void          ProjectHProf(string & nom, string& expx, string& expy, string& expwt, 
                                  string& expcut, string& nomprof, string dopt="");
//  Projection d'expression dans vecteurs et dans n-tuple
  virtual void          FillVect(string & nom, string& expx, string& expcut, 
                                 string& nomvec, string dopt="");
  virtual void          FillNT(string & nom, string& expx, string& expy, string& expz,
                               string& expt, string& expcut, string& nomnt); 
  virtual void          FillGFD(string & nom, string& expx, string& expy, string& expz,
                               string& experr, string& expcut, string& nomgfd);
  virtual void          FillNTFrCFile(string & nom, string const & fname, 
                                      string const & funcname, string & nomnt,
                                      int nl1=-1, int nl2=-1);
  virtual void		PrepareNTExpressionCFile(string & nomobj, string const & fname, 
                                                 string const & funcname);

//   Methodes de fit -  CMV , deux methodes H1 H2 ou 1 seule ??) ...
  virtual void          Fit12D(string & nom, string& func,
                              string par,string step,string min,string max,string opt);

// Calcul d'expressions d'interface NTuple pour les objets
  void 		ComputeExpressions(NObjMgrAdapter* obja, string& expx, string& expy, 
                                   string& expz, string& expt, string& expcut,
                                   NTuple* nt=NULL, Histo* h1=NULL,
                                   Histo2D* h2=NULL, HProf* hp=NULL);
  PlotExprFunc  LinkExprFunc(string& vardec, string& expx, string& expy, 
                             string& expz, string& expt, string& cut);
  DlFunction    LinkFunctionFromFile(string const & fname, string const & funcname);
  void 		CloseDLL();  

// Utilitaires divers 
  string 	FileName2Name(string const & fn);
  int 		DecodeDispOption(string& dopt, bool& fgsrgr);
  char* 	PClassIdToClassName(int cid);

protected:
  void 		InitGrAttNames();

// Pour enregister les objets et leurs adaptateurs pour NamedObjMgr
  struct dataobj_adapter {
    AnyDataObj* obj;  NObjMgrAdapter* obja;
  };
  typedef list<dataobj_adapter> ObjAdaptList;
  ObjAdaptList objadaplist;

//   Variables membre , en public pour le moment
  struct gratt_item {
    int a1, a2;
  };
  typedef map<string, gratt_item, less<string> > GrAttNames;
  
//  Pour les changements d'attributs graphiques / de visualisation
  GrAttNames GrAcolors;
  GrAttNames GrAlines;
  GrAttNames GrAmarkers;
  GrAttNames GrAfonts;
  GrAttNames GrAcmap;  
  GrAttNames GrAzoom;  
  GrAttNames GrAaxes;  

  PDynLinkMgr * dynlink;  // shared-lib lib.so
  string TmpDir;          // Pour fichiers temporaires

  PIStdImgApp* mImgapp;
  NamedObjMgr* mOmg;
  
};


#endif
