#include "piacmd.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "basexecut.h"

#include "pdlmgr.h"
#include "ctimer.h"
// #include "dlftypes.h"

#include "pistdimgapp.h"
#include "nobjmgr.h"
#include "servnobjm.h"

#include "histos.h"
#include "histos2.h"
#include "hisprof.h"
#include "ntuple.h"
#include "generaldata.h"
#include "cvector.h"



/* --Methode-- */
PIABaseExecutor::PIABaseExecutor(PIACmd* piac, NamedObjMgr* omg, PIStdImgApp* app)
{
mpiac = piac;
mObjMgr = omg; 
mImgApp = app;
dynlink = NULL;
RegisterCommands();
}

PIABaseExecutor::~PIABaseExecutor()
{
}


 
/* --Methode-- */
int PIABaseExecutor::Execute(string& kw, vector<string>& tokens)
{
Services2NObjMgr* srvo = mObjMgr->GetServiceObj();
// >>>>> Chargement de modules
if (kw == "loadmodule") {
  if (tokens.size() < 2) { cout << "Usage: loadmodule fnameso modulename" << endl;  return(0); }
  mpiac->LoadModule(tokens[0], tokens[1]);
  }
// >>>>>>>>>>> Fenetre graphique , changement d'attributs graphiques 
else if (kw == "zone") {
  if (tokens.size() < 2) { cout << "Usage: zone nx ny" << endl;  return(0); }
  int nx, ny;
  nx = ny = 1;
  nx = atoi(tokens[0].c_str());    ny = atoi(tokens[1].c_str());
  mObjMgr->SetGraphicWinZone(nx, ny, false);
  }  
else if (kw == "newwin") {
  if (tokens.size() < 2) { cout << "Usage: newwin nx ny" << endl;  return(0); }
  int nx, ny;
  nx = ny = 1;
  nx = atoi(tokens[0].c_str());    ny = atoi(tokens[1].c_str());
  mObjMgr->SetGraphicWinZone(nx, ny, true);
  }  
else if (kw == "stacknext") mImgApp->StackWinNext(); 
else if (kw == "gratt") {
  if (tokens.size() < 1) { cout << "Usage: gratt attributes_list (att=def->defaut)" << endl;  return(0); }
  mObjMgr->SetGraphicAttributes(tokens[0]); 
  }
else if (kw == "setxylimits") {
  if (tokens.size() < 4) { cout << "Usage: setxylimits xmin xmax ymin ymax" << endl;  return(0); }
  double xmin = atof(tokens[0].c_str());
  double xmax = atof(tokens[1].c_str());
  double ymin = atof(tokens[2].c_str());
  double ymax = atof(tokens[3].c_str());
  mImgApp->SetXYLimits(xmin, xmax, ymin, ymax);
  }
// >>>>>>>>>>> Link dynamique de fonctions C++
else if (kw == "link" ) {
  if (tokens.size() < 2) { cout << "Usage: link fnameso f1 [f2 f3]" << endl;  return(0); }
  string sph = "";
  for(int gg=0; gg<5; gg++)   tokens.push_back(sph);
  int rc = LinkUserFuncs(tokens[0], tokens[1], tokens[2], tokens[3]);
  if (rc == 0)  cout << "PIABaseExecutor: Link from " << tokens[0] << " OK " << endl;
}
else if (kw == "call" ) {
  if (tokens.size() < 1) { cout << "Usage: call userf [arg1 arg2 ...]" << endl;  return(0); }
  UsFmap::iterator it = usfmap.find(tokens[0]);
  if (it == usfmap.end()) {
    cerr << "PIABaseExecutor: No User Function " << tokens[0] << endl;
    return(0);
  }
  cout << "PIABaseExecutor: Call " << tokens[0] << "( ... )" << endl;
// on est oblige de faire un cast  etant donne qu'on 
// utilise donc des DlFunction  (Reza 20/08/98)  voir commentaire ds .h (pb g++)
  DlUserProcFunction fuf = (DlUserProcFunction)(*it).second;
//   On redirige la sortie sur le terminal 
  bool red = mImgApp->HasRedirectedStdOutErr();
  mImgApp->RedirectStdOutErr(false);
  TRY {
    tokens.erase(tokens.begin());
    fuf(tokens);
  }  CATCH(merr) {
    fflush(stdout); 
    cout << endl; 
    cerr << endl;
    string es = PeidaExc(merr);
    cerr << "PIABaseExecutor: Call UserFunc  Exception :" << merr << es;
    }
  mImgApp->RedirectStdOutErr(red);
}

// >>>>>>>>>>> lecture/ecriture des objets, gestion des objets 
else if (kw == "openfits" ) {
  if (tokens.size() < 1) { cout << "Usage: openfits file " << endl;  return(0); }
  else { string nomobj = "";  mObjMgr->ReadFits(tokens[0], nomobj); }
}
else if (kw == "savefits" ) {
  if (tokens.size() < 2) { cout << "Usage: savefits nameobj filename " << endl;  return(0); }
  else mObjMgr->SaveFits(tokens[0], tokens[1]);
}
else if (kw == "openppf" ) {
  if (tokens.size() < 1) { cout << "Usage: openppf file " << endl; return(0); }
  mObjMgr->ReadAll(tokens[0]);  
}
else if (kw == "saveobjs" ) {
  if (tokens.size() < 2) { cout << "Usage: saveobjs patt filename " << endl; return(0); }
  mObjMgr->SaveObjects(tokens[0], tokens[1]);  
}
else if (kw == "saveall" ) {
  if (tokens.size() < 1) { cout << "Usage: saveall file " << endl; return(0); }
  mObjMgr->SaveAll(tokens[0]);  
}
else if (kw == "print" ) {
  if (tokens.size() < 1) { cout << "Usage: print nameobj " << endl; return(0); }
  mObjMgr->PrintObj(tokens[0]);  
}
else if ( (kw == "rename" ) || (kw == "mv") )  {
  if (tokens.size() < 2) { cout << "Usage: rename nameobj namenew" << endl; return(0); }
  mObjMgr->RenameObj(tokens[0], tokens[1]);  
}
else if ( (kw == "del" ) || (kw == "rm") ) {
  if (tokens.size() < 1) { cout << "Usage: del nameobj " << endl; return(0); }
  mObjMgr->DelObj(tokens[0]);  
}
else if (kw == "delobjs" ) {
  if (tokens.size() < 1) { cout << "Usage: delobjs nomobjpattern (*,?) " << endl; return(0); }
  mObjMgr->DelObjects(tokens[0]);  
}
else if ( (kw == "listobjs") || (kw == "ls") )    { 
  if  (tokens.size() < 1)  tokens.push_back("*");
  mObjMgr->ListObjs(tokens[0]);
}
// Gestion des repertoires
else if (kw == "mkdir" ) {
  if (tokens.size() < 1) { cout << "Usage: mkdir dirname [true]" << endl; return(0); }
  bool crd = mObjMgr->CreateDir(tokens[0]);  
  if ( crd && (tokens.size() > 1) && (tokens[1] == "true") )
    mObjMgr->SetKeepOldDirAtt(tokens[0], true);
  }
else if (kw == "rmdir" ) {
  if (tokens.size() < 1) { cout << "Usage: rmdir dirname " << endl; return(0); }
  mObjMgr->DeleteDir(tokens[0]);  
  }
else if (kw == "cd")   { 
  if  (tokens.size() < 1)  tokens.push_back("home");
  mObjMgr->SetCurrentDir(tokens[0]);
  }
else if (kw == "pwd") { 
  string dirn;
  mObjMgr->GetCurrentDir(dirn);
  cout << "CurrentDirectory: " << dirn << endl;
  }  
else if (kw == "listdirs")   { 
  if  (tokens.size() < 1)  tokens.push_back("*");
  mObjMgr->ListDirs(tokens[0]);
  }

// >>>>>>>>>>> Creation d'histos 1D-2D
else if (kw == "newh1d") {
  if (tokens.size() < 4) { cout << "Usage: newh1d name xmin xmax nbin" << endl; return(0); }
  int nbx;
  float xmin, xmax;
  nbx = 100;
  xmin = 0.;  xmax = 1.;
  nbx = atoi(tokens[3].c_str());
  xmin = atof(tokens[1].c_str());   xmax = atof(tokens[2].c_str());
  Histo* h = new Histo(xmin, xmax, nbx);
  mObjMgr->AddObj(h, tokens[0]);
  }
else if (kw == "newh2d") {
  if (tokens.size() < 7) { 
    cout << "Usage: newh2d name xmin xmax nbinx ymin ymax nbiny" << endl; 
    return(0); 
    }
  int nbx, nby;
  float xmin, xmax;
  float ymin, ymax;
  nbx = nby = 50;
  xmin = 0.;  xmax = 1.;
  ymin = 0.;  ymax = 1.;
  nbx = atoi(tokens[3].c_str());
  nby = atoi(tokens[6].c_str());
  xmin = atof(tokens[1].c_str());   xmax = atof(tokens[2].c_str());
  ymin = atof(tokens[4].c_str());   ymax = atof(tokens[5].c_str());
  Histo2D* h = new Histo2D(xmin, xmax, nbx, ymin, ymax, nby);
  mObjMgr->AddObj(h, tokens[0]);
  }
else if (kw == "newprof") {
  if (tokens.size() < 4)
    { cout << "Usage: newprof name xmin xmax nbin [ymin ymax]" << endl; return(0); }
  int nbx;
  float xmin, xmax, ymin = 1., ymax = -1.;
  if(tokens.size() > 5)
    {ymin = atof(tokens[4].c_str());   ymax = atof(tokens[5].c_str());}
  nbx = 100;
  xmin = 0.;  xmax = 1.;
  nbx = atoi(tokens[3].c_str());
  xmin = atof(tokens[1].c_str());   xmax = atof(tokens[2].c_str());
  HProf* h = new HProf(xmin, xmax, nbx, ymin, ymax);
  mObjMgr->AddObj(h, tokens[0]);
  }
else if (kw == "newgfd") {
  if (tokens.size() < 3)
    { cout << "Usage: newgfd nvar nalloc [errx(0/1)]" << endl; return(0); }
  int nvar, nalloc, errx=0;
  if (tokens.size() > 3)
    { errx = atoi(tokens[3].c_str()); if(errx>0) errx=1; else errx = 0;}
  nvar = atoi(tokens[1].c_str()); nalloc = atoi(tokens[2].c_str());
  if(nvar>0 && nalloc>0) {
    GeneralFitData* gfd = new GeneralFitData(nvar,nalloc,errx);
    mObjMgr->AddObj(gfd, tokens[0]);
    }
  }

// Creation/remplissage de vecteur et de matrice
else if (kw == "newvec") {
  if (tokens.size() < 2) { 
    cout << "Usage: newvec name size [f(i) dopt] " << endl; return(0); 
    }
  int n = atoi(tokens[1].c_str());
  double xmin, xmax;
  xmin = 0.;  xmax = n;
  if (tokens.size() < 3)  tokens.push_back("0.");
  if (tokens.size() < 4)  tokens.push_back("n");
  mObjMgr->GetServiceObj()->PlotFunc(tokens[2], tokens[0], xmin, xmax, n, tokens[3]); 
  }
else if (kw == "newmtx") {
  if (tokens.size() < 3) { 
    cout << "Usage: newvec name sizeX sizeY [f(i,j) dopt] " << endl; return(0); 
    }
  int nx = atoi(tokens[1].c_str());
  int ny = atoi(tokens[2].c_str());
  double xmin, xmax, ymin, ymax;
  xmin = 0.;  xmax = nx;
  ymin = 0.;  ymax = ny;
  if (tokens.size() < 4)  tokens.push_back("0.");
  if (tokens.size() < 5)  tokens.push_back("n");
  mObjMgr->GetServiceObj()->PlotFunc2D(tokens[3], tokens[0], xmin, xmax, ymin, ymax, 
                                       nx, ny, tokens[4]);
  }

// >>>>>>>>>>>  Affichage des objets 
else if ( (kw == "disp") || (kw == "surf") || (kw == "imag") ) {
  if (tokens.size() < 1) { cout << "Usage: disp/surf/imag nameobj [opt]" << endl; return(0); }
  string opt = "n";
  if (tokens.size() > 1)  opt = tokens[1];
  if (kw == "disp") mObjMgr->DisplayObj(tokens[0], opt);
  else if (kw == "surf")  mObjMgr->DisplaySurf3D(tokens[0], opt);
  else if (kw == "imag")  mObjMgr->DisplayImage(tokens[0], opt);
  }

else if (kw == "nt2d") {
  if (tokens.size() < 5) { cout << "Usage: nt2d nameobj varx vary errx erry opt" << endl; return(0); }
  string opt = "n";
  if (tokens.size() > 5)  opt = tokens[5];
  string ph = "";
  mObjMgr->DisplayNT(tokens[0],tokens[1],tokens[2], ph, tokens[3], tokens[4], ph, opt);
  }
else if (kw == "nt2dw") {
  if (tokens.size() < 6) { cout << "Usage: nt2dw nameobj varx vary varz errx erry opt" << endl; return(0); }
  string opt = "n";
  if (tokens.size() > 6)  opt = tokens[6];
  string ph = "";
  mObjMgr->DisplayNT(tokens[0],tokens[1],tokens[2], tokens[3], tokens[4], tokens[5], ph, opt, false);
  }
else if (kw == "nt3d") {
  if (tokens.size() < 7) { cout << "Usage: nt3d nameobj varx vary varz errx erry errz opt" << endl; return(0); }
  string opt = "n";
  if (tokens.size() > 7)  opt = tokens[7];
  mObjMgr->DisplayNT(tokens[0],tokens[1],tokens[2], tokens[3], tokens[4], tokens[5], tokens[6], opt, true);
  }

// Obsolete : ne pas virer SVP, cmv 26/7/99
else if (kw == "gfd2d") {
  cout<<"----- gfd2d OBSOLETE: utilisez nt2d -----"<<endl;
  if(tokens.size()<2)
    {cout<<"Usage: gfd2d nomobj numvarx erreur=(x y xy) opt"<<endl;
     return(0);}
  string numvary = "";
  string err = "";
  string opt = "n";
  if(tokens.size()>2) err = tokens[2];
  if(tokens.size()>3) opt = tokens[3];
  mObjMgr->DisplayGFD(tokens[0],tokens[1],numvary,err,opt);
  }
else if (kw == "gfd3d") {
  cout<<"----- gfd3d OBSOLETE: utilisez nt3d -----"<<endl;
  if(tokens.size()<3)
    {cout<<"Usage: gfd3d nameobj numvarx numvary erreur=(x y z xy xz yz xyz) opt"<<endl;
     return(0);}
  string err = "";
  string opt = "n";
  if(tokens.size()>3) err = tokens[3];
  if(tokens.size()>4) opt = tokens[4];
  mObjMgr->DisplayGFD(tokens[0],tokens[1],tokens[2],err,opt);
  }

// >>>>>>>>>>>  Trace de fonctions 
else if ( (kw == "func") ) {
  if (tokens.size() < 4) { cout << "Usage: func f(x) xmin xmax npt [opt]" << endl; return(0); }
  string opt = "n";
  if (tokens.size() > 4)  opt = tokens[4];
  int np;
  double xmin, xmax;
  np = 100;
  xmin = 0.;  xmax = 1.;
  np = atoi(tokens[3].c_str());
  xmin = atof(tokens[1].c_str());   xmax = atof(tokens[2].c_str());
  string nom = "";
  mObjMgr->GetServiceObj()->PlotFunc(tokens[0], nom, xmin, xmax, np, opt); 
  }
else if ( (kw == "funcff") ) {
  if (tokens.size() < 5) { cout << "Usage: funcff C-filename f(x)-name xmin xmax npt [opt]" << endl; return(0); }
  string opt = "n";
  if (tokens.size() > 5)  opt = tokens[5];
  int np;
  double xmin, xmax;
  np = 100;
  xmin = 0.;  xmax = 1.;
  np = atoi(tokens[4].c_str());
  xmin = atof(tokens[2].c_str());   xmax = atof(tokens[3].c_str());
  string nom = "";
  mObjMgr->GetServiceObj()->PlotFuncFrCFile(tokens[0], tokens[1], nom, xmin, xmax, np, opt); 
  }
else if ( (kw == "func2d") ) {
  if (tokens.size() < 7) {
    cout << "Usage: func2d f(x,y) xmin xmax nptx ymin ymax npty opt" << endl;
    return(0);
    }
  int npx, npy;
  double xmin, xmax;
  double ymin, ymax;
  npx = npy = 50;
  xmin = 0.;  xmax = 1.;
  ymin = 0.;  ymax = 1.;
  npx = atoi(tokens[3].c_str());
  npy = atoi(tokens[6].c_str());
  xmin = atof(tokens[1].c_str());   xmax = atof(tokens[2].c_str());
  ymin = atof(tokens[4].c_str());   ymax = atof(tokens[5].c_str());
  string opt = "n";
  if (tokens.size() > 7)  opt = tokens[7];
  string nom = "";
  mObjMgr->GetServiceObj()->PlotFunc2D(tokens[0], nom, xmin, xmax, ymin, ymax, npx, npy, opt);
  }
else if ( (kw == "func2dff") ) {
  if (tokens.size() < 8) {
    cout << "Usage: func2d C-filename F(x,y)-name xmax nptx ymin ymax npty opt" << endl;
    return(0);
    }
  int npx, npy;
  double xmin, xmax;
  double ymin, ymax;
  npx = npy = 50;
  xmin = 0.;  xmax = 1.;
  ymin = 0.;  ymax = 1.;
  npx = atoi(tokens[4].c_str());
  npy = atoi(tokens[7].c_str());
  xmin = atof(tokens[2].c_str());   xmax = atof(tokens[3].c_str());
  ymin = atof(tokens[5].c_str());   ymax = atof(tokens[6].c_str());
  string opt = "n";
  if (tokens.size() > 8)  opt = tokens[8];
  string nom = "";
  mObjMgr->GetServiceObj()->PlotFunc2DFrCFile(tokens[0], tokens[1], nom, xmin, xmax, ymin, ymax, npx, npy, opt);
  }

// >>>>>>>>>>>  Trace d'expressions de N_Tuple, StarList, etc ...
else if (kw == "plot2d" ) {
  if (tokens.size() < 4) {
    cout << "Usage: plot2d nameobj expx expy [experrx experry] expcut [opt]" << endl;
    return(0); 
    }
  string errx = ""; string erry = ""; string ecut = "1";
  string opt = "n";
  if (tokens.size() < 6) { // Plot sans les erreurs
    ecut = tokens[3];
    if (tokens.size() > 4)  opt = tokens[4];
    }
  else {                 // Plot avec les erreurs
    errx = tokens[3]; erry = tokens[4]; ecut = tokens[5];
    if (tokens.size() > 6)  opt = tokens[6];
    }
  srvo->DisplayPoints2D(tokens[0],tokens[1],tokens[2],errx,erry,ecut,opt);
  }

else if (kw == "plot2dw" ) {
  if (tokens.size() < 5) { 
    cout << "Usage: plot2dw nomobj expx expy expwt expcut opt" << endl;
    return(0); 
    }
  string opt = "n";
  if (tokens.size() > 5)  opt = tokens[5];
  srvo->DisplayPoints2DW(tokens[0],tokens[1],tokens[2],tokens[3], tokens[4], opt);
  }
else if (kw == "plot3d" ) {
  if (tokens.size() < 5) { 
    cout << "Usage: plot3d nomobj expx expy expz expcut opt" << endl;
    return(0); 
    }
  string opt = "n";
  if (tokens.size() > 5)  opt = tokens[5];
  srvo->DisplayPoints3D(tokens[0],tokens[1],tokens[2],tokens[3], tokens[4], opt);
  }

else if (kw == "projh1d" ) {
  if (tokens.size() < 5) { 
    cout << "Usage: projh1d nomobj expx expwt expcut nomh1 opt" << endl;
    return(0);
    }
  string opt = "n";
  if (tokens.size() > 5)  opt = tokens[5];
  srvo->ProjectH1(tokens[0],tokens[1],tokens[2], tokens[3], tokens[4], opt);
  }

else if (kw == "projh2d" ) {
  if (tokens.size() < 6) { 
    cout << "Usage: projh2 nomobj expx expy expwt expcut nomh2 opt" << endl;
    return(0);
    }
  string opt = "n";
  if (tokens.size() > 6)  opt = tokens[6];

  srvo->ProjectH2(tokens[0],tokens[1],tokens[2], tokens[3], tokens[4], tokens[5], opt);
  }

else if (kw == "projprof" ) {
  if (tokens.size() < 6) { 
    cout << "Usage: projprof nomobj expx expy expwt expcut nomprof opt" << endl;
    return(0);
    }
  string opt = "n";
  if (tokens.size() > 6)  opt = tokens[6];

  srvo->ProjectHProf(tokens[0],tokens[1],tokens[2], tokens[3], tokens[4], tokens[5], opt);
  }

else if (kw == "fillnt" ) {
  if (tokens.size() < 6) { 
    cout << "Usage: fillnt nameobj expx expy expz expt expcut [ntname]" << endl;
    return(0);
    }
  if (tokens.size() < 7)  tokens.push_back("");
  srvo->FillNT(tokens[0],tokens[1],tokens[2], tokens[3], tokens[4], tokens[5], tokens[6] );
  }

else if (kw == "ntloop" ) {
  if (tokens.size() < 3) { 
    cout << "Usage: ntloop nameobj fname funcname [ntname [N1 N2] ]" << endl;
    return(0);
    }
  if (tokens.size() < 4)  tokens.push_back("");
  if (tokens[3] == "!") tokens[3] = "";
  int nl1 = -1;
  int nl2 = -1;
  if (tokens.size() > 5) { 
    nl1 = atoi(tokens[4].c_str()); 
    nl2 = atoi(tokens[5].c_str());
    }
  srvo->FillNTFrCFile(tokens[0],tokens[1], tokens[2], tokens[3], nl1, nl2);
  }

else if (kw == "ntexpcfile" ) {
  if (tokens.size() < 3) { 
    cout << "Usage: ntexpcfile nameobj fname funcname" << endl;
    return(0);
    }
  srvo->PrepareNTExpressionCFile(tokens[0],tokens[1], tokens[2]);
  }

else if (kw == "fillvec" ) {
  if (tokens.size() < 4) { 
    cout << "Usage: fillvec nameobj expx expcut nomvec opt" << endl;
    return(0);
    }
  string opt = "n";
  if (tokens.size() > 4)  opt = tokens[4];
  srvo->FillVect(tokens[0],tokens[1],tokens[2], tokens[3], opt);
  }

else if (kw == "fillgd1" ) {
  if (tokens.size() < 5) {
    cout << "Usage: fillgd1 nomobj expx expy experry expcut nomgfd" << endl;
    return(0);
    }
  string nomgfd = "";
  if (tokens.size() > 5) nomgfd = tokens[5];
  string expy = "";
  srvo->FillGFD(tokens[0],tokens[1], expy, tokens[2], tokens[3], tokens[4],nomgfd);
  }

else if (kw == "fillgd2" ) {
  if (tokens.size() < 6) {
    cout << "Usage: fillgd2 nomobj expx expy expz experrz expcut nomgfd" << endl;
    return(0);
    }
  string nomgfd = "";
  if (tokens.size() > 6) nomgfd = tokens[6];
  srvo->FillGFD(tokens[0],tokens[1],tokens[2], tokens[3], tokens[4], tokens[5],nomgfd);
  }


// Fit 1D sur objets 1D. Egalement Fit 2D sur objets 2D.
else if (kw == "fit") {
  if (tokens.size() < 2) {
    cout <<"Usage:fit nomobj func \n"
         <<" [p:p1,...,pn s:s1,...,sn m:m1,...,mn M:M1,...,Mn o:... o:...]\n";
    return(0);
  }
  string p=""; string s=""; string m=""; string M=""; string O="";
  if (tokens.size()>2)
    for(int ip=2;ip<tokens.size();ip++) {
      if(tokens[ip].length()<=2) continue;
      const char *c = tokens[ip].c_str();
      if(c[1]!=':') continue;
      if(c[0]=='p')      p=c+2;
      else if(c[0]=='s') s=c+2;
      else if(c[0]=='m') m=c+2;
      else if(c[0]=='M') M=c+2;
      else if(c[0]=='o') {O += ","; O += c+2;}
    }
  srvo->Fit12D(tokens[0],tokens[1],p,s,m,M,O);
}


else  { 
  cerr << "PIABaseExecutor::Do() Erreur - Commande " << kw << " inconuue ! " << endl;    
  return(-1);
  }

return(0);
}

/* --Methode-- */
void PIABaseExecutor::RegisterCommands()
{
string kw, usage;
kw = "loadmodule";
usage = "To load and initialize modules \n  Usage: loadmodule fnameso modulename";
usage += "\n  Related commands: link";  
mpiac->RegisterCommand(kw, usage, this, "External Modules");
kw = "link";
usage = "Dynamic linking of compiled user functions \n  Usage: link fnameso f1 [f2 f3]";
usage += "\n  fnameso: Shared-object file name, f1,f2,f3 : User function names ";
usage += "\n  Related commands: call loadmodule";  
mpiac->RegisterCommand(kw, usage, this, "External Modules");
kw = "call";
usage = "Dynamically linked user function call \n Usage: call userf [arg1 arg2 ...]";
usage += "\n  User function : f(vector<string>& args)";
usage += "\n  Related commands: link";  
mpiac->RegisterCommand(kw, usage, this, "External Modules");

kw = "zone";
usage = "To Divide the Graphic window \n  Usage: zone nx ny";
mpiac->RegisterCommand(kw, usage, this, "Graphics");
kw = "newwin";
usage = "To Create a New Graphic window, with zones \n  Usage: newwin nx ny";
mpiac->RegisterCommand(kw, usage, this, "Graphics");
kw = "stacknext";
usage = "Displays the next widget on stack window \n  Usage: stacknext";
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "gratt";
usage = "To change default graphic options \n  Usage: gratt att_list \n";
usage += "att_list=def back to default values, Example: gratt red,circlemarker5";
usage += "\n ------------------ Graphic attribute list ------------------ \n";
usage += ">> Colors: defcol black white grey red blue green yellow magenta cyan \n";
usage += "           turquoise navyblue orange siennared purple limegreen gold \n";
usage += ">> Lines:  defline normalline thinline thickline dashedline thindashedline \n";
usage += "           thickdashedline dottedline thindottedline thickdottedline \n";
usage += ">> Fonts:  deffont normalfont boldfont italicfont smallfont smallboldfont \n";
usage += "           smallitalicfont bigfont bigboldfont bigitalicfont \n";
usage += "           hugefont  hugeboldfont hugeitalicfont \n";
usage += ">> Marker: dotmarker<T>  plusmarker<T>  crossmarker<T> circlemarker <T> \n";
usage += "           fcirclemarker<T> boxmarker<T> fboxmarker<T> trianglemarker<T> \n";
usage += "           ftrianglemarker<T>  starmarker<T>  fstarmarker<T> \n";
usage += "   with <T> = 1 3 5 7 9 , Example fboxmarker5 , plusmarker9 ... \n";
usage += ">> ColorTables: defcmap  grey32  greyinv32  colrj32  colbr32 \n";
usage += "                grey128  greyinv128  colrj128  colbr128 \n";
usage += ">> ZoomFactors: defzoom zoomx1 zoomx2 zoomx3 zoomx4 zoomx5 \n";
usage += "                               zoom/2 zoom/3 zoom/4 zoom/5 \n";
usage += ">> Axes:  stdaxes=defaxes=boxaxes  simpleaxes boxaxesgrid \n";
usage += "          fineaxes  grid=fineaxesgrid \n"; 
usage += ">> XYLimits : xylimits  -> Forces X-Y limits in 2-D plots \n";
usage += ">> DisplayWindow: next same win stack \n";
usage += "   Related commands: setxylimits";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "setxylimits";
usage = "Define 2-D plot limits \n Usage: setxylimits xmin xmax ymin ymax";
usage += "\n  Related commands: gratt";  
mpiac->RegisterCommand(kw, usage, this, "Graphics");

kw = "openfits";
usage = "Loads a FITS file into an Image<T> \n Usage: openfits filename";
usage += "\n  Related commands: savefits openppf";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");
kw = "savefits";
usage = "Save an object into a FITS file \n Usage: savefits nameobj filename";
usage += "\n  Related commands: openfits saveall";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");
kw = "openppf";
usage = "Reads all objects from a PPF file \n Usage: openppf filename";
usage += "\n  Related commands: saveall openfits";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");
kw = "saveobjs";
usage = "Saves objects with names matching a pattern (x?y*) into a PPF file \n";
usage += "Usage: saveall nameobjpattern filename";
usage += "\n  Related commands: saveall openppf savefits";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");
kw = "saveall";
usage = "Saves all objects into a PPF file \n Usage: saveall filename";
usage += "\n  Related commands: saveobj openppf savefits";  
mpiac->RegisterCommand(kw, usage, this, "FileIO");

kw = "print";
usage = "Prints an object \n Usage: print nameobj";
mpiac->RegisterCommand(kw, usage, this, "FileIO");

kw = "mkdir";
usage = "Create a directory";
usage += "\n Usage: mkdir dirname [true]";
usage += "\n if second argument==true, the directory's KeepOld attribute is set to true";
mpiac->RegisterCommand(kw, usage, this, "Object Managment");
kw = "rmdir";
usage = "Removes an empty directory";
usage += "\n Usage: remove dirname";
mpiac->RegisterCommand(kw, usage, this, "Object Managment");
kw = "cd";
usage = "Change current directory";
usage += "\n Usage: cd [dirname]";
mpiac->RegisterCommand(kw, usage, this, "Object Managment");
kw = "pwd";
usage = "Prints current directory";
usage += "\n Usage: pwd";
mpiac->RegisterCommand(kw, usage, this, "Object Managment");
kw = "listdirs";
usage = "Prints the list of directories";
usage += "\n Usage: listdirs [patt=*] \n patt : * , ? ";
mpiac->RegisterCommand(kw, usage, this, "Object Managment");
kw = "listobjs";
usage = "Prints the list of objects (Alias: ls)";
 usage += "\n Usage: listobjs [patt=*] \n patt : /*/x?y* ... ";
mpiac->RegisterCommand(kw, usage, this, "Object Managment");
kw = "rename";
usage = "Rename an object (Alias: mv) \n Usage: rename nameobj namenew";
usage += "\n  Related commands: del delobjs";  
mpiac->RegisterCommand(kw, usage, this, "Object Managment");
kw = "del";
usage = "Deletes an object (Alias: rm) \n Usage: del nameobj";
usage += "\n  Related commands: delobjs  rename";  
mpiac->RegisterCommand(kw, usage, this, "Object Managment");
kw = "delobjs";
usage = "Delete a set of objects with names matching a pattern (x?y*)";
usage += "\n Usage: delobjs nameobjpattern \n";
usage += "\n  Related commands: del rename";  
mpiac->RegisterCommand(kw, usage, this, "Object Managment");

kw = "newh1d";
usage = "Creates a 1D histogramm \n Usage: newh1d name xmin xmax nbin";
usage += "\n  Related commands: newh2d  newprof  newgfd ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newh2d";
usage = "Creates a 2D histogramm \n Usage: newh2d name xmin xmax nbinx ymin ymax nbiny";
usage += "\n  Related commands: newh1d  newprof  newgfd ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newprof";
usage = "Creates a profile histogramm \n Usage: newprof name xmin xmax nbin [ymin ymax]";
usage += "\n  Related commands: newh1d  newh2d newgfd ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newgfd";
usage = "Creates GeneralFit Data object \n Usage: newgfd nvar nalloc [errx(0/1)]";
usage += "\n  Related commands: newh1d  newh2d  newprof ";  
mpiac->RegisterCommand(kw, usage, this, "Objects");
kw = "newvec";
usage = "Creates (and fills) a vector \n Usage: newvec name size [f(i) [dopt] ] ";
usage += "\n  Related commands: newmtx";  
mpiac->RegisterCommand(kw, usage, this, "Objets");
kw = "newmtx";
usage = "Creates (and fills) a matrix \n Usage: newvec name sizeX sizeY [f(i,j) [dopt] ] ";
usage += "\n  Related commands: newvec";  
mpiac->RegisterCommand(kw, usage, this, "Objets");

kw = "disp";
usage = "Displays an object \n Usage: disp nameobj [graphic_attributes]";
usage += "\n  Related commands: surf nt2d nt3d ";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "imag";
usage = "Displays an object as an image \n Usage: imag nameobj [graphic_attributes]";
usage += "\n  Related commands: disp surf nt2d nt3d ";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "surf";
usage = "Displays an object as a 3D surface \n Usage: surf nameobj [graphic_attributes]";
usage += "\n  Related commands: disp nt2d nt3d ";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "nt2d";
usage = "Displays Points (X-Y) [with error-bars] from an NTuple ";
usage += "\n Usage : nt2d nameobj varx vary [errx erry] [graphic_attributes]";
usage += "\n  Related commands: disp  surf  nt2dw nt3d  gfd2d ";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "nt2dw";
usage = "Displays Points (X-Y) with weight [with error-bars] from an NTuple ";
usage += "\n Usage : nt2d nameobj varx vary varz [errx erry] [graphic_attributes]";
usage += "\n  Related commands: disp  surf  nt2d nt3d  gfd2d ";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "nt3d";
usage = "Displays 3D-Points (X-Y-Z) [with error-bars] from an NTuple ";
usage += "\n Usage : nt3d nameobj varx vary varz [errx erry errz] [graphic_attributes]";
usage += "\n  Related commands: disp  surf  nt2d nt2dw  gfd3d ";  
usage += "\n  Related commands: disp  surf  nt2d nt2dw ";  
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");

// Ceci est maintenant obsolete, on garde pour info.
kw = "gfd2d";
usage = "Displays Points (X-Y) with error-bars from a GeneralFit Data ";
usage += "\n Usage : gfd2d nameobj numvarx erreur=(x y xy) [graphic_attributes]";
usage += "\n  Related commands: gfd3d nt2d nt3d ";
usage += "\n  ----- OBSOLETE: utilisez nt2d -----";
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");
kw = "gfd3d";
usage = "Displays 3D-Points (X-Y-Z) with error-bars from a GeneralFit Data ";
usage += "\n Usage : gfd3d nameobj numvarx numvary erreur=(x y z xy xz yz xyz) [graphic_attributes]";
usage += "\n  Related commands: gfd2d nt2d nt3d ";  
usage += "\n  ----- OBSOLETE: utilisez nt3d -----";
mpiac->RegisterCommand(kw, usage, this, "Obj. Display");

kw = "func";
usage = "Displays a function y=f(x) (Fills a vector with function values)";
usage += "\n Usage: func f(x) xmin xmax npt [graphic_attributes]";
usage += "\n  Related commands: funcff func2d func2dff ";  
mpiac->RegisterCommand(kw, usage, this, "Func Plot");
kw = "funcff";
usage = "Displays a function y=f(x) from a C-file (Fills a vector with function values)";
usage += "\n Usage: funcff C-FileName FunctionName xmin xmax npt [graphic_attributes]";
usage += "\n  Related commands: func func2d func2dff ";  
mpiac->RegisterCommand(kw, usage, this, "Func Plot");
kw = "func2d";
usage = "Displays a function z=f(x,y) (Fills a matrix with function values)";
usage += "\n Usage: func2d f(x,y) xmin xmax nptx ymin ymax npty [graphic_attributes]";
usage += "\n  Related commands: func";  
mpiac->RegisterCommand(kw, usage, this, "Func Plot");
kw = "func2dff";
usage = "Displays a function z=f(x,y) from a C-file (Fills a matrix with function values)";
usage += "\n Usage: func2dff C-FileName FunctionName xmin xmax nptx ymin ymax npty [graphic_attributes]";
usage += "\n  Related commands: func funcff func2d ";  
mpiac->RegisterCommand(kw, usage, this, "Func Plot");

kw = "plot2d";
usage = "Plots (2D) Y=g(Object) vs. X=f(Object) --- Object Variable names (double) :";
usage += "\nNTuple varnames - Histo1D/HProf: i,x,val,err - Histo2D: i,j,x,y,val,err";
usage += "\nVector: i,val - Matrix: i,j,val - Image: x=i,y=j, pix=val";
usage += "\n Usage: plot2d nameobj f_X() g_Y() [ f_ErrX() f_ErrY() ] f_Cut() [graphic_attributes]";
usage += "\n  Related commands: plot2dw plot3d  projh1d  projh2d  projprof  fillnt fillvec fillgd1 ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "plot2dw";
usage = "Plots (2D) Y=g(Object) vs. X=f(Object) with Weight W=h(Object) ";
usage += "\n Usage: plot2dw nameobj f_X() g_Y() h_Wt() Cut() [graphic_attributes]";
usage += "\n  Related commands: plot2d  projh1d  projh2d  projprof  fillnt fillvec ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "plot3d";
usage = "Plots (3D) Z=h(Object) vs. Y=g(Object) vs. X=f(Object) vs ";
usage += "\n Usage: plot3d nameobj f_X() g_Y() h_Z() Cut() [graphic_attributes]";
usage += "\n  Related commands: plot2d plot2dw projh1d  projh2d  projprof  fillnt fillvec ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

kw = "projh1d";
usage = "Projects X=f(Object) with weight WT=h(Object) into a 1D histogram ";
usage += "\n Usage: projh1d nameobj f_X() h_WT() Cut() nameh1d [graphic_attributes]";
usage += "\n   Histo1D nameh1d is created if necessary ";
usage += "\n  Related commands: plot2d  projh2d  projprof fillnt  fillvec ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "projh2d";
usage = "Projects (X=f(Object),Y=g(Object)) with weight WT=h(Object) into a 2D histogram ";
usage += "\n Usage: projh2d nameobj f_X() g_Y() h_WT() Cut() nameh2d [graphic_attributes]";
usage += "\n   Histo2D nameh2d is created if necessary ";
usage += "\n  Related commands: plot2d  projh1d projprof ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "projprof";
usage = "Projects (X=f(Object),Y=g(Object)) with weight WT=h(Object) into a profile histogram ";
usage += "\n Usage: projh2d nameobj f_X() g_Y() h_WT() Cut() nameprof [graphic_attributes]";
usage += "\n   HProf nameprof is created if necessary ";
usage += "\n  Related commands: plot2d  projh2d  ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

kw = "fillnt";
usage = "Creates and Fills an NTuple(x,y,z,t) with (X=f(Object),Y=g(...),Z=h(...),T=k(...))";
usage += "\n Usage: fillnt nameobj f_X() g_Y() h_Z() k_T() Cut() nameNt";
usage += "\n  Related commands: ntloop plot2d projh1d projh2d projprof ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "ntloop";
usage = "Loops over an Object NTupleInterface calling a function from a C-file \n";
usage += "and optionaly fills an NTuple(x,y,z,t) with (X=f(Object),Y=g(...),Z=h(...),T=k(...))";
usage += "\n Usage: ntloop nameobj CFileName FuncName [NtupleName [N1 N2] ]";
usage += "\n Or:    ntloop nameobj CFileName FuncName ! N1 N2 ";
usage += "\n  Related commands: ntexpcfile fillnt";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "ntexpcfile";
usage = "Creates a C-File with declarations suitable to be used for ntloop";
usage += "\n Usage: ntexpcfile nameobj CFileName FuncName ";
usage += "\n  Related commands: ntloop";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

kw = "fillvec";
usage = "Creates and Fills a Vector with X=f(Object)";
usage += "\n Usage: fillvec nameobj f_X() Cut() nameVec [graphic_attributes]";
usage += "\n  Related commands: plot2d  projh1d  fillnt ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "fillgd1";
usage = "Creates and Fills a GeneralFitData with (X=f(Object), Y=g(...), ErrY=h(...))";
usage += "\n Usage: fillgd1 nameobj f_X() g_Y() h_ErrY() Cut() nameGfd";
usage += "\n  Related commands: plot2d  fillnt ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");
kw = "fillgd2";
usage = "Creates and Fills a GeneralFitData with (X=f(Object), Y=g(...), Z=h(...)) ErrZ=k(...)";
usage += "\n Usage: fillgd1 nameobj f_X() g_Y() h_Z() k_ErrZ() Cut() nameGfd";
usage += "\n  Related commands: plot2d  fillgd2 ";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

kw = "fit";
usage = "Fitting function to DataObjects (Histo, Histo2D, Vector, ...)";
usage += "\n Usage: fit nomobj func [Options]";
usage += "\n [p:p1,...,pn s:s1,...,sn m:m1,...,mn M:M1,...,Mn o:... o:...]";
mpiac->RegisterCommand(kw, usage, this, "Expr. Plotting");

}

/* --Methode-- */
int PIABaseExecutor::LinkUserFuncs(string& fnameso, string& func1, string& func2, string& func3)
//                          string& func4, string& func5)
{
string cmd;

if (dynlink) delete dynlink;    dynlink = NULL;
usfmap.clear();

dynlink = new PDynLinkMgr(fnameso, true);
if (dynlink == NULL) { 
  string sn = fnameso; 
  cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur ouverture SO " << sn << endl; 
  return(2); 
  }

int nok=0;
// on utilise donc des DlFunction  (Reza 20/08/98)  voir commentaire ds .h (pb g++)
// DlUserProcFunction f = NULL;
DlFunction f = NULL;
if ((func1.length() < 1) || (func1 == "-") || (func1 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func1.c_str());
f = dynlink->GetFunction(func1);
if (f) { nok++;  usfmap[func1] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func1 << endl;

if ((func2.length() < 1) || (func2 == "-") || (func2 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func2.c_str());
f = dynlink->GetFunction(func2);
if (f) { nok++;  usfmap[func2] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func2 << endl;

if ((func3.length() < 1) || (func3 == "-") || (func3 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func3.c_str());
f = dynlink->GetFunction(func3);
if (f) { nok++;  usfmap[func3] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func3 << endl;

/*  Pb compile g++ 2.7.2 
if ((func4.length() < 1) || (func4 == "-") || (func4 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func4.c_str());
f = dynlink->GetFunction(func4);
if (f) { nok++;  usfmap[func4] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func4 << endl;

if ((func5.length() < 1) || (func5 == "-") || (func5 == ".") )  goto fin;
// f = (DlUserProcFunction)  dlsym(dlhandle, func5.c_str());
f = dynlink->GetFunction(func5);
if (f) { nok++;  usfmap[func5] = f; }
else cerr << "PIABaseExecutor/LinkUserFuncs_Erreur: Erreur linking " << func5 << endl;
*/
fin:
if (nok < 1) { if (dynlink) delete dynlink;    dynlink = NULL;  return(3); }
else return(0);
}

