#ifndef PISTDWDGMOSX_H_SEEN
#define PISTDWDGMOSX_H_SEEN

#include "piwdgmosx.h"
#include "pistdwdggen.h"
#include "PIContainerQuartz.h"

// #include <PIButtonQuartz.h>

class PILabelQuartz : public PILabelGen
{
public:
	PILabelQuartz(PIContainerGen* par, const char* nom,int sx=10, int sy=10, int px=0, int py=0);
	
	~PILabelQuartz();
	
	virtual void SetLabel(string const& sLabel);
	
protected:
	CFStringRef cfsrLabel;
};

class PITextQuartz : public PITextGen
{
public:
	PITextQuartz(PIContainerGen *par, const char *nom, 
				int sx=10, int sy=10, int px=0, int py=0);

	PITextQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx=100, int sy=100, int px=0, int py=0);
  virtual           ~PITextQuartz();
  virtual void      SetText(string const&);
  virtual string    GetText() const;

  virtual void      SetMutiLineMode(bool mlm=false);
  virtual void      SetTextEditable(bool te=true);

  virtual void		SetMsg(PIMessage msg=0);
  	
protected:
	CFStringRef unicodeText;
};


class PIHITextViewQuartz : public PITextGen
{
public:
	PIHITextViewQuartz(PIContainerGen *par, const char *nom, 
				int sx=10, int sy=10, int px=0, int py=0);

	PIHITextViewQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx=100, int sy=100, int px=0, int py=0);
  virtual           ~PIHITextViewQuartz();
  virtual void      SetText(string const&);
  virtual string    GetText() const;

  virtual void      SetMutiLineMode(bool mlm=false);
  virtual void      SetTextEditable(bool te=true);

  virtual void		SetMsg(PIMessage msg=0);
  	
protected:
	UniChar* uniChars;
	CFIndex textLength;
	HIViewRef outTextView;
	HIRect hiRect;
	ControlRef fUserPane;
	Rect userPaneRect;
};



typedef PILabelQuartz PILabel;
typedef PITextQuartz PIText;
typedef PIHITextViewQuartz PITextView;

#endif