/*
 *  PIControl.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on Wed Apr 07 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include "PIControl.h"
#include "pistdwdggen.h"
#include "PIContainerQuartz.h"

PIControl::PIControl(PIContainerGen *par, const char *nom,int sx, int sy, int px, int py)
:PIWdgQuartz(par, nom, sx, sy, px, py) 
{
	wParent = ((PIContainer *)par)->GetWindowPtr();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
    contH = NULL;
}

PIControl::~PIControl()
{

}

void PIControl::SetSize(int sx, int sy)
{
    SizeControl (contH, sx, sy);
    return;
}

void PIControl::SetPos(int px, int py)
{
    MoveControl (contH, px, py);
    return;
}

void PIControl::Manage()
{
    return;	
}

void PIControl::UnManage()
{
    return;
}

bool PIControl::IfManaged()
{
    return true;
}
 
bool PIControl::IsVisible()
{
    return (IsControlVisible(contH));
}

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
void PIControl::Refresh()
{
    return (Draw1Control(contH));
}

//  Pour rendre un composant graphique (PIWdg) sensible/insensible 
void PIControl::SetSensitive()
{
    EnableControl (contH);
    return;
}

void PIControl::SetUnSensitive()
{
    DisableControl (contH);
    return;
}

bool PIControl::IfSensitive()
{
    return (IsControlActive(contH));
}

//  Gestion des EventHandler
void PIControl::AddDrawHandler(PIEventHandler* drwh, bool ad)
{
/*
    InstallControlEventHandler (contH, 
                                NewEventHandlerUPP (drwh),
                                GetEventTypeCount(drawEvents),
                                drawEvents,
                                contH,
                                NULL);
*/
    return;
}

void PIControl::RemoveDrawHandler(PIEventHandler* drwh)
{
    RemoveEventHandler(drwh);
    return;
}

void PIControl::AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad)
{
/*
    InstallControlEventHandler (contH, 
                                NewEventHandlerUPP (evh),
                                GetEventTypeCount(evtmask),
                                evtmask,
                                contH,
                                NULL);
*/
    return;
}

void PIControl::RemoveEventHandler(PIEventHandler* evh)
{
    RemoveEventHandler(evh);
    return;
}


// En public, pour permettre l'acces depuis call-back Xt
void PIControl::CallDrawHandlers(int x0, int y0, int dx, int dy)
{
    return;
}

void PIControl::CallEventHandlers(unsigned long evt, int px, int py,
                                    int k, int km, unsigned long tm)
{
    return;
}

