/*
 *  PIApplQuartz.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on Wed Jun 09 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#include "PIApplQuartz.h"

static OSErr QuitAppleEventHandler(const AppleEvent *appleEvt, AppleEvent* reply, UInt32 refcon);


PIApplicationQuartz::PIApplicationQuartz()
:PIApplicationGen()
{
    OSErr	err;
   
    err = AEInstallEventHandler( kCoreEventClass, kAEQuitApplication, 
								NewAEEventHandlerUPP((AEEventHandlerProcPtr)QuitAppleEventHandler), 
								0, false );
    if (err != noErr)
        ExitToShell();
        
    menubar = new PIMenubar(this, "DefMenubar");
}


PIApplicationQuartz::PIApplicationQuartz(int width, int height,int narg, char *arg[])
:PIApplicationGen()
{
  OSErr	err;
  
  err = AEInstallEventHandler( kCoreEventClass, kAEQuitApplication, 
							NewAEEventHandlerUPP((AEEventHandlerProcPtr)QuitAppleEventHandler),
							0, false );
  if (err != noErr)
        ExitToShell();
		
  topcont = new PIContainer((PIContainer*)this,(const char*)"Main Window",width,height,50,50);
  menubar = new PIMenubar(this, "DefMenubar");
  mainWindow = new PIWindow(this,(const char*)"Main Window",PIWK_normal,width,height,50,50);
  mainWindow->Refresh();
}

PIApplicationQuartz::~PIApplicationQuartz()
{
}


void PIApplicationQuartz::Run()
{
    RunApplicationEventLoop ();
    return;
}

void PIApplicationQuartz::Stop()
{
    ExitToShell ();
    return;
}

void PIApplicationQuartz::SetReady()
{
mState = kReadyState;
}

/* There's no default window in MacOSX */
void PIApplicationQuartz::PrefCompSize(int& szx, int& szy)
{
    return;
}

void PIApplicationQuartz::ScreenSize(int& szx, int& szy)
{
    return;
}

void PIApplicationQuartz::ScreenSizeMM(int& szx, int& szy)
{
    return;
}

void PIApplicationQuartz::ScreenResolution(int& resolx, int& resoly)
{
    return;
}

static OSErr QuitAppleEventHandler( const AppleEvent *appleEvt, AppleEvent* reply, UInt32 refcon )
{
    ExitToShell ();
    return noErr;
}


