#include <stdlib.h>
#include <stdio.h>
#include <iostream>


#include "sopnamsp.h"
#include "pisysdep.h"

#include PIAPP_H
#include PIMENU_H 
#include PISTDWDG_H 

//  ----- Declaration de notre classe PIApplication (PITApp) -------
//  ----------- PIApplication (PITApp) class declaration -----------

class PITApp : public PIApplication {
public:
     PITApp(int narg=0, char* arg[]=NULL);
     ~PITApp();
     virtual void   Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

private :
  PIMenu * m;
  PIText * txt;
};



/* ........................................................... */
/*               Classe PITApp (methodes)                      */
/* ........................................................... */


/* --Methode-- */
PITApp::PITApp(int narg, char* arg[])
: PIApplication(260, 150, narg, arg)

{
puts("xp0: Debut PITApp::PITApp(int narg, char* arg[]) ");
//  Menus, les numeros ds AppendItem sont les numeros de messages
//  qui seront passes a Process() et permettent d'identifier l'action

//  Creation du menu  
m = new PIMenu(Menubar(),"Fichier");
m->AppendItem("Get Text", 10101);
m->AppendItem("Exit", 10105);
// On accroche le menu au Menubar
AppendMenu(m);

// Creation d'une zone texte multi-lignes editable
txt = new PIText(MainWin(), "mltext", 250, 140, 5, 5);
txt->SetMutiLineMode(true);
txt->SetTextEditable(true);
txt->SetText("");

SetReady();
}

/* --Methode-- */
PITApp::~PITApp()
{
delete m; 
delete txt; 
}  

/* --Methode-- */
void PITApp::Process(PIMessage msg, PIMsgHandler* sender, void* /*data*/)
{
// Gestion des actions en fonctions des messages
switch(UserMsg(msg))    {

    case 10101:     // On recupere le texte du PIText
      cout << "\n PITApp::Process( 10101, ...) - PIText content : " << endl;
      cout << txt->GetText() << endl;
      break;

    case 10105:          // Sortie d'application
      Stop();
      break;

    default :
     break;
    
  }
return;
}


// ................................................................
//                   programme principal 
// ................................................................

int main(int narg, char *arg[])
{
if ( (narg > 1) && (strcmp(arg[1],"-h") == 0) ) {
  printf("xp0 : simple PI example program \n");
  printf("  Usage : xp0 [Xt options] \n");
  exit(1);
  }
//  Creation de l'objet application et appel de Run()
puts("xp0: Creation objet Application PITApp ");
PITApp * app = new PITApp(narg, arg);
puts("appel de Application.Run() ... ");
app->Run();

delete app;
exit(0);
}


