/*
 *  pistdwdgmosx.cpp
 *  PI
 *
 *  Created by Bruno MANSOUX on 24/08/07.
 *  Copyright 2007 __MyCompanyName__. All rights reserved.
 *
 */

#include "pistdwdgmosx.h"

vector<PIWdg*> vpiwdg;

static void CommonControlActionCallback (ControlRef theControl, ControlPartCode partCode);


/* ========== PILabelQuartz ========== */

/* --Methode-- */
PILabelQuartz::PILabelQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PILabelGen(par, nom, sx, sy, px, py)
{
	OSStatus err;
	
	string sNom(nom);
	wParent = ((PIContainer *)par)->GetWindowPtr();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
	cfsrLabel = CFStringCreateWithCString(kCFAllocatorDefault,nom,kCFStringEncodingMacRoman);
	err = CreateStaticTextControl (wParent, &wdgRect, cfsrLabel, NULL, &contH);
}

/* --Methode-- */
PILabelQuartz::~PILabelQuartz()
{
}

/* --Methode-- */
void PILabelQuartz::SetLabel(string const& sLabel)
{
	OSStatus err;
	
	cfsrLabel = CFStringCreateWithCString(kCFAllocatorDefault,sLabel.c_str(),kCFStringEncodingMacRoman);
	SetPortWindowPort(wParent);

	err = SetControlData (contH,0,kControlEditTextCFStringTag,sizeof(cfsrLabel),(Ptr)&cfsrLabel);

	return;
}


/* ========== PITextQuartz ========== */

/* --Methode-- */
PITextQuartz::PITextQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
	wParent = ((PIContainer *)par)->GetWindowPtr();
    SetRect(&wdgRect,px,py,px+sx,py+sy);
}

/* --Methode-- */
PITextQuartz::PITextQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx, int sy, int px, int py)
: PITextGen(par, nom, vsb, hsb, sx, sy, px, py)
{
}

/* --Methode-- */
PITextQuartz::~PITextQuartz()
{
}


/* --Methode-- */
void PITextQuartz::SetText(string const& s)
{	
	OSStatus err;
	
	unicodeText = CFStringCreateWithCString (NULL,(char *)s.c_str(), kCFStringEncodingMacRoman);
	err = CreateEditUnicodeTextControl (wParent,&wdgRect,unicodeText,false,NULL,&contH);

	return;
}

/* --Methode-- */
string PITextQuartz::GetText() const
{
	char* cText;
	
	cText = (char *)CFStringGetCStringPtr(unicodeText,kCFStringEncodingMacRoman);	
	string sText(cText);	
	return (sText);
}


/* --Methode-- */
void PITextQuartz::SetMutiLineMode(bool mlm)
{
	return;
}


/* --Methode-- */
void PITextQuartz::SetTextEditable(bool te)
{
	if (te == false)
		DeactivateControl (contH);

	return;
}


/* --Methode-- */
void PITextQuartz::SetMsg(PIMessage msg)
{

}


/* ========== PIHITextViewQuartz ========== */

/* --Methode-- */
PIHITextViewQuartz::PIHITextViewQuartz(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
	OSStatus err;
	HIRect	hiRect; // = { { 0, 0 }, { 100, 100 } };
	int ox,oy,fx,fy;
	int mx,my;
	wParent = ((PIContainer *)par)->GetWindowPtr();
	mx = sx/50;
	my = sy/50; 
	ox = px+mx;
	oy = py+my;
	fx = px+sx-mx;
	fy = py+sy-my;
    SetRect(&wdgRect,px,py,px+sx,py+sy);

	SetRect(&userPaneRect,ox,oy,fx,fy);
	hiRect.origin.x = ox;
	hiRect.origin.y = oy;
	hiRect.size.width = fx-ox;
	hiRect.size.height = fy-oy;
	err = HITextViewCreate (&hiRect,0,0,&outTextView);
	err = CreateUserPaneControl (wParent, &userPaneRect,kControlSupportsEmbedding,&fUserPane);
	err = SetControlVisibility(fUserPane, true, true );
}

/* --Methode-- */
PIHITextViewQuartz::PIHITextViewQuartz(PIContainerGen* par, const char* nom, bool vsb, bool hsb,
         		     int sx, int sy, int px, int py)
: PITextGen(par, nom, vsb, hsb, sx, sy, px, py)
{
}

/* --Methode-- */
PIHITextViewQuartz::~PIHITextViewQuartz()
{
}


/* --Methode-- */
void PIHITextViewQuartz::SetText(string const& s)
{	
	OSStatus err;
	CFStringRef cfsrText;
	
	cfsrText = CFStringCreateWithCString (NULL,(char *)s.c_str(), kCFStringEncodingMacRoman);

	TXNObject txn = HITextViewGetTXNObject(outTextView);
	textLength = CFStringGetLength(cfsrText);
	uniChars = (UniChar*) malloc( sizeof( UniChar ) * textLength );
	CFStringGetCharacters(cfsrText, CFRangeMake( 0, textLength ), uniChars );
	err = TXNSetData(txn,kTXNUnicodeTextData, uniChars, textLength * sizeof( UniChar ), 0, 0 );
	err = HIViewAddSubview (fUserPane, outTextView);
	HIViewPlaceInSuperviewAt (outTextView,10,10);
	ShowControl (fUserPane);
	err = HIViewSetVisible (outTextView, true);

	return;
}

/* --Methode-- */
string PIHITextViewQuartz::GetText() const
{
	CFStringRef str;
	char* cText;

	GetControlData(outTextView, kControlEditTextPart, kControlEditTextCFStringTag, sizeof(str),&str,NULL);
	cText = (char *)CFStringGetCStringPtr(str,kCFStringEncodingMacRoman);
	/*
	textLength = CFStringGetLength(str);
	uniChars = (UniChar*) realloc( sizeof( UniChar ) * textLength );
	CFStringGetCharacters(str, CFRangeMake( 0, textLength ), uniChars );
	*/
	
	string sText(cText);	
	return (sText);
}


/* --Methode-- */
void PIHITextViewQuartz::SetMutiLineMode(bool mlm)
{
	return;
}


/* --Methode-- */
void PIHITextViewQuartz::SetTextEditable(bool te)
{
	return;
}


/* --Methode-- */
void PIHITextViewQuartz::SetMsg(PIMessage msg)
{

}

/* ========== PIButtonQuartz ========== */

EventTypeSpec controlEvents[] = {{kEventClassControl, kEventControlHit}};

PIButtonQuartz::PIButtonQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py)
:PIButtonGen(par,nom,msg,sx,sy,px,py)
{
	wParent = ((PIContainer *)par)->GetWindowPtr();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);

    CreatePushButtonControl (par->GetWindowPtr(),&wdgRect,title,&contH);
    SetControlTitleWithCFString (contH, title);
	_actionProc = NewControlActionUPP (CommonControlActionCallback);
	SetControlAction (contH, _actionProc);
	vpiwdg.push_back(this);
}


PIButtonQuartz::~PIButtonQuartz()
{
}

void PIButtonQuartz::ActivatePress(bool acp)
{
	return;
}	

void PIButtonQuartz::SetLabel(string const& sText)
{
    title = CFStringCreateWithCString (NULL, sText.c_str(), kCFStringEncodingMacRoman);
	SetControlTitleWithCFString(contH,title);
	return;
}

static void CommonControlActionCallback (ControlRef theControl, ControlPartCode partCode)
{
	vector<PIWdg*>::iterator it;
	for(it = vpiwdg.begin(); it != vpiwdg.end(); it++)
        {
            if (((*it)->GetControlRef())==theControl)
            {
                (*it)->Send((*it)->Msg(),PIMsg_Click,NULL);
				printf ("click : %d \n",(int)(*it)->Msg());
                break;
            }
        }
}


/* ========== PICheckBoxQuartz ========== */

PICheckBoxQuartz::PICheckBoxQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py)
:PICheckBoxGen(par,nom,msg,sx,sy,px,py)
{
	wParent = ((PIContainer *)par)->GetWindowPtr();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
	_state = 1;
    CreateCheckBoxControl (par->GetWindowPtr(),&wdgRect,title,_state,TRUE,&contH);
    SetControlTitleWithCFString (contH, title);
	_actionProc = NewControlActionUPP (CommonControlActionCallback);
	SetControlAction (contH, _actionProc);
	vpiwdg.push_back(this);
}


PICheckBoxQuartz::~PICheckBoxQuartz()
{
}

void PICheckBoxQuartz::SetState(bool acp)
{
	_state = acp;
	return;
}

bool PICheckBoxQuartz::GetState()
{
	return _state;
}

/* ========== PIRadioQuartz ========== */

PIRadioQuartz::PIRadioQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py,
							int initialValue)
:PIWdg(par,nom,sx,sy,px,py)
{
	SetMsg(msg);
	wParent = ((PIContainer *)par)->GetWindowPtr();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
    CreateRadioButtonControl (par->GetWindowPtr(),&wdgRect,title,initialValue,FALSE,&contH);
    SetControlTitleWithCFString (contH, title);
	_actionProc = NewControlActionUPP (CommonControlActionCallback);
	SetControlAction (contH, _actionProc);
	vpiwdg.push_back(this);
}

PIRadioQuartz::~PIRadioQuartz()
{
}

/* ========== PIRadioGroupQuartz ========== */

PIRadioGroupQuartz::PIRadioGroupQuartz(PIContainerQuartz *par,const char *nom, PIMessage msg,int sx, int sy, int px, int py)
:PIWdg(par,nom,sx,sy,px,py)
{
	SetMsg(msg);
	wParent = ((PIContainer *)par)->GetWindowPtr();
	SetPortWindowPort(wParent);
    SetRect(&wdgRect,px,py,px+sx,py+sy);
    OSErr error;
	error = CreateRadioGroupControl (par->GetWindowPtr(),&wdgRect,&contH);
	_state = 0;
}

void PIRadioGroupQuartz::AddRadioButton(PIRadio* piRadio)
{
	OSErr error;
	error = EmbedControl(piRadio->GetControlRef(),contH);
		
	return;
}

PIRadioGroupQuartz::~PIRadioGroupQuartz()
{
}

