static double D = 4.;  // Taille du reflecteur (en m)
static double Lambda = 0.4;  // Longueur d'onde en m 
static double PiDoL = M_PI*D/Lambda;  // Pi * D / Lambda

static double DELX = D; // Separation des reflecteurs

// static double DELX = Lambda/2.; // Separation des reflecteurs


double LobeSquare(double tet) 
{
if (fabs(tet) < 1.e-9) return 1.;
double x = tet*PiDoL;
return sin(x)/x;
}

double LobeGauss(double tet) 
{
double x = tet*PiDoL;
 return exp(-x*x/10.);
}


double LobeDipoleDemiLambda(double tet) 
{
 double L = 0.5; 
 double trad = acos(sin(tet));
 double pil = M_PI*L;
 double st = sin(trad), ct = cos(trad);
 // L'antenne standing-wave
 double v = 0.;
 if(fabs(st)<1e-3) {
   if(ct>0.) {  // theta ~= 0
     v = pil*sin(pil)*trad/2.;  /* v *= v; */
   } else {  // theta ~= 180
     v = pil*sin(pil)*(trad-M_PI)/2.;  /* v *= v; */
   }
 } else {
   v = (cos(pil*ct) - cos(pil))/st;  /* v *= v; */
 }

 //  cout << " teta= " << tet << " trad= " << trad << " v=" << v << endl;
 return v;

}


