/*    
   --- SOPHYA software - FitsIOServer module ---
   C. Magneville, 2001 
   (C) UPS+LAL IN2P3/CNRS     (C) DAPNIA-SPP/CEA 
*/
/* Interface Fits BINARY/ASCII Table     cmv 21/05/2001 */
#ifndef FBTNTINTF_H_SEEN
#define FBTNTINTF_H_SEEN

#include "machdefs.h"
#include <iostream>
#include <string.h>
#include <string>

#include "anydataobj.h"
#include "ntupintf.h"
#include "FitsIO/fitsio.h"

#include <vector>

namespace SOPHYA {

class FitsBTNtuIntf : public AnyDataObj, public NTupleInterface {
public:
  FitsBTNtuIntf(string fname,int ihdu=0,int_4 blen=100,int_4 bsens=1,uint_2 lp=0);
  FitsBTNtuIntf(char *cfname,int ihdu=0,int_4 blen=100,int_4 bsens=1,uint_2 lp=0);
  FitsBTNtuIntf(FitsBTNtuIntf& fbtnt);
  FitsBTNtuIntf();
  virtual ~FitsBTNtuIntf();

  void SetNulVal(r_8 nulval=0.) {NulVal = nulval;}
  void ChangeBuffer(int_4 blen,int_4 bsens=1);
  virtual void Print(ostream& os,int lp=1) const;
  inline  void Print(int lp=1) const {Print(cout,lp);}

  virtual sa_size_t NbLines() const ;
  virtual sa_size_t NbColumns() const ;
  virtual r_8 * GetLineD(sa_size_t  n) const ;
  virtual r_8 GetCell( sa_size_t n, sa_size_t  k) const ;
  virtual string VarList_C(const char* nomx=NULL) const ;

protected:
  inline void SetBuffer(int_4 blen=100,int_4 bsens=1)
       {BuffLen = (blen<=0)?1:blen; BuffSens = bsens;}
  void DeAllocBuff(void);
  void AllocBuff(void);
  void Init(void);
  void Delete(void);
  void printerror(int sta) const;

  string FitsFN;
  int IHdu;
  uint_2 DbgLevel;
  fitsfile *FitsPtr;
  LONGLONG NBline;
  int  NBcol;
  r_8 NulVal;
  int_4 BuffLen, BuffSens;
  mutable uint_8 NFitsRead;
  mutable LONGLONG LineDeb, LineFin;
  vector<string> ColName;
  bool* ColReadable;
  double **Buffer;
  mutable r_8 * mRet;
};

} // namespace SOPHYA
#endif    /* FBTNTINTF_H_SEEN */
