
# ----------------------------------------
# --------- File AIX_xlC_make.inc --------
#   Compilation avec xlC / AIX (IBM) 
# ------- Dec 2005-Avr 2007   ------------

#  Liste des librariries externes 
#  Pour link fortran -lf ( pas besoin de -lxlf -lxlfutil )
#  -lessl pour le BLAS IBM
SOPEXTLIBS = $(SOPEXTLIBP) $(SOPEXTLIBLIST) -lessl -lf

#  Chemin et librairie pour PI 
PIINC = 
PILIBS = -lXm -lXt -lX11 

#  Flag preprocesseur
CPPFLAGS = -DAIX -I$(SOPHYAINCP) $(PIINC)
#  Def compilateur C et flags
CC = xlc
# Replace [CNFPHFLF] by specific compilation flags below (done by configure)
#    Pour compilation en mode 64 bits : -q64 
CFLAGS = -O -g  CNFPHFLF 
#  Def compilateur C++ et flags
CXX =  xlC
#  Flag IBM xlC (Dec 2005) 
#  -qrtti=all : generate all RTTI infomation dynamic_cast + typeinfo
#  -qeh=v6 : Exception handling compatible with v6 
CXXFLAGS = -qrtti=all -qeh=v6 -O -g CNFPHFLF 
# flags specifiques pour templates repository...
# CXXTEMPFLG = -qtemplateregistry=$(SOPHYAOBJP)/templateregistry -qtemplaterecompile
CXXTEMPFLG =
#  Compilo fortran
FC = xlf CNFPHFLF 
FFLAGS =  
# Pour fabriquer les lib .a   (-X 64 pour les librairies en mode 64 bits) 
AR = ar
ARFLAGS = -rcs


#  Ordres de compilation
CCOMPILE = $(CC) $(CPPFLAGS) $(CFLAGS) -c 
CXXCOMPILE = $(CXX) $(CPPFLAGS) $(CXXFLAGS) -c 
FCCOMPILE = $(FC) $(FFLAGS) -c 

#  Extension de nom pour les librairies partagees
SLEXT = so
#  Fabrication de librairies partagees 
CMDSHLCXX = $(CXX) $(CXXFLAGS) $(CXXTEMPFLG) -brtl -qmkshrobj 


#  Liste de librairie de base, necessaire pour libsophya
SOPBASELIBS = -lpthread -lm -lc -ldl 
LIBFORT = 

# --- Chemin pour l ensemble les librairies SOPHYA , +ExtLibs, +PI
SOPHYALIBLIST = -L$(SOPHYALIBP) $(SOPMODLIBLIST)  $(SOPBASELIBS)
SOPHYAEXTLIBLIST = -L$(SOPHYALIBP) $(SOPMODLIBLIST) $(SOPEXTLIBS) $(SOPBASELIBS)
SOPHYAALLLIBLIST = -L$(SOPHYALIBP) $(SOPMODLIBLIST) $(SOPPILIBLIST) $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)

SOPHYASLBLIST = -L$(SOPHYASLBP) -lsophya  $(SOPBASELIBS)
##----
#  Il n'a pas ete possible de faire marcher les executables avec 
#  des shared-libs, linke avec d'autres librairies (lapack, cfitsio ...)
## SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lextsophya -lsophya $(SOPEXTLIBS) $(SOPBASELIBS)
## SOPHYAALLSLBLIST = -L$(SOPHYASLBP) -lPI -lextsophya -lsophya $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)
### --- Pb sur AIX quand plusieurs shared libs sont utilisees -> remplacement par -lAsophyaextPI
## SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lAsophyaextPI  $(SOPBASELIBS) $(SOPEXTLIBS) $(SOPBASELIBS)
## SOPHYAALLSLBLIST = $(SOPHYAEXTSLBLIST)
### ---------------------
## SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lsophya -L$(SOPHYALIBP) -lFitsIOServer -lIFFTW -lLinAlg -lXAstroPack $(SOPEXTLIBS) $(SOPBASELIBS)
## SOPHYAALLSLBLIST = -L$(SOPHYASLBP) -lsophya -L$(SOPHYALIBP) -lPIext -lPIGcont -lPI -lFitsIOServer -lIFFTW -lLinAlg -lXAstroPack $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)
### --- Avril 2008 : Multi shared libs semble OK maintenant
SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lextsophya -lsophya $(SOPBASELIBS)
SOPHYAALLSLBLIST = -L$(SOPHYASLBP) -lPI -lextsophya -lsophya $(SOPBASELIBS)

#  Commande de link pour creation d'executables
CXXLINK = $(CXX) $(CXXFLAGS) -brtl 
CLINK = $(CC) $(CFLAGS)
FCLINK = $(FC) $(FFLAGS)

#  Commande de link pour creation de module pouvant etre charge dynamiquement
CXXDLL = $(CXX) $(CXXFLAGS) -qmkshrobj 
