#include <LString.h>
#include "pimenumac.h"
#include <algo.h>

int PIMenuMac::lastId = 1024;
list<PIMenuMac*> PIMenuMac::sMenus;

PIMenuMac::PIMenuMac(PIMsgHandler *par, char *nom, PIMenuType pdpu) 
: PIMenuGen(par, nom, pdpu)
{
   macMenu = new LMenu(lastId, LStr255(nom));
   mMenuId = lastId;
   sMenus.push_back(this);
   lastId++;
}


PIMenuMac::~PIMenuMac()
{
  LMenuBar::GetCurrentMenuBar()->RemoveMenu(macMenu);
  sMenus.remove(this);
  delete macMenu;
}

int
PIMenuMac::FindItemByMsg(PIMessage msg)
{
  if (mMsgs.size() == 0) return -1;
  int i = find(mMsgs.begin(), mMsgs.end(), msg) - mMsgs.begin();
  return (i>=mMsgs.size()) ? -1 : i;
}

int
PIMenuMac::FindItemByName(string const& s)
{
  int n = ::CountMItems(GetMacMenuHandle());
  for (int i=0; i<n; i++)
    if (GetMenuItemText(i) == s)
      return i;
  return -1;
}


void
PIMenuMac::AppendItem(char* nom, PIMessage msg)
{
  LStr255 titre(nom);
  
  macMenu->InsertCommand(titre, -2000, 1000); // ou cmd_UseMenuItem ???
  mMsgs.push_back(msg);
}

void
PIMenuMac::CheckItemNum(int n, bool st)
{
  if (n<0 || n >= mMsgs.size()) return; // $CHECK$ exception ?
  ::CheckItem(macMenu->GetMacMenuH(), n, st);
}

void
PIMenuMac::CheckItemMsg(PIMessage msg, bool st)
{
  int i = FindItemByMsg(msg);
  if (i>=0)
    CheckItemNum(i, st);
}

void
PIMenuMac::CheckItem(char* nom, bool st)
{
  int i = FindItemByName(nom);
  if (i>=0)
    CheckItemNum(i, st);
}

void
PIMenuMac::DeleteItemNum(int n)
{
  if (n<0 || n >= mMsgs.size()) return; // $CHECK$ exception ?
  macMenu->RemoveItem(n+1);
  mMsgs.erase(mMsgs.begin()+n);
}

void
PIMenuMac::DeleteItemMsg(PIMessage msg)
{
  int i = FindItemByMsg(msg);
  if (i>=0)
    DeleteItemNum(i);
}

void
PIMenuMac::DeleteItem(char* nom)
{
  int i = FindItemByName(nom);
  if (i>=0)
    DeleteItemNum(i);
}



void
PIMenuMac::ItemSelected(int item)
{
  if (item<0 || item >= mMsgs.size()) return; // $CHECK$ exception ?
  Send(mMsgs[item], PIMsg_Click, (void*) GetMenuItemText(item).c_str());
}


void
PIMenuMac::Show()
{}

void
PIMenuMac::Show(PIWdg *w, int px, int py)
{}

void
PIMenuMac::Hide()
{}

PIMenuMac*
PIMenuMac::findMenu(int id)
{
  list<PIMenuMac*>::iterator i = sMenus.begin();
  
  while (i != sMenus.end()) {
    if ((*i)->MenuId()==id) return *i;
    i++;
  }
  
  return NULL;
}

MenuHandle
PIMenuMac::GetMacMenuHandle()
{
  return macMenu->GetMacMenuH();
}

ResIDT
PIMenuMac::GetMacMenuID()
{
  return macMenu->GetMenuID();
}


string
PIMenuMac::GetMenuItemText(int item)
{
  if (item<0 || item >= mMsgs.size()) return ""; // $CHECK$ exception ?
  MenuHandle h = GetMacMenuHandle();
  Str255 txt;
  ::GetMenuItemText(h, item+1, txt);
  p2cstr(txt);
  return (char*) txt;
}

PIMenuMac::GetMenuItemMsg(int item)
{
  if (item<0 || item >= mMsgs.size()) return -1; // $CHECK$ exception ?
  return mMsgs[item];
}



/* --Methode-- */
PIPUMenuMac::PIPUMenuMac(PIMsgHandler* par, char* nom)
: PIMenuMac(par, nom, k_PopupMenu)
{
}

/* --Methode-- */
PIPUMenuMac::~PIPUMenuMac()
{
}

void
PIPUMenuMac::Show()
{
  Point pt;
  ::GetMouse(&pt);
  ::LocalToGlobal(&pt);
  int item = ::PopUpMenuSelect(macMenu->GetMacMenuH(),pt.v,pt.h,1);
  ItemSelected(item);
}

/* --Methode-- */
PIPDMenuMac::PIPDMenuMac(PIMsgHandler* par, char* nom)
: PIMenuMac(par, nom, k_PulldownMenu)
{
}

/* --Methode-- */
PIPDMenuMac::~PIPDMenuMac()
{
}

