// toiinterpolator.h
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999


#ifndef TOIINTERPOLATOR_H
#define TOIINTERPOLATOR_H

#include <deque>

using namespace std;


class TOIInterpolator {
public:

  void enterValue(double value, long sample);
  bool   needMoreDataFor(long sample);   // need more data ? (for interp)
  bool   canGet(long sample);        // enough info ?
  double getIValue(long sample);     // can forget before sample
  double getEValue(long sample);     // can forget before sample
  bool   isNewValue(long sample);    
  long   nextSample(long sampleMin); // the next true sample available

protected:
  struct pair {
    pair(double v, long tt) : val(v), t(tt) {}
    pair() {}
    double val;
    long t;
  };
  
  deque<pair> hist;
};


#endif

