// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIImage
// Affichage d image            R. Ansari  05/95
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIIMAGE_H_SEEN
#define PIIMAGE_H_SEEN

#include "parradapter.h"

#include "pisysdep.h"

#include "pieldrw.h"
#include PIPIXMAP_H
#include PISTDWDG_H
#include PIWIN_H
#include "picmapview.h"

class PIScDrawWdg;
class PIDrwMgrMenu;

enum AutoLutType { AutoLut_No=0, AutoLut_MinMax=1, AutoLut_MeanSigma=2, 
		   AutoLut_HistoPeak=3, AutoLut_HistoTail=4, AutoLut_Range=5}; 

class PIImage : public PIPixmap
{
public:
  enum {ClassId = 5150};

//  Les methodes 

  PIImage(PIContainerGen *par, const char *nom=NULL, 
           int sx=0, int sy=0, int px=0, int py=0);
  ~PIImage();

  virtual long    kind() {return ClassId; }

//  Tableau des pixels et changement de configuration des axes 
  void SetImage(P2DArrayAdapter* pim, bool ad = true, bool refr=true);
  void ChangeAxesConfiguration(bool ix, bool iy, bool xy, bool refr=true);
  inline void   SetDrawAxesFlags(unsigned int flags=kBoxAxes | kExtTicks | kLabels)
                       { mdrw->SetAxesFlags(flags); mdrw->Refresh(); }

// Fenetre de Zoom, Vue globale, ColorMap, text, ...
  void SetZoomWin(PIPixmap * zw, bool refr=false);
  void SetGloVWin(PIPixmap * zw, bool refr=false);
  void SetCMapWin(PICMapView * cw, bool refr=false);

  void UseInfoWin(bool trw=false);
  void ShowInfo(bool si=true); 
  void ShowCursor(bool sc=true); 

  void ShowCuts(bool cuts=true);
  void SelectCuts(unsigned xyda=3);

//  Gestion du choix de LUT, facteur d agrandissement, table de couleur
  void SetLut(AutoLutType alt, double min, double max, int typlut=kLutType_Lin,
              double nsa=1., bool refr=true);
  void SetLut(LUT *clut, bool refr=true);

  void SetZoom(int zm, bool refr=true);
  void SetZoomF(float fzm, bool refr=true);
  float GetZoomF() const ;
  inline int GetZoom() const { return (zoom); }

// Changement de table de couleur
  virtual void SetColMap(PIColorMap* cmp, bool refr=true);
  virtual void SetColMapId(CMapId cmapid, bool revidx, bool refr);
  inline  void SetColMapId(CMapId cmapid, bool refr=true)
               { SetColMapId(cmapid, false, refr); }

// Positionnement image - pave
  void SetOffset(int ox, int oy, bool refr=true);
  void SetPave(int x, int y, bool refr=true, bool cent=true);

//   Methode permettant de decoder des options a partir de chaines
  virtual int  DecodeOptionString(vector<string> & opt, bool rmdecopt=true);

// Acces aux informations
  inline P2DArrayAdapter * Image() { return(img); }
  inline LUT *     Lut() { return(lut); }
  inline int XPave() { return(xpav); } ;
  inline int YPave() { return(ypav); } ;

  inline int XSzPave() { return(xszpav); }
  inline int YSzPave() { return(yszpav); }

  inline PIElDrawer* MyElDrawer() { return (mdrw); }
  inline PIElDrawer* BaseDrawer() { return (mdrw); }

// Rafraichissement des widgets auxiliaires (zoom, ...)
  void Apply(bool mw=true);

// Gestion du trace et des evenements 
  virtual void Resize();
  virtual void Draw(PIGraphic* g, int x0, int y0, int dx, int dy);

  virtual void Keyboard(int key, PIKeyModifier kmod);
  virtual void But1Press(int x, int y);
  virtual void But1Release(int x, int y);
  virtual void Ptr1Move(int x, int y);
  virtual void But2Press(int x, int y);
  virtual void But2Release(int x, int y);
  virtual void Ptr2Move(int x, int y);
  virtual void But3Press(int x, int y);
  virtual void But3Release(int x, int y);
  virtual void Ptr3Move(int x, int y);

// Gestion du copier-coller
  virtual void   PasteSelection(unsigned int typ, void *pdata, unsigned int l);
  virtual void*  ProvideSelection(unsigned int& typ, unsigned int& len);
  virtual void   SelectionLost();

//  Pour acces par les ImgTools (LutWind, ...)
  static PIImage* CurrentPIImage();
  static void SetCurrentPIImage(PIImage* curimg);

//  On definit une classe ArrayAdapter pour les donnees des coupes 
  class PIImg1DArrAdapter : public P1DArrayAdapter {
  public :
	             PIImg1DArrAdapter();
     virtual double  Value(int i);
     virtual void    SetData(P2DArrayAdapter* d, unsigned short axyda, int sz, int o1, int o2);
  protected :
    P2DArrayAdapter* data;
    unsigned short fgaxyda;
    int off1, off2;
  };

protected:
  virtual void    Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
  void ComputePixmap();
  void ComputeZoomPixmap();
  void ComputeGloVPixmap();
  void SetGloVPixmap();
  void UpdateCuts();

  void DrawCursor(PIGraphic* g);
  void DrawCursor(PIGraphic* g, int xc, int yc);
  void DrawInfo(PIGraphic* g, char* txt);

  void ShowTrTxW();

  int PosW2Img(int xiw, int yiw, int * xp, int * yp);
  int PosImg2W(int xp, int yp, int * xiw, int * yiw);

  void SetOffsetFromPave();
  void CenterPave();

// Les donnees 
  P2DArrayAdapter * img;
  bool aisup;     // Flag de suppression automatique de img
  bool curshow;
  bool winovis;   // $CHECK$ Reza A enlever si possible 17/6/96
// Tableau des pixels principal  
  PIPixColIdx pixm;
  LUT * lut;
  AutoLutType t_al;   // Si AutoLut et le type lors du dernier appel a SetLut()
  double min_al, max_al, ns_al; // Parametres nsa, min et max lors  du dernier appel a SetLut()
  int offx, offy;
  PIElDrawer* mdrw;
// Fenetre de zoom
  int zoom;
  PIPixmap * zow;
  PIPixColIdx zpixm;
// Fenetre pour vue globale de l'image   
  int zmgv;
  PIPixmap * gvw;
  PIPixColIdx gpixm;
  PIElDrawer* gvdrw;
// Fenetre d'affichage du ColMap
  PICMapView* cmvw;
// Fenetre/champ de texte
  PILabel * trtlb;
  PIWindow * trtw;
  bool ustrtw, atrtw;
  bool showinfo;
// Le pave et le curseur
  int xpav, ypav;
  int xpv0, ypv0;
  int xmv0, ymv0;
  int dxmv, dymv;
  int xcurs, ycurs;  // Position curseur
  int cuhsz, cuvsz;  // Taille vertical, horizontal curseur
  PILineAtt culat;   // Attribut de ligne du curseur  
  PIColors cucol;    // Attribut de couleur du curseur
  int xszpav, yszpav;
// Pour gerer une fenetre pour les coupes en X,Y
  unsigned short selcuts;
  PIWindow * cutwin;
  PIScDrawWdg * cutscw;
  PIImg1DArrAdapter * cutarrx; 
  PIImg1DArrAdapter * cutarry; 
  PIImg1DArrAdapter * cutarrd; 
  PIImg1DArrAdapter * cutarra; 

// buffer pour copier-coller
  char* cpbuffer;
  int cpbuflen;
//  PIImage courante 
  static PIImage* cur_piimage;

// Menu pour la manipulation des drawers 
  PIDrwMgrMenu* mDrwMen;
};

// Classe regroupant un PIImage, Widget Zoom et Widget Naviguator
class PIImageNavigator : public PIContainer
{
public:
  enum {ClassId = 5155};

                     PIImageNavigator(PIContainer *par, const char *nom, 
                                     int sx=500, int sy=500, int px=0, int py=0);
  virtual            ~PIImageNavigator();
  virtual long       kind() {return ClassId; }

  inline PIImage*    ImageWdg() { return piimg; }

protected:
  PIImage* piimg;
  PIPixmap* zoom;
  PIPixmap* gimv;
  PICMapView* cmapv;
};

#endif
