// Module PI : Peida Interactive     PIPixmap
// Classes utilitaires pour representation de pixels et couleurs RGB pour PI
//                             R. Ansari  09/2008
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
using namespace std;

#include "pipixutils.h"

//++
// Class	PIPixColIdx
// Lib		PI
// include	pipixmapgen.h
//
//   	Classe auxiliaire de gestion d'index de couleurs pour les pixmap,
//	organise en interne en byte ou short.
//--

PIPixColIdx::PIPixColIdx()
{
  pix8 = NULL;
  pix16 = NULL;
  sx_ = sy_ = 0;
}

PIPixColIdx::~PIPixColIdx()
{
  if (pix8)  delete[] pix8;
  if (pix16)  delete[] pix16;
}

void PIPixColIdx::AllocateByte(int sx, int sy)
{
  size_t osz = sx_*sy_;
  if (sx<=0)  sx=sy=0;
  else if (sy<=0)  sx=sy=0;
  sx_ = sx; sy_ = sy; 
  if (pix16)  delete[] pix16;
  pix16 = NULL;
  size_t nsz = sx_*sy_;
  if (pix8) {
    if (osz == nsz) return;
    delete[] pix8;   pix8 = NULL;
  }
  if ((nsz > 0)&&(pix8==NULL)) {
    pix8 = new unsigned char[nsz];
  }
}

void PIPixColIdx::AllocateShort(int sx, int sy)
{
  size_t osz = sx_*sy_;
  if (sx<=0)  sx=sy=0;
  else if (sy<=0)  sx=sy=0;
  sx_ = sx; sy_ = sy; 
  if (pix8)  delete[] pix8;
  pix8 = NULL;
  size_t nsz = sx_*sy_;
  if (pix16) {
    if (osz == nsz) return;
    delete[] pix16;   pix16 = NULL;
  }
  if ((nsz > 0)&&(pix16==NULL)) 
    pix16 = new unsigned short[nsz];
}


//++
// Class	PIPixRGBArray
// Lib		PI
// include	pipixmapgen.h
//
//   	Classe auxiliaire de gestion tableau representant des pixels RGB,
//	chaque composante codee en 8 bits (unsigned char)
//--

PIPixRGBArray::PIPixRGBArray(int sx, int sy)
{
  if (sx < 0) sx = 0;
  if (sy < 0) sy = 0;
  sx_ = sx;  sy_ = sy;	
  size_t sz = sx_*sy_;
  if (sz>0) rgbpix_ = new PIPixRGB[sz];
  else rgbpix_ = NULL;  
}

PIPixRGBArray::PIPixRGBArray(const char * filename)
{
  sx_ = sy_ = 0;
  rgbpix_ = NULL; 
  // lecture fichier a faire 	
}

PIPixRGBArray::~PIPixRGBArray()
{
  if (rgbpix_) delete[] rgbpix_;	
}

void PIPixRGBArray::SaveToFile(const char * filename)
{
  // ECRIRE fichier A FAIRE
  return;	
}


