#include <iostream>

#include "racqumem.h"
#include "racqurw.h"
#include "racquproc.h"

#include "pciewrap.h"
#include "brpaqu.h"
#include "minifits.h"

#include "resusage.h"
#include "ctimer.h"
#include "timing.h"

#include "tarrinit.h"
#include "fiosinit.h"

using namespace std;
using namespace SOPHYA;

//--------------------------------------------------------
// Programme test acquisition BAORadio multi-thread
//  LAL -   R. Ansari Juillet -  2008
//--------------------------------------------------------

int main(int narg, char* arg[])
{
 
  int rc = 0;
  InitTim();
 
  // Initialisation 
  TArrayInitiator _arri;
  FitsIOServerInitiator _fiosi;
  
  Timer tm("tmtacq");
  string dir = "ExA";
  cout << "tmtacq[1] - starting acq program " << endl;
  
  try {
    RAcqMemZoneMgr mmgr(3,100,4096);
    PCIEReader pcir(mmgr, 10);
    DataSaver ds(mmgr, dir, 10);
    DataProc pr(mmgr, dir, 1, 10);
    tm.Split("Threads created");  
    cout << "tmtacq[2] - starting 3 threads pcir, ds, pr ... " << endl;
    pcir.start();
    ds.start();
    pr.start();
    cout << "tmtacq[3] - waiting for threads to finish ... " << endl;
    sleep(1);
    pcir.join();
    ds.join();
    sleep(1);
    mmgr.Stop();
    pr.join();
    cout << "tmtacq[4] - threads finished " << endl;
    tm.Split("Threads Finished");  
    mmgr.Print(cout);
    rc = 0;
  }
  catch (MiniFITSException& exc) {
    cerr << " tmtacq.cc catched MiniFITSException " << exc.Msg() << endl;
    rc = 77;
  }  
  catch (PThrowable& exc) {
    cerr << " tmtacq.cc catched Exception " << exc.Msg() << endl;
    rc = 76;
  }  
  catch (std::exception& sex) {
    cerr << "\n tmtacq.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
  	cerr << " tmtacq.cc : Catched ... exception " << endl;
  	rc = 79;
  }
  cout << "tmtacq[9] - stopping acq program " << endl;
  return rc;
}
