#include "sopnamsp.h"
#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <math.h>

#include <typeinfo>

#include <vector>
#include <string>

#include "tvector.h"
#include "piacmd.h"
#include "nobjmgr.h"
#include "pistdimgapp.h"


//  Module pour lire les fichiers generes par Monique pour Acq-BAORadio

//  Declaration de la fonction d'activation et de desactivation du module
extern "C" {
void BAORadio_init();
void BAORadio_end();
}


//  Une classe commande-executor, permettant d'enregistrer de 
//  nouvelles commandes a piapp
class BAORadioExecutor : public CmdExecutor {
public:
                BAORadioExecutor();
  virtual       ~BAORadioExecutor();
  // Execute s'occupe de l'execution effective des commandes
  virtual int   Execute(string& keyw, vector<string>& args, string& toks);
};

/* --Methode-- */
BAORadioExecutor::BAORadioExecutor()
{

PIACmd * mpiac;
NamedObjMgr omg;
mpiac = omg.GetImgApp()->CmdInterpreter();

// On enregistre deux nouvelles commandes 
string hgrp = "BAORadioCmd";
// commande excmd1
string kw = "brrdfile";
string usage = "brrdfile: Lecture fichier AcqBAORadio \n" ;
usage += "Usage: brrdfile size fileName [objName] \n";
usage += " Defaut objName= data";
mpiac->RegisterCommand(kw, usage, this, hgrp);

}

/* --Methode-- */
BAORadioExecutor::~BAORadioExecutor()
{

}


static inline void bswap4(void* p)
{
  uint_4 tmp = *(uint_4*)p;
  *(uint_4*)p = ((tmp >> 24) & 0x000000FF) | 
                ((tmp >> 8)  & 0x0000FF00) |
                ((tmp & 0x0000FF00) << 8)  |
                ((tmp & 0x000000FF) << 24);
}



/* --Methode-- */
int BAORadioExecutor::Execute(string& kw, vector<string>& tokens, string&)
{

NamedObjMgr omg;
if (kw == "brrdfile") {
  if (tokens.size() < 2) {
    cout << "Usage: brrdfile size fileName [objName]" << endl;
    return(0);
    }
  sa_size_t sz = atoi(tokens[0].c_str()); 
  string filename = tokens[1];
  string objname = "data";
  if (tokens.size() > 2) objname = tokens[2];

  cout << " brrdfile : reading from file " << filename 
       << " Size=" << sz << endl;
  TVector<int_2> data(sz);
  TVector<r_8> ddata(sz);
  FILE *fip = NULL;
  fip = fopen(filename.c_str(),"rb");
  if (fip == NULL) {
    cout << " brrdfile : ERROR opening file" << endl;
    return 1;
  }
  uint_1* buff = new uint_1[sz/4+1];
  fread(buff, 1, (size_t)(sz), fip);
  uint_4* first = (uint_4*)(buff);
  uint_4* second = (uint_4*)(buff+4);
  cout << " brrdfile, first uint_4= " << hex << (*first) 
       << " second= " << (*second) << dec << endl;
  //  uint_1* buff = (uint_1 *)buff4;
  //  for(sa_size_t ka=0; ka<sz/4; ka++) bswap4(buff4+ka);
  for(sa_size_t ka=0; ka<sz; ka+=4) {
    if (ka>=sz-3)  break;
    for(sa_size_t kb=0; kb<4; kb++) 
      data(ka+kb) = (int_2)buff[ka+3-kb];
  }
//  for(sa_size_t k=0; k<sz; k++) data(k) = (int_2)buff[k];
  fclose(fip);
  delete[] buff;
  omg.AddObj(data, objname);
  ddata = data;
  objname += "_f";
  omg.AddObj(ddata, objname);
  }
/*
else if (kw == "excmd2") {
  }
*/
return(0);

}

static BAORadioExecutor * baoradioex = NULL;
/* Nouvelle-Fonction */
void BAORadio_init()
{
// Fonction d'initialisation du module
// Appele par le gestionnaire de modules de piapp (PIACmd::LoadModule())
if (baoradioex) delete baoradioex;
baoradioex = new BAORadioExecutor;
}

/* Nouvelle-Fonction */
void BAORadio_end()
{
// Desactivation du module
if (baoradioex) delete baoradioex;
baoradioex = NULL;
}

