#include "brpaqu.h"


static inline void bswap4(void* p)
{
  UInt32 tmp = *(UInt32*)p;
  *(UInt32*)p = ((tmp >> 24) & 0x000000FF) |
                ((tmp >> 8)  & 0x0000FF00) |
                ((tmp & 0x0000FF00) << 8)  |
                ((tmp & 0x000000FF) << 24);
}

BRPaquet::BRPaquet(Byte* src, Byte* dst, int paqsz)
{
  dst_ = dst;
  sz_ = paqsz;
  if ((src==NULL)||(dst==NULL))  return;
  // On copie l'entete sans swapper 
  for(int k=0; k<BRHDRSIZE; k++)  dst_[k] = src[k];
  // On copie la zone donnees en faisant un byte-swap correspondant a 4 octets 
   for(int ka=BRHDRSIZE; ka<sz_-BRTRLSIZE; ka+=4) {
    for(int kb=0; kb<4; kb++)
      dst_[ka+kb] = src[ka+3-kb];
  }
  // On copie le trailer sans swapper 
  for(int k=sz_-1; k>=sz_-BRTRLSIZE; k--)  dst_[k] = src[k];

}


void BRPaquet::Print(ostream & os, int nelt, bool prht)
{
  os << "BRPaquet::Print() PaqSz=" << PaquetSize() << " DataSize=" << DataSize() 
     << " dst_pointer=(hex)" << hex << (unsigned long)dst_ << dec << endl;
  if (TrailerSize() > 0) 
    os << " ...HDRMarker(hex)=" << hex <<  HDRMarker() << " TRLMarker=" << TRLMarker() << dec << endl;
  else 
    os << " ...HDRMarker(hex)=" << hex <<  HDRMarker() << " NO TRLMarker=" << dec << endl;
  UInt32 tt1, tt2; 
//  tt2 = (TimeTag()&0xFFFFFFFF00000000) >> 32; 
  tt2=0; 
  tt1 = TimeTag()&0x00000000FFFFFFFF;
  os << " ...TimeTag (hex)=" << hex << TimeTag() << " TT1= " << tt1 << " TT2=" << tt2 << dec << endl;
  if (nelt > DataSize()/2) nelt = DataSize()/2;
  os << " ...Data[1.." << nelt << "]= ";
  for(int k=0; k<nelt; k++) os << (int)(*(Data()+k)) << " , ";
  os << endl;
  os << " ...Data[" << DataSize()-nelt << ".." << DataSize()-1 << "]= ";
  for(int k=DataSize()-nelt; k<DataSize(); k++) os << (int)(*(Data()+k)) << " , ";
  os << endl;
  if (prht) {   // Impression header / trailer
    UInt32* hdr = (UInt32*)Header();
    os << " ...Header (hex):" << hex ;
    for(int k=0; k<HeaderSize()/sizeof(UInt32); k++) 
      os << hdr[k] << " , " ;
    os << dec << endl;
    if (TrailerSize() > 0) {
      UInt32* trl = (UInt32*)Trailer();
      os << " ...Trailer (hex):" << hex ;
      for(int k=0; k<TrailerSize()/sizeof(UInt32); k++) 
        os << trl[k] << " , " ;
      os << dec << endl;
    }
  }
}
